/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ChooseOneOrAllRunnable<T extends PsiElement>
implements Runnable {
    private final T[] myClasses;
    private final Editor myEditor;
    private final @NlsContexts.PopupTitle String myTitle;

    public ChooseOneOrAllRunnable(@NotNull List<? extends T> classes, @NotNull Editor editor, @NotNull @NlsContexts.PopupTitle String title2, @NotNull Class<T> type) {
        if (classes == null) {
            ChooseOneOrAllRunnable.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ChooseOneOrAllRunnable.$$$reportNull$$$0(1);
        }
        if (title2 == null) {
            ChooseOneOrAllRunnable.$$$reportNull$$$0(2);
        }
        if (type == null) {
            ChooseOneOrAllRunnable.$$$reportNull$$$0(3);
        }
        this.myClasses = (PsiElement[])ArrayUtil.toObjectArray(classes, type);
        this.myEditor = editor;
        this.myTitle = title2;
    }

    protected abstract void selected(T ... var1);

    @Override
    public void run() {
        if (this.myClasses.length == 1) {
            this.selected((PsiElement[])ArrayUtil.toObjectArray(this.myClasses[0].getClass(), (Object[])new Object[]{this.myClasses[0]}));
        } else if (this.myClasses.length > 0) {
            PsiElementListCellRenderer<T> renderer2 = this.createRenderer();
            Arrays.sort(this.myClasses, renderer2.getComparator());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.selected((PsiElement[])this.myClasses);
                return;
            }
            ArrayList<T> model2 = new ArrayList<T>(Arrays.asList(this.myClasses));
            String selectAll2 = CodeInsightBundle.message((String)"highlight.thrown.exceptions.chooser.all.entry", (Object[])new Object[0]);
            model2.add(0, selectAll2);
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(model2).setRenderer(renderer2).setSelectionMode(0).setItemChosenCallback(selectedValue -> {
                if (selectedValue.equals(selectAll2)) {
                    this.selected((PsiElement[])this.myClasses);
                } else {
                    this.selected((PsiElement[])ArrayUtil.toObjectArray(selectedValue.getClass(), (Object[])new Object[]{selectedValue}));
                }
            }).setTitle(this.myTitle);
            renderer2.installSpeedSearch(builder2);
            ApplicationManager.getApplication().invokeLater(() -> builder2.createPopup().showInBestPositionFor(this.myEditor));
        }
    }

    @NotNull
    protected abstract PsiElementListCellRenderer<T> createRenderer();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "classes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/highlighting/ChooseOneOrAllRunnable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

