/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"createExcludeListEditorField", "Lcom/intellij/ui/EditorTextField;", "text", "", "getBlacklistExplanationHTML", "language", "Lcom/intellij/lang/Language;", "getLanguageExcludeList", "highlightErrorLines", "", "lines", "", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
public final class ExcludeListPanelKt {
    private static final String getLanguageExcludeList(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            return "";
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        Diff diff = ParameterNameHintsSettings.Companion.getInstance().getBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language));
        Set set2 = hintsProvider.getDefaultBlackList();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"hintsProvider.defaultBlackList");
        Set excludeList = diff.applyOn(set2);
        String string = StringUtil.join((Collection)excludeList, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(excludeList, \"\\n\")");
        return string;
    }

    private static final EditorTextField createExcludeListEditorField(String text2) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"EditorFactory.getInstance().createDocument(text)");
        Document document2 = document;
        EditorTextField field = new EditorTextField(document2, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(400, 350));
        field.addSettingsProvider(new EditorSettingsProvider(text2){
            final /* synthetic */ String $text;

            public final void customizeSettings(EditorEx editor) {
                editor.setVerticalScrollbarVisible(true);
                editor.setHorizontalScrollbarVisible(true);
                EditorEx editorEx = editor;
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                EditorSettings editorSettings = editorEx.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
                editorSettings.setAdditionalLinesCount(2);
                ExcludeListPanelKt.access$highlightErrorLines(HintUtilsKt.getExcludeListInvalidLineNumbers(this.$text), editor);
            }
            {
                this.$text = string;
            }
        });
        return field;
    }

    private static final void highlightErrorLines(List<Integer> lines2, Editor editor) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int totalLines = document2.getLineCount();
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"editor.markupModel");
        MarkupModel model2 = markupModel;
        model2.removeAllHighlighters();
        lines2.stream().filter(new Predicate(totalLines){
            final /* synthetic */ int $totalLines;

            public final boolean test(Integer current2) {
                return Intrinsics.compare((int)current2, (int)this.$totalLines) < 0;
            }
            {
                this.$totalLines = n;
            }
        }).forEach(new Consumer(model2){
            final /* synthetic */ MarkupModel $model;

            public final void accept(Integer line) {
                Integer n = line;
                Intrinsics.checkNotNull((Object)n);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"line!!");
                this.$model.addLineHighlighter(CodeInsightColors.ERRORS_ATTRIBUTES, n.intValue(), 5000);
            }
            {
                this.$model = markupModel;
            }
        });
    }

    @NlsContexts.DetailedDescription
    private static final String getBlacklistExplanationHTML(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            String string = CodeInsightBundle.message((String)"inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026ist.pattern.explanation\")");
            return string;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        String string = hintsProvider.getBlacklistExplanationHTML();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hintsProvider.blacklistExplanationHTML");
        return string;
    }

    public static final /* synthetic */ String access$getLanguageExcludeList(Language language) {
        return ExcludeListPanelKt.getLanguageExcludeList(language);
    }

    public static final /* synthetic */ EditorTextField access$createExcludeListEditorField(String text2) {
        return ExcludeListPanelKt.createExcludeListEditorField(text2);
    }

    public static final /* synthetic */ String access$getBlacklistExplanationHTML(Language language) {
        return ExcludeListPanelKt.getBlacklistExplanationHTML(language);
    }

    public static final /* synthetic */ void access$highlightErrorLines(List lines2, Editor editor) {
        ExcludeListPanelKt.highlightErrorLines(lines2, editor);
    }
}

