/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsUpdater {
    private static final Key<Boolean> HINT_REMOVAL_DELAYED = Key.create((String)"hint.removal.delayed");
    private static final Key<Boolean> REPEATED_PASS = Key.create((String)"RepeatedParameterHintsPass");
    private final ParameterHintsPresentationManager myHintsManager;
    private final TIntObjectHashMap<Caret> myCaretMap;
    private final TIntObjectHashMap<List<ParameterHintsPass.HintData>> myNewHints;
    private final TIntObjectHashMap<String> myHintsToPreserve;
    private final boolean myForceImmediateUpdate;
    private final Editor myEditor;
    @NotNull
    private final List<? extends Inlay> myEditorInlays;
    private List<InlayUpdateInfo> myUpdateList;

    ParameterHintsUpdater(@NotNull Editor editor, @NotNull List<? extends Inlay> editorInlays, @NotNull TIntObjectHashMap<List<ParameterHintsPass.HintData>> newHints, @NotNull TIntObjectHashMap<String> hintsToPreserve, boolean forceImmediateUpdate) {
        if (editor == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(0);
        }
        if (editorInlays == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(1);
        }
        if (newHints == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(2);
        }
        if (hintsToPreserve == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(3);
        }
        this.myHintsManager = ParameterHintsPresentationManager.getInstance();
        this.myEditor = editor;
        this.myNewHints = newHints;
        this.myHintsToPreserve = hintsToPreserve;
        this.myForceImmediateUpdate = forceImmediateUpdate;
        this.myCaretMap = new TIntObjectHashMap();
        List allCarets = this.myEditor.getCaretModel().getAllCarets();
        allCarets.forEach(caret -> this.myCaretMap.put(caret.getOffset(), caret));
        this.myEditorInlays = editorInlays;
    }

    @NotNull
    private List<InlayUpdateInfo> getInlayUpdates(@NotNull List<? extends Inlay> editorHints) {
        if (editorHints == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(4);
        }
        this.myEditor.putUserData(HINT_REMOVAL_DELAYED, (Object)Boolean.FALSE);
        ArrayList<InlayUpdateInfo> updates2 = new ArrayList<InlayUpdateInfo>();
        editorHints.forEach(editorHint -> {
            String newText;
            int offset = editorHint.getOffset();
            ParameterHintsPass.HintData newHint = ParameterHintsUpdater.findAndRemoveMatchingHint(offset, editorHint.isRelatedToPrecedingText(), this.myNewHints);
            if (!this.myForceImmediateUpdate && this.delayRemoval((Inlay)editorHint)) {
                this.myEditor.putUserData(HINT_REMOVAL_DELAYED, (Object)Boolean.TRUE);
                return;
            }
            String string = newText = newHint == null ? null : newHint.presentationText;
            if (this.isPreserveHint((Inlay)editorHint, newText)) {
                return;
            }
            updates2.add(new InlayUpdateInfo(offset, (Inlay)editorHint, newHint));
        });
        Arrays.stream(this.myNewHints.keys()).forEach(offset -> {
            for (ParameterHintsPass.HintData hint : (List)this.myNewHints.get(offset)) {
                updates2.add(new InlayUpdateInfo(offset, null, hint));
            }
        });
        updates2.sort(Comparator.comparing(update2 -> update2.offset));
        ArrayList<InlayUpdateInfo> arrayList = updates2;
        if (arrayList == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    static boolean hintRemovalDelayed(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(6);
        }
        return editor.getUserData(HINT_REMOVAL_DELAYED) == Boolean.TRUE;
    }

    @Nullable
    private static ParameterHintsPass.HintData findAndRemoveMatchingHint(int offset, boolean relatesToPrecedingText, TIntObjectHashMap<List<ParameterHintsPass.HintData>> data2) {
        List newHintList = (List)data2.get(offset);
        ParameterHintsPass.HintData newHint = null;
        if (newHintList != null) {
            Iterator iterator2 = newHintList.iterator();
            while (iterator2.hasNext()) {
                ParameterHintsPass.HintData hint = (ParameterHintsPass.HintData)iterator2.next();
                if (hint.relatesToPrecedingText != relatesToPrecedingText) continue;
                newHint = hint;
                iterator2.remove();
                break;
            }
            if (newHintList.isEmpty()) {
                data2.remove(offset);
            }
        }
        return newHint;
    }

    private boolean isPreserveHint(@NotNull Inlay inlay, @Nullable String newText) {
        if (inlay == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            newText = (String)this.myHintsToPreserve.get(inlay.getOffset());
        }
        String oldText = this.myHintsManager.getHintText(inlay);
        return Objects.equals(newText, oldText);
    }

    public void update() {
        this.myUpdateList = this.getInlayUpdates(this.myEditorInlays);
        boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
        boolean isUpdateInBulkMode = this.myUpdateList.size() > 1000;
        this.myEditor.getInlayModel().execute(isUpdateInBulkMode, () -> this.performHintsUpdate(firstTime, isUpdateInBulkMode));
        this.myEditor.putUserData(REPEATED_PASS, (Object)Boolean.TRUE);
    }

    private void performHintsUpdate(boolean firstTime, boolean isInBulkMode) {
        for (int infoIndex = 0; infoIndex < this.myUpdateList.size(); ++infoIndex) {
            boolean useAnimation;
            InlayUpdateInfo info2 = this.myUpdateList.get(infoIndex);
            String oldText = info2.oldText;
            String newText = info2.newText;
            InlayUpdateInfo.Action action2 = info2.action();
            if (action2 == InlayUpdateInfo.Action.ADD) {
                useAnimation = !this.myForceImmediateUpdate && !firstTime && !this.isSameHintRemovedNear(newText, infoIndex) && !isInBulkMode;
                Inlay inlay = this.myHintsManager.addHint(this.myEditor, info2.offset, info2.relatesToPrecedingText, newText, info2.widthAdjustment, useAnimation);
                if (inlay == null || isInBulkMode) continue;
                VisualPosition inlayPosition = inlay.getVisualPosition();
                VisualPosition visualPosition = new VisualPosition(inlayPosition.line, inlayPosition.column + (info2.relatesToPrecedingText ? 1 : 0));
                Caret caret = this.myEditor.getCaretModel().getCaretAt(visualPosition);
                if (caret == null) continue;
                caret.moveToVisualPosition(new VisualPosition(inlayPosition.line, inlayPosition.column + (info2.relatesToPrecedingText ? 0 : 1)));
                continue;
            }
            if (action2 == InlayUpdateInfo.Action.DELETE) {
                useAnimation = !this.myForceImmediateUpdate && oldText != null && !this.isSameHintAddedNear(oldText, infoIndex) && !isInBulkMode;
                this.myHintsManager.deleteHint(this.myEditor, info2.inlay, useAnimation);
                continue;
            }
            if (action2 != InlayUpdateInfo.Action.REPLACE) continue;
            this.myHintsManager.replaceHint(this.myEditor, info2.inlay, newText, info2.widthAdjustment, !this.myForceImmediateUpdate);
        }
    }

    private boolean isSameHintRemovedNear(@NotNull String text2, int index2) {
        if (text2 == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(8);
        }
        return this.getInfosNear(index2).anyMatch(info2 -> text2.equals(info2.oldText));
    }

    private boolean isSameHintAddedNear(@NotNull String text2, int index2) {
        if (text2 == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(9);
        }
        return this.getInfosNear(index2).anyMatch(info2 -> text2.equals(info2.newText));
    }

    private Stream<InlayUpdateInfo> getInfosNear(int index2) {
        ArrayList<InlayUpdateInfo> result2 = new ArrayList<InlayUpdateInfo>();
        if (index2 > 0) {
            result2.add(this.myUpdateList.get(index2 - 1));
        }
        if (index2 + 1 < this.myUpdateList.size()) {
            result2.add(this.myUpdateList.get(index2 + 1));
        }
        return result2.stream();
    }

    private boolean delayRemoval(@NotNull Inlay inlay) {
        int offset;
        Caret caret;
        if (inlay == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(10);
        }
        if ((caret = (Caret)this.myCaretMap.get(offset = inlay.getOffset())) == null) {
            return false;
        }
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        if (offset >= text2.length()) {
            return false;
        }
        char afterCaret = text2.charAt(offset);
        if (afterCaret != ',' && afterCaret != ')') {
            return false;
        }
        VisualPosition afterInlayPosition = this.myEditor.offsetToVisualPosition(offset, true, false);
        return caret.getVisualPosition().equals((Object)afterInlayPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInlays";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintsToPreserve";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHints";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/ParameterHintsUpdater";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInlayUpdates";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hintRemovalDelayed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPreserveHint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameHintRemovedNear";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSameHintAddedNear";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "delayRemoval";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InlayUpdateInfo {
        public final int offset;
        public final Inlay inlay;
        public final String newText;
        public final String oldText;
        public final boolean relatesToPrecedingText;
        public final HintWidthAdjustment widthAdjustment;

        InlayUpdateInfo(int offset, @Nullable Inlay current2, @Nullable ParameterHintsPass.HintData newHintData) {
            this.offset = offset;
            this.inlay = current2;
            String string = this.oldText = this.inlay == null ? null : ParameterHintsPresentationManager.getInstance().getHintText(this.inlay);
            if (newHintData == null) {
                this.newText = null;
                this.relatesToPrecedingText = false;
                this.widthAdjustment = null;
            } else {
                this.newText = newHintData.presentationText;
                this.relatesToPrecedingText = newHintData.relatesToPrecedingText;
                this.widthAdjustment = newHintData.widthAdjustment;
            }
        }

        public Action action() {
            if (this.inlay == null) {
                return this.newText != null ? Action.ADD : Action.SKIP;
            }
            return this.newText != null ? Action.REPLACE : Action.DELETE;
        }

        public static enum Action {
            ADD,
            DELETE,
            REPLACE,
            SKIP;

        }
    }
}

