/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InsetPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StaticDelegatePresentation;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "left", "", "right", "top", "down", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;IIII)V", "getDown", "()I", "height", "getHeight", "isPresentationUnderCursor", "", "getLeft", "getRight", "getTop", "width", "getWidth", "handleMouse", "", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.lang.impl"})
public final class InsetPresentation
extends StaticDelegatePresentation {
    private boolean isPresentationUnderCursor;
    private final int left;
    private final int right;
    private final int top;
    private final int down;

    @Override
    public int getWidth() {
        return this.getPresentation().getWidth() + this.left + this.right;
    }

    @Override
    public int getHeight() {
        return this.getPresentation().getHeight() + this.top + this.down;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        PresentationUtilKt.withTranslated(g, this.left, this.top, (Function0<Unit>)((Function0)new Function0<Unit>(this, g, attributes2){
            final /* synthetic */ InsetPresentation this$0;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ TextAttributes $attributes;

            public final void invoke() {
                this.this$0.getPresentation().paint(this.$g, this.$attributes);
            }
            {
                this.this$0 = insetPresentation;
                this.$g = graphics2D;
                this.$attributes = textAttributes;
                super(0);
            }
        }));
    }

    private final void handleMouse(Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        boolean cursorIsOutOfBounds;
        int x = original.x;
        int y = original.y;
        boolean bl = cursorIsOutOfBounds = x < this.left || x >= this.left + this.getPresentation().getWidth() || y < this.top || y >= this.top + this.getPresentation().getHeight();
        if (cursorIsOutOfBounds) {
            if (this.isPresentationUnderCursor) {
                this.getPresentation().mouseExited();
                this.isPresentationUnderCursor = false;
            }
            return;
        }
        Point translated = PresentationUtilKt.translateNew(original, -this.left, -this.top);
        action2.invoke((Object)this.getPresentation(), (Object)translated);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseMoved(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    @Override
    public void mouseExited() {
        this.getPresentation().mouseExited();
        this.isPresentationUnderCursor = false;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getDown() {
        return this.down;
    }

    public InsetPresentation(@NotNull InlayPresentation presentation2, int left, int right, int top, int down) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        super(presentation2);
        this.left = left;
        this.right = right;
        this.top = top;
        this.down = down;
    }

    public /* synthetic */ InsetPresentation(InlayPresentation inlayPresentation, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(inlayPresentation, n, n2, n3, n4);
    }
}

