/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupUsageDescriptor;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LookupUsageTracker {
    private static final String GROUP_ID = "completion";
    private static final String EVENT_ID = "finished";

    private LookupUsageTracker() {
    }

    /*
     * WARNING - void declaration
     */
    static void trackLookup(long createdTimestamp, @NotNull LookupImpl lookupImpl) {
        void lookup2;
        if (lookupImpl == null) {
            LookupUsageTracker.$$$reportNull$$$0(0);
        }
        lookup2.addLookupListener(new MyLookupTracker(createdTimestamp, (LookupImpl)lookup2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/impl/LookupUsageTracker", "trackLookup"));
    }

    private static enum CompletionChar {
        ENTER,
        TAB,
        COMPLETE_STATEMENT,
        AUTO_INSERT,
        OTHER;


        static CompletionChar of(char completionChar) {
            switch (completionChar) {
                case '\n': {
                    return ENTER;
                }
                case '\t': {
                    return TAB;
                }
                case '\u0000': {
                    return AUTO_INSERT;
                }
                case '\r': {
                    return COMPLETE_STATEMENT;
                }
            }
            return OTHER;
        }
    }

    private static enum FinishType {
        TYPED,
        EXPLICIT,
        CANCELED_EXPLICITLY,
        CANCELED_BY_TYPING;

    }

    private static class MyLookupTracker
    implements LookupListener {
        private final LookupImpl myLookup;
        private final long myCreatedTimestamp;
        private final long myTimeToShow;
        private final boolean myIsDumbStart;
        private final Language myLanguage;
        private final MyTypingTracker myTypingTracker;
        private int mySelectionChangedCount;

        /*
         * WARNING - void declaration
         */
        MyLookupTracker(long createdTimestamp, @NotNull LookupImpl lookupImpl) {
            void lookup2;
            if (lookupImpl == null) {
                MyLookupTracker.$$$reportNull$$$0(0);
            }
            this.mySelectionChangedCount = 0;
            this.myLookup = lookup2;
            this.myCreatedTimestamp = createdTimestamp;
            this.myTimeToShow = System.currentTimeMillis() - createdTimestamp;
            this.myIsDumbStart = DumbService.isDumb((Project)lookup2.getProject());
            this.myLanguage = MyLookupTracker.getLanguageAtCaret((LookupImpl)lookup2);
            this.myTypingTracker = new MyTypingTracker();
            lookup2.addPrefixChangeListener(this.myTypingTracker, (Disposable)lookup2);
        }

        public void currentItemChanged(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(1);
            }
            ++this.mySelectionChangedCount;
        }

        private boolean isSelectedByTyping(@NotNull LookupElement item) {
            if (item == null) {
                MyLookupTracker.$$$reportNull$$$0(2);
            }
            return this.myLookup.itemPattern(item).equals(item.getLookupString());
        }

        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(3);
            }
            LookupElement item = event.getItem();
            char completionChar = event.getCompletionChar();
            if (item == null) {
                this.triggerLookupUsed(FinishType.CANCELED_BY_TYPING, null, completionChar);
            } else if (this.isSelectedByTyping(item)) {
                this.triggerLookupUsed(FinishType.TYPED, item, completionChar);
            } else {
                this.triggerLookupUsed(FinishType.EXPLICIT, item, completionChar);
            }
        }

        public void lookupCanceled(@NotNull LookupEvent event) {
            LookupElement item;
            if (event == null) {
                MyLookupTracker.$$$reportNull$$$0(4);
            }
            if ((item = this.myLookup.getCurrentItem()) != null && this.isSelectedByTyping(item)) {
                this.triggerLookupUsed(FinishType.TYPED, item, event.getCompletionChar());
            } else {
                FinishType detailedCancelType = event.isCanceledExplicitly() ? FinishType.CANCELED_EXPLICITLY : FinishType.CANCELED_BY_TYPING;
                this.triggerLookupUsed(detailedCancelType, null, event.getCompletionChar());
            }
        }

        private void triggerLookupUsed(@NotNull FinishType finishType, @Nullable LookupElement currentItem, char completionChar) {
            if (finishType == null) {
                MyLookupTracker.$$$reportNull$$$0(5);
            }
            FeatureUsageData data2 = new FeatureUsageData();
            this.addCommonUsageInfo(data2, finishType, currentItem, completionChar);
            LookupUsageDescriptor.EP_NAME.forEachExtensionSafe(usageDescriptor -> {
                if (PluginInfoDetectorKt.getPluginInfo(usageDescriptor.getClass()).isSafeToReport()) {
                    FeatureUsageData additionalData = new FeatureUsageData();
                    usageDescriptor.fillUsageData(this.myLookup, additionalData);
                    data2.addAll(additionalData);
                }
            });
            FUCounterUsageLogger.getInstance().logEvent(this.myLookup.getProject(), LookupUsageTracker.GROUP_ID, LookupUsageTracker.EVENT_ID, data2);
        }

        private void addCommonUsageInfo(@NotNull FeatureUsageData data2, @NotNull FinishType finishType, @Nullable LookupElement currentItem, char completionChar) {
            String schema2;
            VirtualFile vFile;
            if (data2 == null) {
                MyLookupTracker.$$$reportNull$$$0(6);
            }
            if (finishType == null) {
                MyLookupTracker.$$$reportNull$$$0(7);
            }
            data2.addLanguage(this.myLanguage);
            PsiFile file2 = this.myLookup.getPsiFile();
            if (file2 != null && (vFile = file2.getVirtualFile()) != null && (schema2 = FileTypeUsageCounterCollector.findSchema(this.myLookup.getProject(), vFile)) != null) {
                data2.addData("schema", schema2);
            }
            data2.addData("alphabetically", UISettings.getInstance().getSortLookupElementsLexicographically());
            data2.addData("finish_type", finishType.toString());
            data2.addData("duration", System.currentTimeMillis() - this.myCreatedTimestamp);
            data2.addData("selected_index", this.myLookup.getSelectedIndex());
            data2.addData("selection_changed", this.mySelectionChangedCount);
            data2.addData("typing", this.myTypingTracker.typing);
            data2.addData("backspaces", this.myTypingTracker.backspaces);
            data2.addData("completion_char", CompletionChar.of(completionChar).toString());
            if (currentItem != null) {
                data2.addData("token_length", currentItem.getLookupString().length());
                data2.addData("query_length", this.myLookup.itemPattern(currentItem).length());
                CompletionContributor contributor = (CompletionContributor)currentItem.getUserData(BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR);
                if (contributor != null) {
                    PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(contributor.getClass());
                    data2.addData("contributor", info2.isSafeToReport() ? contributor.getClass().getName() : "third.party");
                }
            }
            data2.addData("time_to_show", this.myTimeToShow);
            data2.addData("dumb_start", this.myIsDumbStart);
            data2.addData("dumb_finish", DumbService.isDumb((Project)this.myLookup.getProject()));
        }

        @Nullable
        private static Language getLanguageAtCaret(@NotNull LookupImpl lookup2) {
            PsiFile psiFile;
            if (lookup2 == null) {
                MyLookupTracker.$$$reportNull$$$0(8);
            }
            if ((psiFile = lookup2.getPsiFile()) != null) {
                return PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)lookup2.getEditor().getCaretModel().getOffset());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookup";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finishType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupUsageTracker$MyLookupTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentItemChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelectedByTyping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookupCanceled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "triggerLookupUsed";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCommonUsageInfo";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLanguageAtCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyTypingTracker
        implements PrefixChangeListener {
            int backspaces = 0;
            int typing = 0;

            private MyTypingTracker() {
            }

            @Override
            public void beforeTruncate() {
                ++this.backspaces;
            }

            @Override
            public void beforeAppend(char c) {
                ++this.typing;
            }
        }
    }
}

