/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;
    private final boolean myCheckCompletionChar;

    protected BaseCompleteMacro(@NonNls String name) {
        this(name, true);
    }

    protected BaseCompleteMacro(@NonNls String name, boolean checkCompletionChar) {
        this.myName = name;
        this.myCheckCompletionChar = checkCompletionChar;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public final Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        if (params == null) {
            BaseCompleteMacro.$$$reportNull$$$0(0);
        }
        return new InvokeActionResult(() -> this.invokeCompletion(context2));
    }

    private void invokeCompletion(ExpressionContext context2) {
        Project project = context2.getProject();
        Editor editor = context2.getEditor();
        PsiFile psiFile = editor != null ? PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project) : null;
        Runnable runnable2 = () -> {
            if (project.isDisposed() || editor == null || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                return;
            }
            if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                this.invokeCompletionHandler(project, editor);
                LookupEx lookup2 = LookupManager.getInstance(project).getActiveLookup();
                if (lookup2 != null) {
                    lookup2.addLookupListener(new MyLookupListener(context2, this.myCheckCompletionChar));
                }
            }, "", null);
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    @TestOnly
    public static void waitForNextTab() {
        UIUtil.dispatchAllInvocationEvents();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "calculateResult"));
    }

    private static class MyLookupListener
    implements LookupListener {
        private final ExpressionContext myContext;
        private final boolean myCheckCompletionChar;

        MyLookupListener(@NotNull ExpressionContext context2, boolean checkCompletionChar) {
            if (context2 == null) {
                MyLookupListener.$$$reportNull$$$0(0);
            }
            this.myContext = context2;
            this.myCheckCompletionChar = checkCompletionChar;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            LookupElement item;
            if (event == null) {
                MyLookupListener.$$$reportNull$$$0(1);
            }
            if ((item = event.getItem()) == null) {
                return;
            }
            char c = event.getCompletionChar();
            if (this.myCheckCompletionChar && !LookupEvent.isSpecialCompletionChar((char)c)) {
                return;
            }
            Project project = this.myContext.getProject();
            if (project == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                TemplateState templateState2;
                Editor editor = this.myContext.getEditor();
                if (editor != null && (templateState2 = TemplateManagerImpl.getTemplateState(editor)) != null) {
                    templateState2.considerNextTabOnLookupItemSelected(item);
                }
            }), ModalityState.current(), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

