/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SplitWordsMacro
extends MacroBase {
    private final char mySeparator;

    private SplitWordsMacro(String name, String description2, char separator) {
        super(name, description2);
        this.mySeparator = separator;
    }

    @Override
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context2, boolean quick) {
        String text2;
        if (params == null) {
            SplitWordsMacro.$$$reportNull$$$0(0);
        }
        return (text2 = SplitWordsMacro.getTextResult(params, context2, true)) != null ? new TextResult(!text2.isEmpty() ? this.convertString(text2) : "") : null;
    }

    @VisibleForTesting
    public String convertString(String text2) {
        return NameUtil.splitWords((String)text2, (char)this.mySeparator, this::convertCase);
    }

    @NotNull
    protected abstract String convertCase(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SplitWordsMacro", "calculateResult"));
    }

    public static class SpaceSeparated
    extends SplitWordsMacro {
        public SpaceSeparated() {
            super("spaceSeparated", "spaceSeparated(String)", ' ');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                SpaceSeparated.$$$reportNull$$$0(0);
            }
            String string = word;
            if (string == null) {
                SpaceSeparated.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertCase";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LowercaseAndDash
    extends SplitWordsMacro {
        public LowercaseAndDash() {
            super("lowercaseAndDash", "lowercaseAndDash(String)", '-');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                LowercaseAndDash.$$$reportNull$$$0(0);
            }
            String string = StringUtil.toLowerCase((String)word);
            if (string == null) {
                LowercaseAndDash.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertCase";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SnakeCaseMacro
    extends SplitWordsMacro {
        public SnakeCaseMacro() {
            super("snakeCase", "snakeCase(String)", '_');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                SnakeCaseMacro.$$$reportNull$$$0(0);
            }
            String string = StringUtil.toLowerCase((String)word);
            if (string == null) {
                SnakeCaseMacro.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertCase";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

