/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    @NonNls
    private static final String LOC_REFERENCE = "#loc";
    @NonNls
    private static final String REF_REFERENCE = "#ref";
    public static final Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement psiElement) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        TextRange range2 = descriptor2 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor2).getTextRange() : null;
        return ProblemDescriptorUtil.extractHighlightedText(range2, psiElement);
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range2, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (range2 != null && (elementRange = psiElement.getTextRange()) != null && (range2 = range2.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && ref.length() > range2.getLength()) {
            ref = range2.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        String string = ref.trim().replaceAll("\\s+", " ");
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2, boolean appendLineNumber) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(2);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, appendLineNumber ? 1 : 0);
    }

    @NotNull
    @InspectionMessage
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2, @FlagConstant int flags) {
        int lineNumber;
        String message2;
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        if ((message2 = descriptor2.getDescriptionTemplate()) == null) {
            return "";
        }
        if ((flags & 1) != 0 && descriptor2 instanceof ProblemDescriptor && !message2.contains(REF_REFERENCE) && message2.contains(LOC_REFERENCE) && (lineNumber = ((ProblemDescriptor)descriptor2).getLineNumber()) >= 0) {
            message2 = StringUtil.replace((String)message2, (String)LOC_REFERENCE, (String)("(" + AnalysisBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
        }
        message2 = ProblemDescriptorUtil.unescapeTags(message2);
        message2 = ProblemDescriptorUtil.removeLocReference(message2);
        if ((flags & 4) != 0) {
            int endIndex;
            if (XmlStringUtil.isWrappedInHtml((String)message2)) {
                message2 = StringUtil.removeHtmlTags((String)message2, (boolean)true);
            }
            if ((endIndex = message2.indexOf("#treeend")) > 0) {
                message2 = message2.substring(0, endIndex);
            }
        }
        if (message2.contains(REF_REFERENCE)) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor2, element2);
            message2 = StringUtil.replace((String)message2, (String)REF_REFERENCE, (String)ref);
        }
        message2 = StringUtil.replace((String)message2, (String)"#end", (String)"");
        message2 = StringUtil.replace((String)message2, (String)"#treeend", (String)"");
        String string = message2.trim();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeLocReference(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        message2 = StringUtil.replace((String)message2, (String)"#loc ", (String)"");
        message2 = StringUtil.replace((String)message2, (String)" #loc", (String)"");
        String string = message2 = StringUtil.replace((String)message2, (String)LOC_REFERENCE, (String)"");
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeTags(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        message2 = StringUtil.replace((String)message2, (String)"<code>", (String)"'");
        String string = message2 = (message2 = StringUtil.replace((String)message2, (String)"</code>", (String)"'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message2) : (!XmlStringUtil.isWrappedInHtml((String)message2) ? StringUtil.unescapeXmlEntities((String)message2) : message2);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String unescapeXmlCode(@NotNull String message2) {
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message2, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXmlEntities((String)string));
        }
        String string = builder2.toString();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element2) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element2, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    @NotNull
    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(16);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(17);
        }
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(18);
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(19);
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFO;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(20);
                }
                return highlightInfoType;
            }
            case WEAK_WARNING: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WEAK_WARNING;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(21);
                }
                return highlightInfoType;
            }
            case WARNING: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(22);
                }
                return highlightInfoType;
            }
            case ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(23);
                }
                return highlightInfoType;
            }
            case GENERIC_ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(24);
                }
                return highlightInfoType;
            }
            case INFORMATION: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFORMATION;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(25);
                }
                return highlightInfoType;
            }
            case POSSIBLE_PROBLEM: {
                HighlightInfoType highlightInfoType = HighlightInfoType.POSSIBLE_PROBLEM;
                if (highlightInfoType == null) {
                    ProblemDescriptorUtil.$$$reportNull$$$0(26);
                }
                return highlightInfoType;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    public static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@NotNull List<? extends Annotation> annotations, @NotNull PsiFile file2) {
        if (annotations == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(28);
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(29);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(annotations.size());
        IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache = new IdentityHashMap<IntentionAction, LocalQuickFix>();
        for (Annotation annotation : annotations) {
            LocalQuickFix[] quickFixes;
            boolean isAfterEndOfLine;
            String message2;
            int endOffset;
            int startOffset;
            HighlightSeverity severity = annotation.getSeverity();
            ProblemDescriptor descriptor2 = ProblemDescriptorUtil.convertToDescriptor(file2, severity, startOffset = annotation.getStartOffset(), endOffset = annotation.getEndOffset(), message2 = annotation.getMessage(), isAfterEndOfLine = annotation.isAfterEndOfLine(), quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache));
            if (descriptor2 == null) continue;
            problems.add(descriptor2);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(30);
        }
        return problemDescriptorArray;
    }

    private static ProblemDescriptor convertToDescriptor(@NotNull PsiFile file2, @NotNull HighlightSeverity severity, int startOffset, int endOffset, @NotNull @InspectionMessage String message2, boolean isAfterEndOfLine, LocalQuickFix @NotNull [] quickFixes) {
        PsiElement startElement;
        PsiElement endElement;
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(31);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(32);
        }
        if (message2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(33);
        }
        if (quickFixes == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(34);
        }
        if (severity == HighlightSeverity.INFORMATION || startOffset == endOffset && !isAfterEndOfLine) {
            return null;
        }
        if (startOffset == endOffset) {
            startElement = endElement = file2.findElementAt(endOffset - 1);
        } else {
            startElement = file2.findElementAt(startOffset);
            endElement = file2.findElementAt(endOffset - 1);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(severity);
        return new ProblemDescriptorBase(startElement, endElement, message2, quickFixes, highlightType, isAfterEndOfLine, null, true, false);
    }

    private static LocalQuickFix @NotNull [] toLocalQuickFixes(@Nullable List<? extends Annotation.QuickFixInfo> fixInfos, @NotNull Map<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (quickFixMappingCache == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(35);
        }
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(36);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i2 = 0;
        for (Annotation.QuickFixInfo quickFixInfo : fixInfos) {
            LocalQuickFix fix;
            IntentionAction intentionAction = quickFixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                fix = (LocalQuickFix)intentionAction;
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new ExternalAnnotatorInspectionVisitor.LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix = lqf;
            }
            result2[i2++] = fix;
        }
        if (result2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(37);
        }
        return result2;
    }

    public static ProblemDescriptor toProblemDescriptor(@NotNull PsiFile file2, @NotNull HighlightInfo info2) {
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(38);
        }
        if (info2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(39);
        }
        List quickFixes = ContainerUtil.mapNotNull((Collection)((Collection)ObjectUtils.notNull(info2.quickFixActionRanges, Collections.emptyList())), p -> {
            IntentionAction intention = ((HighlightInfo.IntentionActionDescriptor)p.first).getAction();
            if (intention instanceof LocalQuickFix) {
                return (LocalQuickFix)intention;
            }
            if (intention instanceof LocalQuickFixAsIntentionAdapter) {
                return ((LocalQuickFixAsIntentionAdapter)intention).getFix();
            }
            return null;
        });
        return ProblemDescriptorUtil.convertToDescriptor(file2, info2.getSeverity(), info2.getStartOffset(), info2.getEndOffset(), info2.getDescription(), info2.isAfterEndOfLine(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 13: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 28: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixMappingCache";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlightedText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLocReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeTags";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlCode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 37: {
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeLocReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unescapeTags";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlCode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toLocalQuickFixes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "toProblemDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface FlagConstant {
    }
}

