/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.Interner;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;

public final class OfflineViewParseUtil {
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String OFFSET = "offset";
    @NonNls
    private static final String MODULE = "module";

    private OfflineViewParseUtil() {
    }

    public static Map<String, Set<OfflineProblemDescriptor>> parse(Path problemFile) throws IOException {
        return OfflineViewParseUtil.parse(Files.newBufferedReader(problemFile));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static Map<String, Set<OfflineProblemDescriptor>> parse(String problemText) {
        return OfflineViewParseUtil.parse(new StringReader(problemText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Map<String, Set<OfflineProblemDescriptor>> parse(Reader problemReader) {
        Object2IntOpenHashMap fqName2IdxMap = new Object2IntOpenHashMap();
        @NlsSafe Interner stringInterner = Interner.createStringInterner();
        HashMap<String, Set<OfflineProblemDescriptor>> package2Result = new HashMap<String, Set<OfflineProblemDescriptor>>();
        try (XppReader reader = new XppReader(problemReader, (XmlPullParser)new MXParser());){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                OfflineProblemDescriptor descriptor2 = new OfflineProblemDescriptor();
                boolean added2 = false;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("entry_point".equals(reader.getNodeName())) {
                        descriptor2.setType(reader.getAttribute("TYPE"));
                        String fqName = reader.getAttribute("FQNAME");
                        descriptor2.setFQName(fqName);
                        if (!fqName2IdxMap.containsKey((Object)fqName)) {
                            fqName2IdxMap.put((Object)fqName, 0);
                        }
                        int idx = fqName2IdxMap.getInt((Object)fqName);
                        descriptor2.setProblemIndex(idx);
                        fqName2IdxMap.put((Object)fqName, idx + 1);
                    }
                    if (DESCRIPTION.equals(reader.getNodeName())) {
                        descriptor2.setDescription((String)stringInterner.intern((Object)reader.getValue()));
                    }
                    if (LINE.equals(reader.getNodeName())) {
                        descriptor2.setLine(Integer.parseInt(reader.getValue()));
                    }
                    if (OFFSET.equals(reader.getNodeName())) {
                        descriptor2.setOffset(Integer.parseInt(reader.getValue()));
                    }
                    if (MODULE.equals(reader.getNodeName())) {
                        descriptor2.setModule((String)stringInterner.intern((Object)reader.getValue()));
                    }
                    if (HINTS.equals(reader.getNodeName())) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            ArrayList<String> hints2 = descriptor2.getHints();
                            if (hints2 == null) {
                                hints2 = new ArrayList<String>();
                                descriptor2.setHints(hints2);
                            }
                            hints2.add((String)stringInterner.intern((Object)reader.getAttribute("value")));
                            reader.moveUp();
                        }
                    }
                    if (PACKAGE.equals(reader.getNodeName())) {
                        OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor2);
                        added2 = true;
                    }
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (PACKAGE.equals(reader.getNodeName())) {
                            OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor2);
                            added2 = true;
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                }
                if (!added2) {
                    OfflineViewParseUtil.appendDescriptor(package2Result, null, descriptor2);
                }
                reader.moveUp();
            }
        }
        return package2Result;
    }

    @Nullable
    public static String parseProfileName(@NotNull Path descriptorFile) throws IOException {
        if (descriptorFile == null) {
            OfflineViewParseUtil.$$$reportNull$$$0(0);
        }
        return OfflineViewParseUtil.parseProfileName(Files.newBufferedReader(descriptorFile));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static String parseProfileName(String descriptorText) {
        return OfflineViewParseUtil.parseProfileName(new StringReader(descriptorText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String parseProfileName(Reader descriptorReader) {
        try (XppReader reader = new XppReader(descriptorReader, (XmlPullParser)new MXParser());){
            String string = reader.getAttribute("profile");
            return string;
        }
    }

    private static void appendDescriptor(Map<String, Set<OfflineProblemDescriptor>> package2Result, String packageName, OfflineProblemDescriptor descriptor2) {
        Set<OfflineProblemDescriptor> descriptors2 = package2Result.get(packageName);
        if (descriptors2 == null) {
            descriptors2 = new HashSet<OfflineProblemDescriptor>();
            package2Result.put(packageName, descriptors2);
        }
        descriptors2.add(descriptor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFile", "com/intellij/codeInspection/offlineViewer/OfflineViewParseUtil", "parseProfileName"));
    }
}

