/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountManager;
import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.collaboration.auth.AccountsRepository;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 9*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005:\u00019B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH$J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0007J\u001e\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010%\u001a\u00020\u0007H$\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020!H\u0016J\u0017\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0015J\u0015\u0010+\u001a\u00020!2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020\u00072\u0006\u0010%\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010.J\u001d\u0010/\u001a\u00020!2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\u00020!2\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u000103H\u0016J\u0011\u00104\u001a\u000205*\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\u001d\u0010%\u001a\u0004\u0018\u000107*\u00028\u00002\b\u0010%\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u00108R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/collaboration/auth/AccountManagerBase;", "A", "Lcom/intellij/collaboration/auth/Account;", "Cred", "Lcom/intellij/collaboration/auth/AccountManager;", "Lcom/intellij/openapi/Disposable;", "serviceName", "", "(Ljava/lang/String;)V", "accounts", "", "getAccounts", "()Ljava/util/Set;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/collaboration/auth/AccountsListener;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "Lorg/jetbrains/annotations/NotNull;", "getMessageBusConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "messageBusConnection$delegate", "Lkotlin/Lazy;", "passwordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "getPasswordSafe", "()Lcom/intellij/ide/passwordSafe/PasswordSafe;", "persistentAccounts", "Lcom/intellij/collaboration/auth/AccountsRepository;", "getPersistentAccounts", "()Lcom/intellij/collaboration/auth/AccountsRepository;", "accountsRepository", "addListener", "", "listener", "disposable", "deserializeCredentials", "credentials", "(Ljava/lang/String;)Ljava/lang/Object;", "dispose", "findCredentials", "account", "(Lcom/intellij/collaboration/auth/Account;)Ljava/lang/Object;", "removeAccount", "(Lcom/intellij/collaboration/auth/Account;)V", "serializeCredentials", "(Ljava/lang/Object;)Ljava/lang/String;", "updateAccount", "(Lcom/intellij/collaboration/auth/Account;Ljava/lang/Object;)V", "updateAccounts", "accountsWithCredentials", "", "credentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "(Lcom/intellij/collaboration/auth/Account;)Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "(Lcom/intellij/collaboration/auth/Account;Ljava/lang/Object;)Lcom/intellij/credentialStore/Credentials;", "Companion", "intellij.platform.collaborationTools"})
public abstract class AccountManagerBase<A extends Account, Cred>
implements AccountManager<A, Cred>,
Disposable {
    private final CopyOnWriteArrayList<AccountsListener<A>> listeners;
    private final Lazy messageBusConnection$delegate;
    private final String serviceName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected PasswordSafe getPasswordSafe() {
        return PasswordSafe.Companion.getInstance();
    }

    private final AccountsRepository<A> getPersistentAccounts() {
        return this.accountsRepository();
    }

    @NotNull
    protected abstract AccountsRepository<A> accountsRepository();

    private final MessageBusConnection getMessageBusConnection() {
        Lazy lazy = this.messageBusConnection$delegate;
        AccountManagerBase accountManagerBase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageBusConnection)lazy.getValue();
    }

    @VisibleForTesting
    @NotNull
    protected MessageBusConnection messageBusConnection() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection2 = application.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"ApplicationManager.getAp\u2026.messageBus.connect(this)");
        return messageBusConnection2;
    }

    @Override
    @NotNull
    public Set<A> getAccounts() {
        return this.getPersistentAccounts().getAccounts();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateAccounts(@NotNull Map<A, ? extends Cred> accountsWithCredentials) {
        block7: {
            Set<A> currentSet;
            block6: {
                Intrinsics.checkNotNullParameter(accountsWithCredentials, (String)"accountsWithCredentials");
                currentSet = this.getPersistentAccounts().getAccounts();
                Set removed = SetsKt.minus(currentSet, (Iterable)accountsWithCredentials.keySet());
                for (Object account2 : removed) {
                    this.getPasswordSafe().set(this.credentialAttributes(account2), null);
                }
                Object object = accountsWithCredentials;
                boolean bl = false;
                Object object2 = object.entrySet().iterator();
                while (object2.hasNext()) {
                    void account;
                    Object account2;
                    Object object3 = account2 = (Map.Entry)object2.next();
                    boolean bl2 = false;
                    object = (Account)object3.getKey();
                    object3 = account2;
                    bl2 = false;
                    Object credentials2 = object3.getValue();
                    if (credentials2 == null) continue;
                    this.getPasswordSafe().set(this.credentialAttributes(account), this.credentials(account, credentials2));
                    if (!currentSet.contains(account)) continue;
                    Iterable $this$forEach$iv = this.listeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AccountsListener it = (AccountsListener)element$iv;
                        boolean bl3 = false;
                        it.onAccountCredentialsChanged(account);
                    }
                }
                Set added2 = SetsKt.minus(accountsWithCredentials.keySet(), (Iterable)currentSet);
                object2 = added2;
                boolean account = false;
                if (!object2.isEmpty()) break block6;
                object2 = removed;
                account = false;
                if (!(!object2.isEmpty())) break block7;
            }
            this.getPersistentAccounts().setAccounts(accountsWithCredentials.keySet());
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccountsListener it = (AccountsListener)element$iv;
                boolean bl = false;
                it.onAccountListChanged((Collection)currentSet, (Collection)accountsWithCredentials.keySet());
            }
            AccountManagerBase.Companion.getLOG().debug("Account list changed to: " + this.getPersistentAccounts().getAccounts());
        }
    }

    @Override
    public void updateAccount(@NotNull A account, Cred credentials2) {
        boolean newAccount;
        Intrinsics.checkNotNullParameter(account, (String)"account");
        Set<A> currentSet = this.getPersistentAccounts().getAccounts();
        boolean bl = newAccount = !currentSet.contains(account);
        if (!newAccount) {
            this.getPersistentAccounts().setAccounts(SetsKt.plus((Set)SetsKt.minus(currentSet, account), account));
        } else {
            this.getPersistentAccounts().setAccounts(SetsKt.plus(currentSet, account));
            AccountManagerBase.Companion.getLOG().debug("Added new account: " + account);
        }
        this.getPasswordSafe().set(this.credentialAttributes(account), this.credentials(account, credentials2));
        AccountManagerBase.Companion.getLOG().debug((credentials2 == null ? "Cleared" : "Updated") + " credentials for account: " + account);
        if (!newAccount) {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccountsListener it = (AccountsListener)element$iv;
                boolean bl2 = false;
                it.onAccountCredentialsChanged(account);
            }
        } else {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccountsListener it = (AccountsListener)element$iv;
                boolean bl3 = false;
                it.onAccountListChanged((Collection)currentSet, (Collection)this.getPersistentAccounts().getAccounts());
            }
        }
    }

    @Override
    public void removeAccount(@NotNull A account) {
        Intrinsics.checkNotNullParameter(account, (String)"account");
        Set<A> currentSet = this.getPersistentAccounts().getAccounts();
        Set newSet = SetsKt.minus(currentSet, account);
        if (newSet.size() != currentSet.size()) {
            this.getPersistentAccounts().setAccounts(newSet);
            this.getPasswordSafe().set(this.credentialAttributes(account), null);
            AccountManagerBase.Companion.getLOG().debug("Removed account: " + account);
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccountsListener it = (AccountsListener)element$iv;
                boolean bl = false;
                it.onAccountListChanged((Collection)currentSet, newSet);
            }
        }
    }

    @Override
    @Nullable
    public Cred findCredentials(@NotNull A account) {
        Cred Cred;
        Intrinsics.checkNotNullParameter(account, (String)"account");
        Object object = this.getPasswordSafe().get(this.credentialAttributes(account));
        if (object != null && (object = object.getPasswordAsString()) != null) {
            Object object2 = object;
            AccountManagerBase accountManagerBase = this;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            Cred = accountManagerBase.deserializeCredentials((String)p1);
        } else {
            Cred = null;
        }
        return Cred;
    }

    private final CredentialAttributes credentialAttributes(A $this$credentialAttributes) {
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)this.serviceName, (String)((Account)$this$credentialAttributes).getId()), null, null, false, 14, null);
    }

    private final Credentials credentials(A $this$credentials, Cred credentials2) {
        Credentials credentials3;
        Cred Cred = credentials2;
        if (Cred != null) {
            Cred Cred2 = Cred;
            boolean bl = false;
            boolean bl2 = false;
            Cred it = Cred2;
            boolean bl3 = false;
            credentials3 = new Credentials(((Account)$this$credentials).getId(), this.serializeCredentials(it));
        } else {
            credentials3 = null;
        }
        return credentials3;
    }

    @NotNull
    protected abstract String serializeCredentials(Cred var1);

    protected abstract Cred deserializeCredentials(@NotNull String var1);

    @Override
    public void addListener(@NotNull Disposable disposable2, @NotNull AccountsListener<A> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, listener2){
            final /* synthetic */ AccountManagerBase this$0;
            final /* synthetic */ AccountsListener $listener;

            public final void dispose() {
                AccountManagerBase.access$getListeners$p(this.this$0).remove(this.$listener);
            }
            {
                this.this$0 = accountManagerBase;
                this.$listener = accountsListener;
            }
        });
    }

    @VisibleForTesting
    public final void addListener(@NotNull AccountsListener<A> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public void dispose() {
    }

    public AccountManagerBase(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.serviceName = serviceName;
        this.listeners = new CopyOnWriteArrayList();
        this.messageBusConnection$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageBusConnection>(this){
            final /* synthetic */ AccountManagerBase this$0;

            @NotNull
            public final MessageBusConnection invoke() {
                return this.this$0.messageBusConnection();
            }
            {
                this.this$0 = accountManagerBase;
                super(0);
            }
        }));
        this.getMessageBusConnection().subscribe(PasswordSafeSettings.TOPIC, (Object)new PasswordSafeSettingsListener(){

            @Override
            public void credentialStoreCleared() {
                Iterable $this$forEach$iv = this.getPersistentAccounts().getAccounts();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Account account = (Account)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = listeners;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        AccountsListener it = (AccountsListener)element$iv2;
                        boolean bl2 = false;
                        it.onAccountCredentialsChanged(account);
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/collaboration/auth/AccountManagerBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private final Logger getLOG() {
            Companion $this$thisLogger$iv = Companion;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

