/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.ArtifactsSettings;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ConversionRunner {
    private final String providerId;
    private final ConverterProvider myProvider;
    private final ConversionContextImpl myContext;
    private final ConversionProcessor<ModuleSettings> myModuleFileConverter;
    private final ConversionProcessor<ComponentManagerSettings> myProjectFileConverter;
    private final ConversionProcessor<WorkspaceSettings> myWorkspaceConverter;
    private boolean myProcessProjectFile;
    private boolean myProcessWorkspaceFile;
    private boolean myProcessRunConfigurations;
    private boolean myProcessProjectLibraries;
    private boolean myArtifacts;
    private final List<Path> myModulesFilesToProcess;
    private final ProjectConverter myConverter;
    private final ConversionProcessor<RunManagerSettings> myRunConfigurationsConverter;
    private final ConversionProcessor<ProjectLibrariesSettings> myProjectLibrariesConverter;
    private final ConversionProcessor<ArtifactsSettings> myArtifactsConverter;

    public ConversionRunner(@NotNull String providerId, @NotNull ConverterProvider provider2, @NotNull ConversionContextImpl context2) {
        if (providerId == null) {
            ConversionRunner.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            ConversionRunner.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            ConversionRunner.$$$reportNull$$$0(2);
        }
        this.myModulesFilesToProcess = new ArrayList<Path>();
        this.providerId = providerId;
        this.myProvider = provider2;
        this.myContext = context2;
        this.myConverter = provider2.createConverter(context2);
        this.myModuleFileConverter = this.myConverter.createModuleFileConverter();
        this.myProjectFileConverter = this.myConverter.createProjectFileConverter();
        this.myWorkspaceConverter = this.myConverter.createWorkspaceFileConverter();
        this.myRunConfigurationsConverter = this.myConverter.createRunConfigurationsConverter();
        this.myProjectLibrariesConverter = this.myConverter.createProjectLibrariesConverter();
        this.myArtifactsConverter = this.myConverter.createArtifactsConverter();
    }

    @NotNull
    public String getProviderId() {
        String string = this.providerId;
        if (string == null) {
            ConversionRunner.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isConversionNeeded() throws CannotConvertException {
        this.myProcessProjectFile = this.myContext.getStorageScheme() == StorageScheme.DEFAULT && this.myProjectFileConverter != null && this.myProjectFileConverter.isConversionNeeded(this.myContext.getProjectSettings());
        this.myProcessWorkspaceFile = this.myWorkspaceConverter != null && Files.exists(this.myContext.getWorkspaceSettings().getPath(), new LinkOption[0]) && this.myWorkspaceConverter.isConversionNeeded(this.myContext.getWorkspaceSettings());
        this.myModulesFilesToProcess.clear();
        if (this.myModuleFileConverter != null) {
            for (Path moduleFile : this.myContext.getModulePaths()) {
                if (!Files.exists(moduleFile, new LinkOption[0]) || !this.myModuleFileConverter.isConversionNeeded(this.myContext.getModuleSettings(moduleFile))) continue;
                this.myModulesFilesToProcess.add(moduleFile);
            }
        }
        this.myProcessRunConfigurations = this.myRunConfigurationsConverter != null && this.myRunConfigurationsConverter.isConversionNeeded(this.myContext.getRunManagerSettings());
        this.myProcessProjectLibraries = this.myProjectLibrariesConverter != null && this.myProjectLibrariesConverter.isConversionNeeded(this.myContext.getProjectLibrariesSettings());
        boolean bl = this.myArtifacts = this.myArtifactsConverter != null && this.myArtifactsConverter.isConversionNeeded(this.myContext.getArtifactsSettings());
        if (this.myProcessProjectFile || this.myProcessWorkspaceFile || this.myProcessRunConfigurations || this.myProcessProjectLibraries || !this.myModulesFilesToProcess.isEmpty()) {
            return true;
        }
        try {
            return this.myConverter.isConversionNeeded();
        }
        catch (Exception e) {
            Logger.getInstance(ConversionRunner.class).error("Converter of provider " + this.providerId + " cannot check is conversion needed or not", (Throwable)e);
            return false;
        }
    }

    public boolean isModuleConversionNeeded(@NotNull Path moduleFile) throws CannotConvertException {
        if (moduleFile == null) {
            ConversionRunner.$$$reportNull$$$0(4);
        }
        return this.myModuleFileConverter != null && this.myModuleFileConverter.isConversionNeeded(this.myContext.getModuleSettings(moduleFile));
    }

    @NotNull
    public Collection<Path> getCreatedFiles() {
        Collection<Path> collection = this.myConverter.getCreatedFiles();
        if (collection == null) {
            ConversionRunner.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public void collectAffectedFiles(@NotNull Collection<Path> affectedFiles2) {
        if (affectedFiles2 == null) {
            ConversionRunner.$$$reportNull$$$0(6);
        }
        if (this.myProcessProjectFile) {
            affectedFiles2.add(this.myContext.getProjectFile());
        }
        if (this.myProcessWorkspaceFile) {
            affectedFiles2.add(this.myContext.getWorkspaceSettings().getPath());
        }
        affectedFiles2.addAll(this.myModulesFilesToProcess);
        if (this.myProcessRunConfigurations) {
            try {
                this.myContext.getRunManagerSettings().collectAffectedFiles(affectedFiles2);
            }
            catch (CannotConvertException cannotConvertException) {
                // empty catch block
            }
        }
        if (this.myProcessProjectLibraries) {
            try {
                this.myContext.getProjectLibrariesSettings().collectAffectedFiles(affectedFiles2);
            }
            catch (CannotConvertException cannotConvertException) {
                // empty catch block
            }
        }
        if (this.myArtifacts) {
            try {
                this.myContext.getArtifactsSettings().collectAffectedFiles(affectedFiles2);
            }
            catch (CannotConvertException cannotConvertException) {
                // empty catch block
            }
        }
        affectedFiles2.addAll(this.myConverter.getAdditionalAffectedFiles());
    }

    public void preProcess() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.preProcess(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.preProcess(this.myContext.getWorkspaceSettings());
        }
        for (Path moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.preProcess(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.preProcess(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.preProcess(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.preProcess(this.myContext.getArtifactsSettings());
        }
        this.myConverter.preProcessingFinished();
    }

    public void process() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.process(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.process(this.myContext.getWorkspaceSettings());
        }
        for (Path moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.process(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.process(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.process(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.process(this.myContext.getArtifactsSettings());
        }
        this.myConverter.processingFinished();
    }

    public void postProcess() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.postProcess(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.postProcess(this.myContext.getWorkspaceSettings());
        }
        for (Path moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.postProcess(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.postProcess(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.postProcess(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.postProcess(this.myContext.getArtifactsSettings());
        }
        this.myConverter.postProcessingFinished();
    }

    @NotNull
    public ConverterProvider getProvider() {
        ConverterProvider converterProvider = this.myProvider;
        if (converterProvider == null) {
            ConversionRunner.$$$reportNull$$$0(7);
        }
        return converterProvider;
    }

    @NotNull
    public static List<Path> getReadOnlyFiles(@NotNull Collection<? extends Path> affectedFiles2) {
        if (affectedFiles2 == null) {
            ConversionRunner.$$$reportNull$$$0(8);
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        for (Path path2 : affectedFiles2) {
            try {
                path2.getFileSystem().provider().checkAccess(path2, AccessMode.WRITE);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException ignored) {
                result2.add(path2);
            }
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            ConversionRunner.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void convertModule(@NotNull Path moduleFile) throws CannotConvertException {
        if (moduleFile == null) {
            ConversionRunner.$$$reportNull$$$0(10);
        }
        ModuleSettings settings2 = this.myContext.getModuleSettings(moduleFile);
        this.myModuleFileConverter.preProcess(settings2);
        this.myModuleFileConverter.process(settings2);
        this.myModuleFileConverter.postProcess(settings2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ConversionRunner";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ConversionRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreatedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModuleConversionNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReadOnlyFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

