/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.google.gson.stream.JsonReader;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/AnalyzePendingSnapshotActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class AnalyzePendingSnapshotActivity
implements StartupActivity.DumbAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActivity(@NotNull Project project) {
        block24: {
            Path hprofPath;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isHeadlessEnvironment()) {
                return;
            }
            Path jsonPath = Paths.get(PathManager.getSystemPath(), "pending-snapshot.json");
            if (!Files.isRegularFile(jsonPath, new LinkOption[0])) {
                return;
            }
            String path2 = null;
            String liveStats = null;
            MemoryReportReason reason = null;
            try {
                JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(jsonPath));
                Closeable closeable = (Closeable)reader;
                bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    JsonReader it = (JsonReader)closeable;
                    boolean bl3 = false;
                    it.beginObject();
                    while (it.hasNext()) {
                        String string;
                        if (it.nextName() == null) continue;
                        int n = -1;
                        switch (string.hashCode()) {
                            case 3433509: {
                                if (!string.equals("path")) break;
                                n = 1;
                                break;
                            }
                            case -934964668: {
                                if (!string.equals("reason")) break;
                                n = 2;
                                break;
                            }
                            case 997906195: {
                                if (!string.equals("liveStats")) break;
                                n = 3;
                                break;
                            }
                        }
                        switch (n) {
                            case 1: {
                                path2 = it.nextString();
                                break;
                            }
                            case 2: {
                                String string2 = it.nextString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.nextString()");
                                reason = MemoryReportReason.valueOf(string2);
                                break;
                            }
                            case 3: {
                                liveStats = it.nextString();
                            }
                        }
                    }
                    it.endObject();
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                FileUtil.delete((Path)jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = path2;
            if (string == null) break block24;
            String string3 = string;
            boolean bl4 = false;
            bl = false;
            String it = string3;
            boolean bl5 = false;
            Path path3 = hprofPath = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"hprofPath");
            if (PathKt.exists((Path)path3)) {
                String string4;
                MemoryReportReason memoryReportReason = reason;
                if (memoryReportReason == null) {
                    memoryReportReason = MemoryReportReason.None;
                }
                if ((string4 = liveStats) == null) {
                    string4 = "";
                }
                HeapReportProperties heapProperties = new HeapReportProperties(memoryReportReason, string4);
                new AnalysisRunnable(hprofPath, heapProperties, true).run();
            }
        }
    }
}

