/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.ClassNomination;
import com.intellij.diagnostic.hprof.classstore.HProfMetadata;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.FileBackedIntList;
import com.intellij.diagnostic.hprof.util.FileBackedUByteList;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.util.UByteList;
import com.intellij.diagnostic.hprof.visitors.RemapIDsVisitor;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002$%B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00032\b\b\u0001\u0010!\u001a\u00020\nH\u0002J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\rR \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis;", "", "hprofFileChannel", "Ljava/nio/channels/FileChannel;", "tempFilenameSupplier", "Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "analysisCallback", "Lkotlin/Function2;", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "(Ljava/nio/channels/FileChannel;Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;Lkotlin/jvm/functions/Function2;)V", "includeClassesAsRoots", "", "getIncludeClassesAsRoots", "()Z", "setIncludeClassesAsRoots", "(Z)V", "includeMetaInfo", "onlyStrongReferences", "getOnlyStrongReferences", "setOnlyStrongReferences", "tempFiles", "", "Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFile;", "analyze", "progress", "closeAndDeleteTemporaryFiles", "", "isSupported", "instanceCount", "", "openTempEmptyFileChannel", "type", "setIncludeMetaInfo", "value", "TempFile", "TempFilenameSupplier", "intellij.platform.ide.impl"})
public final class HProfAnalysis {
    private final List<TempFile> tempFiles;
    private boolean includeMetaInfo;
    private boolean onlyStrongReferences;
    private boolean includeClassesAsRoots;
    private final FileChannel hprofFileChannel;
    private final TempFilenameSupplier tempFilenameSupplier;
    private final Function2<AnalysisContext, ProgressIndicator, String> analysisCallback;

    public final void setIncludeMetaInfo(boolean value2) {
        this.includeMetaInfo = value2;
    }

    public final boolean getOnlyStrongReferences() {
        return this.onlyStrongReferences;
    }

    public final void setOnlyStrongReferences(boolean bl) {
        this.onlyStrongReferences = bl;
    }

    public final boolean getIncludeClassesAsRoots() {
        return this.includeClassesAsRoots;
    }

    public final void setIncludeClassesAsRoots(boolean bl) {
        this.includeClassesAsRoots = bl;
    }

    private final FileChannel openTempEmptyFileChannel(@NonNls String type) {
        FileChannel tempChannel;
        Path tempPath = this.tempFilenameSupplier.getTempFilePath(type);
        FileChannel fileChannel = tempChannel = FileChannel.open(tempPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"tempChannel");
        this.tempFiles.add(new TempFile(type, tempPath, fileChannel));
        return tempChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        Stopwatch prepareFilesStopwatch = Stopwatch.createStarted();
        Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
        progress2.setText(DiagnosticBundle.message("hprof.analysis.progress.text.analyze.heap", new Object[0]));
        progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.open.heap.file", new Object[0]));
        progress2.setFraction(0.0);
        HProfEventBasedParser parser = new HProfEventBasedParser(this.hprofFileChannel);
        try {
            AnalysisConfig.MetaInfoOptions $this$mapTo$iv$iv;
            progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.class.definition.map", new Object[0]));
            progress2.setFraction(0.0);
            HProfMetadata hprofMetadata = HProfMetadata.Companion.create(parser);
            progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.class.histogram", new Object[0]));
            progress2.setFraction(0.1);
            Histogram histogram = Histogram.Companion.create(parser, hprofMetadata.getClassStore());
            List<HistogramEntry> nominatedClasses = new ClassNomination(histogram, 5).nominateClasses();
            progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.id.mapping.file", new Object[0]));
            progress2.setFraction(0.2);
            if (!this.isSupported(histogram.getInstanceCount())) {
                CharSequence charSequence = result2;
                String string = histogram.prepareReport("All", 50);
                boolean bl = false;
                StringBuilder stringBuilder = charSequence.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                String string2 = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
                charSequence = string2;
                return charSequence;
            }
            FileChannel idMappingChannel = this.openTempEmptyFileChannel("id-mapping");
            RemapIDsVisitor remapIDsVisitor = RemapIDsVisitor.Companion.createFileBased(idMappingChannel, histogram.getInstanceCount());
            parser.accept(remapIDsVisitor, "id mapping");
            parser.setIdRemappingFunction(remapIDsVisitor.getRemappingFunction());
            hprofMetadata.remapIds(remapIDsVisitor.getRemappingFunction());
            progress2.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.object.graph.files", new Object[0]));
            progress2.setFraction(0.3);
            ObjectNavigator navigator = ObjectNavigator.Companion.createOnAuxiliaryFiles(parser, this.openTempEmptyFileChannel("auxOffset"), this.openTempEmptyFileChannel("aux"), hprofMetadata, histogram.getInstanceCount());
            prepareFilesStopwatch.stop();
            IntList parentList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("parents"), navigator.getInstanceCount() + 1L);
            IntList sizesList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("sizes"), navigator.getInstanceCount() + 1L);
            IntList visitedList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("visited"), navigator.getInstanceCount() + 1L);
            UByteList refIndexList = FileBackedUByteList.Companion.createEmpty(this.openTempEmptyFileChannel("refIndex"), navigator.getInstanceCount() + 1L);
            analysisStopwatch.start();
            Iterable $this$map$iv = nominatedClasses;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                HistogramEntry histogramEntry = (HistogramEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getClassDefinition().getName();
                collection.add(string);
            }
            List nominatedClassNames = (List)destination$iv$iv;
            AnalysisConfig.TraverseOptions $i$f$map22 = new AnalysisConfig.TraverseOptions(this.onlyStrongReferences, this.includeClassesAsRoots);
            $this$mapTo$iv$iv = new AnalysisConfig.MetaInfoOptions(this.includeMetaInfo);
            AnalysisConfig analysisConfig = new AnalysisConfig(new AnalysisConfig.PerClassOptions(nominatedClassNames, false, null, 6, null), null, null, $i$f$map22, $this$mapTo$iv$iv, 6, null);
            AnalysisContext analysisContext = new AnalysisContext(navigator, analysisConfig, parentList, sizesList, visitedList, refIndexList, histogram);
            String analysisReport = (String)this.analysisCallback.invoke((Object)analysisContext, (Object)new PartialProgressIndicator(progress2, 0.4, 0.4));
            destination$iv$iv = analysisReport;
            $i$f$mapTo2 = false;
            if (!StringsKt.isBlank((CharSequence)destination$iv$iv)) {
                destination$iv$iv = result2;
                $i$f$mapTo2 = false;
                StringBuilder stringBuilder = ((StringBuilder)destination$iv$iv).append(analysisReport);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
            }
            analysisStopwatch.stop();
            if (this.includeMetaInfo) {
                destination$iv$iv = result2;
                String $i$f$mapTo2 = HeapReportUtils.INSTANCE.sectionHeader("Analysis information");
                boolean bl = false;
                StringBuilder stringBuilder = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Prepare files duration: " + prepareFilesStopwatch;
                bl = false;
                StringBuilder stringBuilder2 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Analysis duration: " + analysisStopwatch;
                bl = false;
                StringBuilder stringBuilder3 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "TOTAL DURATION: " + totalStopwatch;
                bl = false;
                StringBuilder stringBuilder4 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Temp files:";
                bl = false;
                StringBuilder stringBuilder5 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "  heapdump = " + HeapReportUtils.INSTANCE.toShortStringAsCount(this.hprofFileChannel.size());
                bl = false;
                StringBuilder stringBuilder6 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                Iterable $this$forEach$iv = this.tempFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TempFile temp = (TempFile)element$iv;
                    boolean bl2 = false;
                    FileChannel channel2 = temp.getChannel();
                    if (!channel2.isOpen()) continue;
                    StringBuilder stringBuilder7 = result2;
                    String string = "  " + temp.getType() + " = " + HeapReportUtils.INSTANCE.toShortStringAsCount(channel2.size());
                    boolean bl3 = false;
                    StringBuilder stringBuilder8 = stringBuilder7.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder8);
                }
            }
        }
        finally {
            parser.close();
            this.closeAndDeleteTemporaryFiles();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final boolean isSupported(long instanceCount) {
        return RemapIDsVisitor.Companion.isSupported(instanceCount) && instanceCount <= (long)Integer.MAX_VALUE;
    }

    private final void closeAndDeleteTemporaryFiles() {
        Iterable $this$forEach$iv = this.tempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TempFile tempFile = (TempFile)element$iv;
            boolean bl = false;
            try {
                tempFile.getChannel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Path path2 = tempFile.getPath();
                boolean bl2 = false;
                boolean bl3 = false;
                Path it = path2;
                boolean bl4 = false;
                Files.deleteIfExists(it);
            }
            catch (Throwable throwable) {
            }
        }
        this.tempFiles.clear();
    }

    public HProfAnalysis(@NotNull FileChannel hprofFileChannel, @NotNull TempFilenameSupplier tempFilenameSupplier, @NotNull Function2<? super AnalysisContext, ? super ProgressIndicator, String> analysisCallback) {
        Intrinsics.checkNotNullParameter((Object)hprofFileChannel, (String)"hprofFileChannel");
        Intrinsics.checkNotNullParameter((Object)tempFilenameSupplier, (String)"tempFilenameSupplier");
        Intrinsics.checkNotNullParameter(analysisCallback, (String)"analysisCallback");
        this.hprofFileChannel = hprofFileChannel;
        this.tempFilenameSupplier = tempFilenameSupplier;
        this.analysisCallback = analysisCallback;
        boolean bl = false;
        this.tempFiles = new ArrayList();
        this.includeMetaInfo = true;
        this.includeClassesAsRoots = true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "", "getTempFilePath", "Ljava/nio/file/Path;", "type", "", "intellij.platform.ide.impl"})
    public static interface TempFilenameSupplier {
        @NotNull
        public Path getTempFilePath(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFile;", "", "type", "", "path", "Ljava/nio/file/Path;", "channel", "Ljava/nio/channels/FileChannel;", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/channels/FileChannel;)V", "getChannel", "()Ljava/nio/channels/FileChannel;", "getPath", "()Ljava/nio/file/Path;", "getType", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class TempFile {
        @NotNull
        private final String type;
        @NotNull
        private final Path path;
        @NotNull
        private final FileChannel channel;

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileChannel getChannel() {
            return this.channel;
        }

        public TempFile(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel2) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            this.type = type;
            this.path = path2;
            this.channel = channel2;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final FileChannel component3() {
            return this.channel;
        }

        @NotNull
        public final TempFile copy(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel2) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            return new TempFile(type, path2, channel2);
        }

        public static /* synthetic */ TempFile copy$default(TempFile tempFile, String string, Path path2, FileChannel fileChannel, int n, Object object) {
            if ((n & 1) != 0) {
                string = tempFile.type;
            }
            if ((n & 2) != 0) {
                path2 = tempFile.path;
            }
            if ((n & 4) != 0) {
                fileChannel = tempFile.channel;
            }
            return tempFile.copy(string, path2, fileChannel);
        }

        @NotNull
        public String toString() {
            return "TempFile(type=" + this.type + ", path=" + this.path + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            String string = this.type;
            Path path2 = this.path;
            FileChannel fileChannel = this.channel;
            return ((string != null ? string.hashCode() : 0) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0)) * 31 + (fileChannel != null ? fileChannel.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TempFile)) break block3;
                    TempFile tempFile = (TempFile)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)tempFile.type) || !Intrinsics.areEqual((Object)this.path, (Object)tempFile.path) || !Intrinsics.areEqual((Object)this.channel, (Object)tempFile.channel)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

