/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001fJ\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020#H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0086\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\"R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006+"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "", "classes", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "classClass", "getClassClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "primitiveArrayToClassDefinition", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/parser/Type;", "Lkotlin/collections/HashMap;", "softReferenceClass", "getSoftReferenceClass", "stringToClassDefinition", "", "weakReferenceClass", "getWeakReferenceClass", "containsClass", "", "name", "createStoreWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "forEachClass", "", "func", "Lkotlin/Function1;", "get", "id", "", "", "getClassForPrimitiveArray", "t", "getClassIfExists", "getShortPrettyNameForClass", "classDefinition", "isSoftOrWeakReferenceClass", "size", "intellij.platform.ide.impl"})
public final class ClassStore {
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    @NotNull
    private final ClassDefinition softReferenceClass;
    @NotNull
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;
    private final Long2ObjectMap<ClassDefinition> classes;

    @NotNull
    public final ClassDefinition getSoftReferenceClass() {
        return this.softReferenceClass;
    }

    @NotNull
    public final ClassDefinition getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id2) {
        Object object = this.classes.get((long)id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id2) {
        Object object = this.classes.get(id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name);
        Intrinsics.checkNotNull((Object)classDefinition);
        return classDefinition;
    }

    @Nullable
    public final ClassDefinition getClassIfExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.stringToClassDefinition.get(name);
    }

    public final boolean containsClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.stringToClassDefinition.containsKey(name);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return this.classes.size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        ObjectIterator objectIterator = ((ObjectCollection)this.classes.values()).iterator();
        while (objectIterator.hasNext()) {
            ClassDefinition classDefinition;
            ClassDefinition classDefinition2 = classDefinition = (ClassDefinition)objectIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)classDefinition2, (String)"classDefinition");
            func.invoke((Object)classDefinition2);
        }
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        Intrinsics.checkNotNullParameter((Object)remappingFunction, (String)"remappingFunction");
        Long2ObjectOpenHashMap newClasses = new Long2ObjectOpenHashMap();
        for (ClassDefinition classDefinition : (ObjectCollection)this.classes.values()) {
            newClasses.put(remappingFunction.applyAsLong(classDefinition.getId()), (Object)classDefinition.copyWithRemappedIDs(remappingFunction));
        }
        return new ClassStore((Long2ObjectMap<ClassDefinition>)((Long2ObjectMap)newClasses));
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    public ClassStore(@NotNull Long2ObjectMap<ClassDefinition> classes) {
        boolean bl;
        boolean bl2;
        ObjectIterator className;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.classes = classes;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        1 $fun$getClashedNameWithIndex$1 = 1.INSTANCE;
        HashSet<ObjectIterator> clashedClassNames = new HashSet<ObjectIterator>();
        for (ClassDefinition classDefinition : (ObjectCollection)this.classes.values()) {
            className = classDefinition.getName();
            boolean clashed = false;
            if (clashedClassNames.contains(className)) {
                clashed = true;
            } else {
                ClassDefinition clashedClass = this.stringToClassDefinition.remove(className);
                if (clashedClass != null) {
                    clashed = true;
                    ClassDefinition newDefinition = clashedClass.copyWithName($fun$getClashedNameWithIndex$1.invoke(clashedClass, 1));
                    ((Map)this.stringToClassDefinition).put(newDefinition.getName(), newDefinition);
                    this.classes.put(clashedClass.getId(), (Object)newDefinition);
                    clashedClassNames.add(className);
                }
            }
            if (clashed) {
                int i2 = 2;
                String newName2 = null;
                do {
                    ClassDefinition classDefinition2 = classDefinition;
                    Intrinsics.checkNotNullExpressionValue((Object)classDefinition2, (String)"classDefinition");
                    newName2 = $fun$getClashedNameWithIndex$1.invoke(classDefinition2, i2);
                    ++i2;
                } while (this.stringToClassDefinition.containsKey(newName2));
                ClassDefinition newClassDefinition22 = classDefinition.copyWithName(newName2);
                ((Map)this.stringToClassDefinition).put(newName2, newClassDefinition22);
                this.classes.put(classDefinition.getId(), (Object)newClassDefinition22);
                continue;
            }
            Map map2 = this.stringToClassDefinition;
            String string = classDefinition.getName();
            ClassDefinition classDefinition3 = classDefinition;
            Intrinsics.checkNotNullExpressionValue((Object)classDefinition3, (String)"classDefinition");
            map2.put(string, classDefinition3);
        }
        ObjectIterator $this$forEach$iv = (ObjectIterator)clashedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            Map newClassDefinition22 = this.stringToClassDefinition;
            boolean bl4 = false;
            Map map3 = newClassDefinition22;
            bl2 = false;
            boolean newClassDefinition22 = !map3.containsKey(it);
            bl4 = false;
            boolean bl5 = false;
            if (!_Assertions.ENABLED || newClassDefinition22) continue;
            bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        Intrinsics.checkNotNull((Object)classDefinition);
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition4 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        Intrinsics.checkNotNull((Object)classDefinition4);
        this.weakReferenceClass = classDefinition4;
        ClassDefinition classDefinition5 = this.stringToClassDefinition.get("java.lang.Class");
        Intrinsics.checkNotNull((Object)classDefinition5);
        this.classClass = classDefinition5;
        $this$forEach$iv = Type.values();
        $i$f$forEach = false;
        className = $this$forEach$iv;
        int element$iv = ((Type[])className).length;
        for (int it = 0; it < element$iv; ++it) {
            ClassDefinition classDefinition6;
            Type element$iv2;
            Type type = element$iv2 = className[it];
            boolean bl6 = false;
            if (type == Type.OBJECT) continue;
            if (this.stringToClassDefinition.get(type.getClassNameOfPrimitiveArray()) == null) continue;
            bl2 = false;
            bl = false;
            ClassDefinition classDefinition7 = classDefinition6;
            boolean bl7 = false;
            this.primitiveArrayToClassDefinition.put(type, classDefinition7);
        }
        HashMap shortNameToClassDefinition = new HashMap();
        for (ClassDefinition classDefinition8 : (ObjectCollection)this.classes.values()) {
            if (StringsKt.contains$default((CharSequence)classDefinition8.getName(), (char)'$', (boolean)false, (int)2, null)) continue;
            String prettyName = classDefinition8.getPrettyName();
            String shortPrettyName = StringsKt.substringAfterLast$default((String)prettyName, (char)'.', null, (int)2, null);
            if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                if (prevClassDefinition == null) continue;
                ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                continue;
            }
            ((Map)shortNameToClassDefinition).put(shortPrettyName, classDefinition8);
        }
        Map $this$forEach$iv2 = shortNameToClassDefinition;
        boolean $i$f$forEach2 = false;
        Map map4 = $this$forEach$iv2;
        boolean bl8 = false;
        Iterator iterator2 = map4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv3;
            Map.Entry $dstr$_u24__u24$classDef = element$iv3 = iterator2.next();
            boolean bl9 = false;
            Map.Entry entry2 = $dstr$_u24__u24$classDef;
            bl = false;
            ClassDefinition classDef = (ClassDefinition)entry2.getValue();
            if (classDef == null) continue;
            this.classDefinitionToShortPrettyName.add(classDef);
        }
    }
}

