/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(1);
        }
        this(project, document, file2, null);
    }

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(3);
        }
        super(project, document);
        this.myFile = file2;
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)this.myHighlightFile, (Object)this.myFile);
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        String s = LoadTextUtil.detectLineSeparator(this.myFile, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @Nullable
    public Charset getCharset() {
        return this.myFile.getCharset();
    }

    @Nullable
    public Boolean hasBom() {
        return this.myFile.getBOM() != null;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    @Nullable
    public FileType getContentType() {
        return this.myFile.getFileType();
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

