/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements FrameDiffTool.DiffViewer,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @NotNull
    private final List<DiffViewerListener> myListeners;
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final DiffTaskQueue myTaskExecutor;
    @NotNull
    private final Alarm myTaskAlarm;
    private volatile boolean myDisposed;

    public DiffViewerBase(@NotNull DiffContext context2, @NotNull ContentDiffRequest request) {
        if (context2 == null) {
            DiffViewerBase.$$$reportNull$$$0(0);
        }
        if (request == null) {
            DiffViewerBase.$$$reportNull$$$0(1);
        }
        this.myListeners = new SmartList();
        this.myTaskExecutor = new DiffTaskQueue();
        this.myTaskAlarm = new Alarm();
        this.myProject = context2.getProject();
        this.myContext = context2;
        this.myRequest = request;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        if (LOG.isDebugEnabled() && !ApplicationManager.getApplication().isHeadlessEnvironment() && (this.getComponent().getWidth() <= 0 || this.getComponent().getHeight() <= 0)) {
            LOG.warn("Diff shown for a hidden component, initial scroll position might be invalid", new Throwable());
        }
        this.processContextHints();
        this.onInit();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        this.fireEvent(EventType.INIT);
        new UiNotifyConnector((Component)this.getComponent(), new Activatable(){
            private boolean wasNotShownYet = true;

            public void showNotify() {
                DiffViewerBase.this.rediff(this.wasNotShownYet);
                this.wasNotShownYet = false;
            }

            public void hideNotify() {
                DiffViewerBase.this.abortRediff();
            }
        });
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            DiffViewerBase.$$$reportNull$$$0(2);
        }
        return toolbarComponents;
    }

    @RequiresEdt
    public final void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myDisposed) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LOG.warn(new Throwable("dispose() not from EDT"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.abortRediff();
            this.updateContextHints();
            this.fireEvent(EventType.DISPOSE);
            this.onDispose();
        });
    }

    @RequiresEdt
    protected void processContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected void updateContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    public final void scheduleRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        if (this.getComponent().isShowing()) {
            this.myTaskAlarm.addRequest(this::rediff, 300);
        }
    }

    @RequiresEdt
    public final void abortRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTaskExecutor.abort();
        this.myTaskAlarm.cancelAllRequests();
        this.fireEvent(EventType.REDIFF_ABORTED);
    }

    @RequiresEdt
    public final void rediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.rediff(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void rediff(boolean bl) {
        void trySync;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.fireEvent(EventType.BEFORE_REDIFF);
        this.onBeforeRediff();
        boolean forceEDT = this.forceRediffSynchronously();
        int waitMillis = trySync != false || this.tryRediffSynchronously() ? 300 : 0;
        this.myTaskExecutor.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator2 -> {
            Runnable callback2 = this.performRediff((ProgressIndicator)indicator2);
            return () -> {
                callback2.run();
                this.onAfterRediff();
                this.fireEvent(EventType.AFTER_REDIFF);
            };
        }), this::onSlowRediff, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            DiffViewerBase.$$$reportNull$$$0(3);
        }
        return contentDiffRequest;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            DiffViewerBase.$$$reportNull$$$0(4);
        }
        return diffContext;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @RequiresEdt
    protected boolean tryRediffSynchronously() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myContext.isWindowFocused();
    }

    @RequiresEdt
    protected boolean forceRediffSynchronously() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return ApplicationManager.getApplication().isWriteAccessAllowed();
    }

    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>();
        group2.add(ActionManager.getInstance().getAction("Diff.ViewerToolbar"));
        return group2;
    }

    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>();
        group2.add(ActionManager.getInstance().getAction("Diff.ViewerPopupMenu"));
        return group2;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    @RequiresEdt
    protected void onInit() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected void onSlowRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected void onBeforeRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected void onAfterRediff() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresBackgroundThread
    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    @RequiresEdt
    protected void onDispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose((Disposable)this.myTaskAlarm);
    }

    @Nullable
    protected Navigatable getNavigatable() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void addListener(@NotNull DiffViewerListener diffViewerListener) {
        void listener2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (listener2 == null) {
            DiffViewerBase.$$$reportNull$$$0(5);
        }
        this.myListeners.add((DiffViewerListener)listener2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void removeListener(@NotNull DiffViewerListener diffViewerListener) {
        void listener2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (listener2 == null) {
            DiffViewerBase.$$$reportNull$$$0(6);
        }
        this.myListeners.remove(listener2);
    }

    @NotNull
    @RequiresEdt
    protected List<DiffViewerListener> getListeners() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<DiffViewerListener> list2 = this.myListeners;
        if (list2 == null) {
            DiffViewerBase.$$$reportNull$$$0(7);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void fireEvent(@NotNull EventType eventType) {
        void type;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (type == null) {
            DiffViewerBase.$$$reportNull$$$0(8);
        }
        for (DiffViewerListener listener2 : this.myListeners) {
            switch (2.$SwitchMap$com$intellij$diff$tools$util$base$DiffViewerBase$EventType[type.ordinal()]) {
                case 1: {
                    listener2.onInit();
                    break;
                }
                case 2: {
                    listener2.onDispose();
                    break;
                }
                case 3: {
                    listener2.onBeforeRediff();
                    break;
                }
                case 4: {
                    listener2.onAfterRediff();
                    break;
                }
                case 5: {
                    listener2.onRediffAborted();
                }
            }
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DiffViewerBase.$$$reportNull$$$0(9);
        }
        if (DiffDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getNavigatable();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/DiffViewerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/DiffViewerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum EventType {
        INIT,
        DISPOSE,
        BEFORE_REDIFF,
        AFTER_REDIFF,
        REDIFF_ABORTED;

    }
}

