/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFragment {
    private static final Logger LOG = Logger.getInstance(PsiFragment.class);
    protected final PsiAnchor[] myElementAnchors;
    private final Language myLanguage;
    private PsiFragment[] myParents;
    private boolean myDuplicate;
    private boolean myChecked;
    private boolean myNested;
    private int myCost;

    public PsiFragment(PsiElement element2) {
        this(element2, 0);
    }

    public PsiFragment(PsiElement element2, int cost) {
        this.myElementAnchors = new PsiAnchor[]{this.createAnchor(element2)};
        this.myDuplicate = false;
        this.myChecked = false;
        this.myNested = false;
        this.myParents = null;
        this.myCost = cost;
        this.myLanguage = this.calcLanguage(element2);
    }

    protected Language calcLanguage(PsiElement element2) {
        return PsiFragment.doGetLanguageForElement(element2);
    }

    protected PsiAnchor createAnchor(PsiElement element2) {
        return (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create(element2));
    }

    public PsiFragment(List<? extends PsiElement> elements) {
        this(elements, 0, elements.size() - 1);
    }

    public PsiFragment(List<? extends PsiElement> elements, int from2, int to) {
        this.myElementAnchors = new PsiAnchor[to - from2 + 1];
        for (int i2 = from2; i2 <= to; ++i2) {
            this.myElementAnchors[i2 - from2] = this.createAnchor(elements.get(i2));
        }
        this.myDuplicate = false;
        this.myChecked = false;
        this.myNested = false;
        this.myParents = null;
        this.myLanguage = to >= from2 && from2 < elements.size() ? this.calcLanguage(elements.get(from2)) : null;
    }

    @NotNull
    private static Language doGetLanguageForElement(@NotNull PsiElement element2) {
        DuplicatesProfile profile;
        if (element2 == null) {
            PsiFragment.$$$reportNull$$$0(0);
        }
        if ((profile = DuplicatesProfile.findProfileForLanguage(element2.getLanguage())) == null) {
            Language language = element2.getLanguage();
            if (language == null) {
                PsiFragment.$$$reportNull$$$0(1);
            }
            return language;
        }
        Language language = profile.getLanguage(element2);
        if (language == null) {
            PsiFragment.$$$reportNull$$$0(2);
        }
        return language;
    }

    public void setCost(int c) {
        if (this.myCost != -1) {
            this.myCost = c;
        }
    }

    public void markDuplicate() {
        this.myDuplicate = true;
    }

    public boolean isNested() {
        if (this.myChecked) {
            return this.myNested;
        }
        this.myChecked = true;
        if (this.myParents != null) {
            PsiFragment parent1 = this.myParents[0];
            PsiFragment parent2 = this.myParents[1];
            if (parent1 != null) {
                this.myNested |= parent1.myDuplicate || parent1.isNested();
                if (parent2 != null) {
                    this.myNested |= parent2.myDuplicate || parent2.isNested();
                }
            }
        }
        return this.myNested;
    }

    public void setParent(PsiFragment f) {
        if (f == null) {
            return;
        }
        if (this.myParents == null) {
            this.myParents = new PsiFragment[]{f, null};
        } else {
            if (this.myParents[0] == f || this.myParents[1] == f) {
                return;
            }
            if (this.myParents[1] != null) {
                LOG.error("Third parent set.");
            }
            this.myParents[1] = f;
        }
    }

    public PsiElement[] getElements() {
        PsiElement[] elements = new PsiElement[this.myElementAnchors.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = this.myElementAnchors[i2].retrieve();
        }
        return elements;
    }

    @Nullable
    public PsiFile getFile() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getFile() : null;
    }

    public int getStartOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getStartOffset() : -1;
    }

    public int getEndOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[this.myElementAnchors.length - 1].getEndOffset() : -1;
    }

    public boolean intersectsWith(PsiFragment f) {
        int start2 = this.getStartOffset();
        int end = this.getEndOffset();
        int fStart = f.getStartOffset();
        int fEnd = f.getEndOffset();
        return Comparing.equal((Object)f.getFile(), (Object)this.getFile()) && (start2 <= fStart && fStart <= end || start2 <= fEnd && fEnd <= end);
    }

    public boolean contains(PsiFragment f) {
        int start2 = this.getStartOffset();
        int end = this.getEndOffset();
        int fStart = f.getStartOffset();
        int fEnd = f.getEndOffset();
        return Comparing.equal((Object)f.getFile(), (Object)this.getFile()) && start2 <= fStart && end >= fEnd;
    }

    public abstract boolean isEqual(PsiElement[] var1, int var2);

    @Nullable
    public UsageInfo getUsageInfo() {
        if (this.myElementAnchors.length == 1) {
            PsiElement element2 = this.myElementAnchors[0].retrieve();
            if (element2 == null || !element2.isValid()) {
                return null;
            }
            return new UsageInfo(element2);
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])this.getElements());
        if (parent == null) {
            return null;
        }
        int offs = parent.getTextRange().getStartOffset();
        int startOffsetInParent = this.getStartOffset() - offs;
        int endOffsetInParent = this.getEndOffset() - offs;
        if (startOffsetInParent < 0) {
            return null;
        }
        if (endOffsetInParent < startOffsetInParent) {
            return null;
        }
        return new UsageInfo(parent, startOffsetInParent, endOffsetInParent);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (PsiAnchor psiAnchor : this.myElementAnchors) {
            PsiElement element2 = psiAnchor.retrieve();
            if (element2 == null) continue;
            buffer.append(element2.getText());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsiFragment)) {
            return false;
        }
        PsiFragment other = (PsiFragment)o;
        return other.getStartOffset() == this.getStartOffset() && other.getEndOffset() == this.getEndOffset() && Comparing.equal((Object)other.getFile(), (Object)this.getFile());
    }

    public int hashCode() {
        int result2 = this.getStartOffset();
        result2 += 31 * result2 + this.getEndOffset();
        PsiFile file2 = this.getFile();
        if (file2 != null) {
            result2 += 31 * result2 + file2.getName().hashCode();
        }
        return result2;
    }

    public int getCost() {
        return this.myCost;
    }

    public int[][] getOffsets() {
        int[][] result2 = new int[this.myElementAnchors.length][2];
        int idx = 0;
        for (PsiAnchor anchor2 : this.myElementAnchors) {
            result2[idx][0] = anchor2.getStartOffset();
            result2[idx++][1] = anchor2.getEndOffset();
        }
        return result2;
    }

    public boolean containsMultipleFragments() {
        return this.myElementAnchors.length > 1;
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/util/PsiFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/util/PsiFragment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLanguageForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetLanguageForElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

