/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareBranchesDiffPanel
extends JPanel {
    @NlsSafe
    private final String myBranchName;
    private final Project myProject;
    @NlsSafe
    private final String myCurrentBranchName;
    private final DvcsCompareSettings myVcsSettings;
    @Nullable
    private CommitCompareInfo myCompareInfo;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public CompareBranchesDiffPanel(@NotNull Project project, @NotNull DvcsCompareSettings settings2, @NotNull String branchName, @NotNull String currentBranchName) {
        if (project == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(1);
        }
        if (branchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(2);
        }
        if (currentBranchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myCurrentBranchName = currentBranchName;
        this.myBranchName = branchName;
        this.myVcsSettings = settings2;
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(@Nls String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.setFocusable(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                CompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                CompareBranchesDiffPanel.this.refreshView();
            }
        });
        this.updateLabelText();
        this.myChangesBrowser = new MyChangesBrowser(project, Collections.emptyList());
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)this.myChangesBrowser, "Center");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setCompareInfo(@NotNull CommitCompareInfo commitCompareInfo) {
        void compareInfo;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (compareInfo == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(4);
        }
        this.myCompareInfo = compareInfo;
        this.refreshView();
    }

    private void refreshView() {
        if (this.myCompareInfo != null) {
            boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
            this.updateLabelText();
            List<Change> diff = this.myCompareInfo.getTotalDiff();
            if (swapSides) {
                diff = DvcsBranchUtil.swapRevisions(diff);
            }
            this.myChangesBrowser.setChangesToDisplay(diff);
        }
    }

    private void updateLabelText() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        HtmlChunk.Element branchNameText = HtmlChunk.text((String)this.myBranchName).code().bold();
        HtmlChunk.Element currentBranchNameText = HtmlChunk.text((String)this.myCurrentBranchName).code().bold();
        String diffBetween = swapSides ? DvcsBundle.message((String)"compare.branches.diff.panel.diff.between.files.in.branch.and.current.working.tree.on.branch", (Object[])new Object[]{branchNameText, currentBranchNameText}) : DvcsBundle.message((String)"compare.branches.diff.panel.difference.between.current.working.tree.on.branch.and.files.in.branch", (Object[])new Object[]{currentBranchNameText, branchNameText});
        String swapBranches = DvcsBundle.message((String)"compare.branches.diff.panel.swap.branches", (Object[])new Object[0]);
        this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)(diffBetween + "&emsp;" + HtmlChunk.link((String)"", (String)swapBranches))));
    }

    public void setEmptyText(@NotNull @NlsContexts.Label String text2) {
        if (text2 == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(5);
        }
        this.myChangesBrowser.getViewer().setEmptyText(text2);
    }

    public void disableControls() {
        this.myLabel.setEnabled(false);
    }

    public void enableControls() {
        this.myLabel.setEnabled(true);
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        JComponent jComponent = this.myChangesBrowser.getPreferredFocusedComponent();
        if (jComponent == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCompareInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCopyChangesAction
    extends DumbAwareAction {
        MyCopyChangesAction() {
            super(DvcsBundle.messagePointer((String)"compare.branches.diff.panel.get.from.branch.action", (Object[])new Object[0]), DvcsBundle.messagePointer((String)"compare.branches.diff.panel.get.from.branch.action.description", (Object[])new Object[]{CompareBranchesDiffPanel.this.myBranchName}), AllIcons.Actions.Download);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.GetVersion"));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyChangesAction.$$$reportNull$$$0(0);
            }
            boolean isEnabled = !CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible2 = CompareBranchesDiffPanel.this.myCompareInfo instanceof LocalCommitCompareInfo;
            e.getPresentation().setEnabled(isEnabled && isVisible2);
            e.getPresentation().setVisible(isVisible2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyChangesAction.$$$reportNull$$$0(1);
            }
            String title2 = DvcsBundle.message((String)"compare.branches.diff.panel.get.from.branch.title", (Object[])new Object[]{CompareBranchesDiffPanel.this.myBranchName});
            final List<Change> changes = CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(CompareBranchesDiffPanel.this.myProject, title2);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges(changes))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action2 = LocalHistory.getInstance().startAction(title2);
            new Task.Modal(CompareBranchesDiffPanel.this.myProject, DvcsBundle.message((String)"compare.branches.diff.panel.loading.content.from.branch.process", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (CompareBranchesDiffPanel.this.myCompareInfo != null) {
                            ((LocalCommitCompareInfo)CompareBranchesDiffPanel.this.myCompareInfo).copyChangesFromBranch(changes, swapSides);
                        }
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)DvcsBundle.message((String)"compare.branches.diff.panel.can.not.copy.changes.error", (Object[])new Object[0])));
                    }
                }

                public void onFinished() {
                    action2.finish();
                    CompareBranchesDiffPanel.this.refreshView();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyCopyChangesAction$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyCopyChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangesBrowser
    extends SimpleChangesBrowser {
        MyChangesBrowser(@NotNull Project project, List<? extends Change> changes) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.setChangesToDisplay(changes);
        }

        @Override
        public void setChangesToDisplay(@NotNull Collection<? extends Change> changes) {
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            List<Change> oldSelection = this.getSelectedChanges();
            super.setChangesToDisplay(changes);
            this.myViewer.setSelectedChanges(DvcsBranchUtil.swapRevisions(oldSelection));
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setChangesToDisplay";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

