/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateAction
extends BaseRunConfigurationAction {
    public CreateAction() {
        this(null);
    }

    public CreateAction(Icon icon2) {
        super(ExecutionBundle.messagePointer((String)"create.run.configuration.action.name", (Object[])new Object[0]), Presentation.NULL_STRING, icon2);
        this.getTemplatePresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
    }

    @Override
    protected void perform(ConfigurationContext context2) {
        RunnerAndConfigurationSettings configuration2 = context2.findExisting();
        if (configuration2 == null) {
            configuration2 = context2.getConfiguration();
        }
        this.choosePolicy(context2).perform(configuration2, context2);
    }

    @Override
    protected void perform(RunnerAndConfigurationSettings configurationSettings, ConfigurationContext context2) {
        this.choosePolicy(context2).perform(configurationSettings, context2);
    }

    @Override
    protected void updatePresentation(Presentation presentation2, @NotNull String actionText, ConfigurationContext context2) {
        if (actionText == null) {
            CreateAction.$$$reportNull$$$0(0);
        }
        this.choosePolicy(context2).update(presentation2, context2, actionText);
    }

    private BaseCreatePolicy choosePolicy(ConfigurationContext context2) {
        RunnerAndConfigurationSettings configuration2 = this.findExisting(context2);
        return configuration2 == null ? Holder.CREATE_AND_EDIT : Holder.EDIT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction", "updatePresentation"));
    }

    private static class Holder {
        private static final BaseCreatePolicy CREATE_AND_EDIT = new CreateAndEditPolicy();
        private static final BaseCreatePolicy EDIT = new EditPolicy();

        private Holder() {
        }
    }

    private static class EditPolicy
    extends CreateAndEditPolicy {
        private EditPolicy() {
        }

        @Override
        protected void perform(RunnerAndConfigurationSettings configuration2, ConfigurationContext context2) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunDialog.editConfiguration(context2.getProject(), configuration2, ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration2.getName()}));
            }
        }
    }

    private static class CreateAndEditPolicy
    extends BaseCreatePolicy {
        private CreateAndEditPolicy() {
        }

        @Override
        protected void updateText(Presentation presentation2, String actionText) {
            presentation2.setText(ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), false);
        }

        @Override
        protected void perform(RunnerAndConfigurationSettings configuration2, ConfigurationContext context2) {
            if (ApplicationManager.getApplication().isUnitTestMode() || RunDialog.editConfiguration(context2.getProject(), configuration2, ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration2.getName()}))) {
                RunManagerImpl runManager = (RunManagerImpl)context2.getRunManager();
                runManager.addConfiguration(configuration2);
                runManager.setSelectedConfiguration(configuration2);
                RunConfigurationOptionUsagesCollector.logAddNew(context2.getProject(), configuration2.getType().getId(), context2.getPlace());
            }
        }
    }

    private static abstract class BaseCreatePolicy {
        private BaseCreatePolicy() {
        }

        public void update(Presentation presentation2, ConfigurationContext context2, @NotNull String actionText) {
            if (actionText == null) {
                BaseCreatePolicy.$$$reportNull$$$0(0);
            }
            this.updateText(presentation2, actionText);
        }

        protected abstract void updateText(Presentation var1, String var2);

        protected abstract void perform(RunnerAndConfigurationSettings var1, ConfigurationContext var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction$BaseCreatePolicy", "update"));
        }
    }
}

