/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RestoreHiddenConfigurationsAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            e.getPresentation().setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.toolbar.action.name", (Object[])new Object[0]));
            return;
        }
        e.getPresentation().setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.popup.action.name", (Object[])new Object[0]));
        RunDashboardServiceViewContributor root = (RunDashboardServiceViewContributor)ServiceViewActionUtils.getTarget((AnActionEvent)e, RunDashboardServiceViewContributor.class);
        if (root != null) {
            e.getPresentation().setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            return;
        }
        if (!PropertiesComponent.getInstance((Project)project).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            JBIterable nodes = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardNode.class);
            e.getPresentation().setEnabledAndVisible(nodes.isNotEmpty() && RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        if (types.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set<RunConfiguration> hiddenConfigurations = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project)).getHiddenConfigurations();
        List configurations = ContainerUtil.filter(hiddenConfigurations, configuration2 -> types.contains(configuration2.getType()));
        e.getPresentation().setEnabledAndVisible(!configurations.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RunDashboardServiceViewContributor root = (RunDashboardServiceViewContributor)ServiceViewActionUtils.getTarget((AnActionEvent)e, RunDashboardServiceViewContributor.class);
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace()) || root != null || !PropertiesComponent.getInstance((Project)project).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
            runDashboardManager.restoreConfigurations((Collection<? extends RunConfiguration>)new THashSet(runDashboardManager.getHiddenConfigurations()));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        List configurations = ContainerUtil.filter(runDashboardManager.getHiddenConfigurations(), configuration2 -> types.contains(configuration2.getType()));
        runDashboardManager.restoreConfigurations(configurations);
    }

    private static boolean hasHiddenConfiguration(Project project) {
        return !((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project)).getHiddenConfigurations().isEmpty();
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        JBIterable targets2 = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardNode.class);
        if (targets2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConfigurationType> types = new HashSet<ConfigurationType>();
        for (RunDashboardNode node2 : targets2) {
            if (node2 instanceof RunDashboardRunConfigurationNode) {
                types.add(((RunDashboardRunConfigurationNode)node2).getConfigurationSettings().getType());
                continue;
            }
            if (node2 instanceof GroupingNode) {
                RunDashboardGroupImpl group2 = (RunDashboardGroupImpl)((GroupingNode)node2).getGroup();
                ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(group2.getValue(), ConfigurationType.class);
                if (type == null) {
                    return Collections.emptySet();
                }
                types.add(type);
                continue;
            }
            return Collections.emptySet();
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

