/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.TokenBuffer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ConsoleTokenUtil {
    private static final char BACKSPACE = '\b';
    private static final Key<ConsoleViewContentType> CONTENT_TYPE = Key.create((String)"ConsoleViewContentType");
    private static final Key<Boolean> USER_INPUT_SENT = Key.create((String)"USER_INPUT_SENT");
    static final Key<Boolean> MANUAL_HYPERLINK = Key.create((String)"MANUAL_HYPERLINK");

    ConsoleTokenUtil() {
    }

    private static void normalizeBackspaceCharacters(@NotNull StringBuilder text2) {
        int ind;
        if (text2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(0);
        }
        if ((ind = StringUtil.indexOf((CharSequence)text2, (char)'\b')) < 0) {
            return;
        }
        int guardLength = 0;
        int newLength = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            boolean append;
            char ch = text2.charAt(i2);
            if (ch == '\b') {
                assert (guardLength <= newLength);
                if (guardLength == newLength) {
                    append = guardLength == 0;
                } else {
                    boolean bl = append = text2.charAt(newLength - 1) == '\b';
                    if (!append) {
                        --newLength;
                    }
                }
            } else {
                append = true;
            }
            if (!append) continue;
            text2.setCharAt(newLength, ch);
            ++newLength;
            if (ch != '\r' && ch != '\n') continue;
            guardLength = newLength;
        }
        text2.setLength(newLength);
    }

    static int evaluateBackspacesInTokens(@NotNull List<? extends TokenBuffer.TokenInfo> source, int sourceStartIndex, @NotNull List<? super TokenBuffer.TokenInfo> dest) {
        if (source == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(1);
        }
        if (dest == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(2);
        }
        int backspacesFromNextToken = 0;
        for (int i2 = source.size() - 1; i2 >= sourceStartIndex; --i2) {
            TokenBuffer.TokenInfo newToken;
            TokenBuffer.TokenInfo token2 = source.get(i2);
            if (StringUtil.containsChar((String)token2.getText(), (char)'\b') || backspacesFromNextToken > 0) {
                StringBuilder tokenTextBuilder = new StringBuilder(token2.getText().length() + backspacesFromNextToken);
                tokenTextBuilder.append(token2.getText());
                StringUtil.repeatSymbol((Appendable)tokenTextBuilder, (char)'\b', (int)backspacesFromNextToken);
                ConsoleTokenUtil.normalizeBackspaceCharacters(tokenTextBuilder);
                backspacesFromNextToken = ConsoleTokenUtil.getBackspacePrefixLength(tokenTextBuilder);
                String newText = tokenTextBuilder.substring(backspacesFromNextToken);
                newToken = new TokenBuffer.TokenInfo(token2.contentType, newText, token2.getHyperlinkInfo());
            } else {
                newToken = token2;
            }
            dest.add(newToken);
        }
        Collections.reverse(dest);
        return backspacesFromNextToken;
    }

    private static int getBackspacePrefixLength(@NotNull CharSequence text2) {
        if (text2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.countChars((CharSequence)text2, (char)'\b', (int)0, (boolean)true);
    }

    static ConsoleViewContentType getTokenType(@NotNull RangeMarker m) {
        if (m == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(4);
        }
        return (ConsoleViewContentType)m.getUserData(CONTENT_TYPE);
    }

    private static void saveTokenType(@NotNull RangeMarker m, @NotNull ConsoleViewContentType contentType) {
        if (m == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(6);
        }
        m.putUserData(CONTENT_TYPE, (Object)contentType);
    }

    static RangeMarker findTokenMarker(@NotNull Editor editor, @NotNull Project project, int offset) {
        if (editor == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeMarker[] marker = new RangeMarker[1];
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(editor.getDocument(), project, true);
        model2.processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)m -> {
            if (ConsoleTokenUtil.getTokenType(m) == null || m.getStartOffset() > offset || offset + 1 > m.getEndOffset()) {
                return true;
            }
            marker[0] = m;
            return false;
        }));
        return marker[0];
    }

    static void createTokenRangeHighlighter(@NotNull Editor editor, @NotNull Project project, @NotNull ConsoleViewContentType contentType, int startOffset, int endOffset) {
        if (editor == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(10);
        }
        if (contentType == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(editor.getDocument(), project, true);
        int layer = 1001;
        model2.addRangeHighlighterAndChangeAttributes(contentType.getAttributesKey(), startOffset, endOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)ex -> {
            if (ex.getTextAttributesKey() == null) {
                ex.setTextAttributes(contentType.getAttributes());
            }
            ConsoleTokenUtil.saveTokenType(ex, contentType);
        }));
    }

    static void updateAllTokenTextAttributes(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(13);
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument(editor.getDocument(), project, false);
        for (RangeHighlighter tokenMarker : model2.getAllHighlighters()) {
            ConsoleViewContentType contentType = ConsoleTokenUtil.getTokenType((RangeMarker)tokenMarker);
            if (contentType == null || contentType.getAttributesKey() != null || !(tokenMarker instanceof RangeHighlighterEx)) continue;
            ((RangeHighlighterEx)tokenMarker).setTextAttributes(contentType.getAttributes());
        }
    }

    @NotNull
    static CharSequence computeTextToSend(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(15);
        }
        StringBuilder textToSend = new StringBuilder();
        RangeMarker marker = ConsoleTokenUtil.findTokenMarker(editor, project, editor.getCaretModel().getOffset() - 1);
        while (marker != null) {
            ConsoleViewContentType tokenType = ConsoleTokenUtil.getTokenType(marker);
            if (tokenType != null) {
                if (tokenType != ConsoleViewContentType.USER_INPUT || marker.getUserData(USER_INPUT_SENT) == Boolean.TRUE) break;
                marker.putUserData(USER_INPUT_SENT, (Object)true);
                textToSend.insert(0, marker.getDocument().getText(TextRange.create((Segment)marker)));
            }
            marker = ((RangeMarkerImpl)marker).findRangeMarkerBefore();
        }
        StringBuilder stringBuilder = textToSend;
        if (stringBuilder == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(16);
        }
        return stringBuilder;
    }

    static void highlightTokenTextAttributes(@NotNull Editor editor, @NotNull Project project, @NotNull List<? extends TokenBuffer.TokenInfo> tokens, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull Collection<? super ConsoleViewContentType> contentTypes, @NotNull List<? super Pair<String, ConsoleViewContentType>> contents) {
        if (editor == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(18);
        }
        if (tokens == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(19);
        }
        if (hyperlinks == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(20);
        }
        if (contentTypes == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(21);
        }
        if (contents == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(22);
        }
        int offset = editor.getDocument().getTextLength();
        int tokenLength = 0;
        for (int i2 = tokens.size() - 1; i2 >= 0; --i2) {
            int start2;
            TokenBuffer.TokenInfo prevToken;
            TokenBuffer.TokenInfo token2 = tokens.get(i2);
            contentTypes.add((ConsoleViewContentType)token2.contentType);
            contents.add((Pair<String, ConsoleViewContentType>)new Pair((Object)token2.getText(), (Object)token2.contentType));
            TokenBuffer.TokenInfo tokenInfo = prevToken = i2 == 0 ? null : tokens.get(i2 - 1);
            if (prevToken != null && token2.contentType == prevToken.contentType && token2.getHyperlinkInfo() == prevToken.getHyperlinkInfo() || (start2 = Math.max(0, offset - (tokenLength += token2.length()))) == offset) continue;
            HyperlinkInfo info2 = token2.getHyperlinkInfo();
            if (info2 != null) {
                hyperlinks.createHyperlink(start2, offset, null, info2).putUserData(MANUAL_HYPERLINK, (Object)true);
            }
            ConsoleTokenUtil.createTokenRangeHighlighter(editor, project, token2.contentType, start2, offset);
            offset = start2;
            tokenLength = 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleTokenUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTypes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleTokenUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTextToSend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBackspaceCharacters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBackspacesInTokens";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBackspacePrefixLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTokenType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveTokenType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTokenMarker";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTokenRangeHighlighter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAllTokenTextAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeTextToSend";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "highlightTokenTextAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

