/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/impl/RunConfigurableTreeRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "(Lcom/intellij/execution/impl/RunManagerImpl;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.execution.impl"})
public final class RunConfigurableTreeRenderer
extends ColoredTreeCellRenderer {
    private final RunManagerImpl runManager;

    public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        Boolean isShared = null;
        Object object = userObject;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"userObject");
        String name = RunConfigurableKt.getUserObjectName(object);
        boolean isDumb = DumbService.isDumb((Project)this.runManager.getProject());
        if (userObject instanceof ConfigurationType) {
            TreeNode treeNode = ((DefaultMutableTreeNode)value2).getParent();
            if (treeNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            SimpleTextAttributes simpleTextAttributes = ((DefaultMutableTreeNode)treeNode).isRoot() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (isDumb && !ConfigurationTypeUtil.isEditableInDumbMode((ConfigurationType)((ConfigurationType)userObject)) ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(name, simpleTextAttributes);
            this.setIcon(((ConfigurationType)userObject).getIcon());
        } else if (userObject instanceof String) {
            this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(AllIcons.Nodes.Folder);
        } else if (userObject instanceof ConfigurationFactory) {
            this.append(name, isDumb && !((ConfigurationFactory)userObject).isEditableInDumbMode() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(((ConfigurationFactory)userObject).getIcon());
        } else {
            RunnerAndConfigurationSettings configuration2 = null;
            if (userObject instanceof SingleConfigurationConfigurable) {
                RunnerAndConfigurationSettings configurationSettings;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)((Object)userObject)).getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"userObject.settings");
                configuration2 = configurationSettings = runnerAndConfigurationSettings;
                isShared = ((SingleConfigurationConfigurable)((Object)userObject)).isStoredInFile();
                this.setIcon(ProgramRunnerUtil.getConfigurationIcon(configurationSettings, !((SingleConfigurationConfigurable)((Object)userObject)).isValid()));
            } else if (userObject instanceof RunnerAndConfigurationSettings) {
                isShared = ((RunnerAndConfigurationSettings)userObject).isShared();
                this.setIcon(this.runManager.getConfigurationIcon((RunnerAndConfigurationSettings)userObject));
                configuration2 = (RunnerAndConfigurationSettings)userObject;
            }
            if (configuration2 != null) {
                SimpleTextAttributes simpleTextAttributes = configuration2.isTemporary() ? SimpleTextAttributes.GRAY_ATTRIBUTES : (isDumb && !ConfigurationTypeUtil.isEditableInDumbMode((RunnerAndConfigurationSettings)configuration2) ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(name, simpleTextAttributes);
            }
        }
        if (isShared == null) {
            this.setIconTextGap(2);
        } else {
            this.setIcon(new LayeredIcon(this.getIcon(), isShared != false ? AllIcons.Nodes.Shared : EmptyIcon.ICON_16));
            this.setIconTextGap(0);
        }
    }

    public RunConfigurableTreeRenderer(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        this.runManager = runManager;
    }
}

