/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create("testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    public TestTreeView() {
        this.setLargeModel(true);
    }

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 != null && paths2.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model2) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model2.getRoot())));
        this.getSelectionModel().setSelectionMode(model2.getProperties().getSelectionMode());
        this.myModel = model2;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
    }

    @Override
    public Object getData(@NotNull String dataId) {
        RunProfile configuration2;
        TreePath[] paths2;
        if (dataId == null) {
            TestTreeView.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (AbstractTestProxy.DATA_KEYS.is(dataId) && (paths2 = this.getSelectionPaths()) != null) {
            return Arrays.stream(paths2).map(path2 -> this.getSelectedTest((TreePath)path2)).filter(Objects::nonNull).toArray(AbstractTestProxy[]::new);
        }
        if (MODEL_DATA_KEY.is(dataId)) {
            return this.myModel;
        }
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        if (AbstractTestProxy.DATA_KEY.is(dataId)) {
            return testProxy;
        }
        if (PlatformDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) {
            TestFrameworkRunningModel model2 = this.myModel;
            return Collections.singletonList(dataId1 -> this.getSlowData(dataId1, testProxy, model2));
        }
        if (RunConfiguration.DATA_KEY.is(dataId) && (configuration2 = this.myModel.getProperties().getConfiguration()) instanceof RunConfiguration) {
            return configuration2;
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId, @NotNull AbstractTestProxy testProxy, @NotNull TestFrameworkRunningModel model2) {
        if (dataId == null) {
            TestTreeView.$$$reportNull$$$0(1);
        }
        if (testProxy == null) {
            TestTreeView.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            TestTreeView.$$$reportNull$$$0(3);
        }
        Project project = model2.getProperties().getProject();
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return TestsUIUtil.getOpenFileDescriptor(testProxy, model2);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Location location = testProxy.getLocation(project, model2.getProperties().getScope());
            PsiElement psiElement = location != null ? location.getPsiElement() : null;
            return psiElement == null || !psiElement.isValid() ? null : psiElement;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return testProxy.getLocation(project, model2.getProperties().getScope());
        }
        if (Location.DATA_KEYS.is(dataId)) {
            AbstractTestProxy[] proxies = AbstractTestProxy.DATA_KEYS.getData(this);
            return proxies == null ? null : Arrays.stream(proxies).map(p -> p.getLocation(project, model2.getProperties().getScope())).filter(Objects::nonNull).toArray(Location[]::new);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            AbstractTestProxy[] proxies = AbstractTestProxy.DATA_KEYS.getData(this);
            return proxies == null ? null : Arrays.stream(proxies).map(p -> p.getLocation(project, model2.getProperties().getScope())).filter(Objects::nonNull).map(l -> l.getPsiElement()).toArray(PsiElement[]::new);
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        AbstractTestProxy selectedTest;
        PsiElement element2;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(4);
        }
        String fqn = (element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null ? CopyReferenceAction.elementToFqn(element2) : ((selectedTest = this.getSelectedTest()) != null ? selectedTest.getLocationUrl() : null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(fqn));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        AbstractTestProxy test;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(5);
        }
        return (test = this.getSelectedTest()) != null && test.getLocationUrl() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(6);
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
            AbstractTestProxy testProxy = this.getSelectedTest((TreePath)path2);
            if (testProxy == null) {
                return null;
            }
            return this.getPresentableName(testProxy);
        }), Registry.is((String)"tests.view.node.expanding.search"));
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupMenu((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), obj2 -> {
            Object element2;
            Object userObject = TreeUtil.getUserObject((Object)obj2);
            Object object = element2 = userObject instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : null;
            if (element2 instanceof AbstractTestProxy) {
                return (PsiElement)this.getSlowData(CommonDataKeys.PSI_ELEMENT.getName(), (AbstractTestProxy)element2, this.myModel);
            }
            return null;
        });
    }

    protected String getPresentableName(AbstractTestProxy testProxy) {
        return testProxy.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/TestTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

