/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TargetPathFragment<T extends TargetEnvironmentAwareRunProfile>
extends SettingsEditorFragment<T, LabeledComponent<JTextField>> {
    public static final String ID = "target.project.path";

    public TargetPathFragment() {
        super(ID, null, null, (JComponent)LabeledComponent.create((JComponent)new JTextField(), (String)ExecutionBundle.message((String)"label.project.path.on.target", (Object[])new Object[0]), (String)"West"), -1, (t, component2) -> ((JTextField)component2.getComponent()).setText(TargetPathFragment.getPath(t)), (t, component2) -> TargetPathFragment.setPath(t, ((JTextField)component2.getComponent()).getText()), t -> t.getDefaultTargetName() != null);
    }

    private static String getPath(TargetEnvironmentAwareRunProfile t) {
        ModuleBasedConfiguration configuration2 = (ModuleBasedConfiguration)t;
        if (configuration2.getProjectPathOnTarget() != null) {
            return configuration2.getProjectPathOnTarget();
        }
        String targetName = t.getDefaultTargetName();
        if (targetName == null) {
            return "";
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)configuration2.getProject()).getTargets().findByName(targetName);
        return targetEnvironmentConfiguration == null ? null : targetEnvironmentConfiguration.getProjectRootOnTarget();
    }

    private static void setPath(TargetEnvironmentAwareRunProfile t, String path2) {
        ModuleBasedConfiguration configuration2 = (ModuleBasedConfiguration)t;
        configuration2.setProjectPathOnTarget(path2);
        String targetName = t.getDefaultTargetName();
        if (targetName == null) {
            return;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)configuration2.getProject()).getTargets().findByName(targetName);
        if (targetEnvironmentConfiguration != null && Comparing.strEqual((String)targetEnvironmentConfiguration.getProjectRootOnTarget(), (String)path2)) {
            configuration2.setProjectPathOnTarget(null);
        }
    }
}

