/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.EventDispatcher;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

final class FacetModificationTrackingServiceImpl
extends FacetModificationTrackingService {
    private final ConcurrentMap<Facet<?>, Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>> myModificationsTrackers = new ConcurrentHashMap();

    FacetModificationTrackingServiceImpl(Module module) {
        module.getProject().getMessageBus().connect((Disposable)module).subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetModificationTrackingListener(module));
    }

    @NotNull
    public ModificationTracker getFacetModificationTracker(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModificationTrackingServiceImpl.$$$reportNull$$$0(0);
        }
        ModificationTracker modificationTracker = (ModificationTracker)this.getFacetInfo(facet).first;
        if (modificationTracker == null) {
            FacetModificationTrackingServiceImpl.$$$reportNull$$$0(1);
        }
        return modificationTracker;
    }

    private Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> getFacetInfo(Facet<?> facet) {
        Pair pair = (Pair)this.myModificationsTrackers.get(facet);
        if (pair != null) {
            return pair;
        }
        this.myModificationsTrackers.putIfAbsent(facet, (Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>)new Pair((Object)new SimpleModificationTracker(), (Object)EventDispatcher.create(ModificationTrackerListener.class)));
        return (Pair)this.myModificationsTrackers.get(facet);
    }

    public void incFacetModificationTracker(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModificationTrackingServiceImpl.$$$reportNull$$$0(2);
        }
        Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> pair = this.getFacetInfo(facet);
        ((SimpleModificationTracker)pair.first).incModificationCount();
        ((ModificationTrackerListener)((EventDispatcher)pair.second).getMulticaster()).modificationCountChanged(facet);
    }

    public <T extends Facet<?>> void addModificationTrackerListener(T facet, ModificationTrackerListener<? super T> listener2, Disposable parent) {
        ((EventDispatcher)this.getFacetInfo(facet).second).addListener(listener2, parent);
    }

    public void removeModificationTrackerListener(Facet<?> facet, ModificationTrackerListener<?> listener2) {
        ((EventDispatcher)this.getFacetInfo(facet).second).removeListener(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModificationTrackingServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModificationTrackingServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFacetModificationTracker";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "incFacetModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class FacetModificationTrackingListener
    implements FacetManagerListener {
        private final Module module;

        FacetModificationTrackingListener(Module module) {
            this.module = module;
        }

        public void facetConfigurationChanged(@NotNull Facet facet) {
            if (facet == null) {
                FacetModificationTrackingListener.$$$reportNull$$$0(0);
            }
            if (this.module == facet.getModule()) {
                FacetModificationTrackingServiceImpl.this.incFacetModificationTracker(facet);
            }
        }

        public void facetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                FacetModificationTrackingListener.$$$reportNull$$$0(1);
            }
            if (this.module == facet.getModule()) {
                FacetModificationTrackingServiceImpl.this.myModificationsTrackers.remove(facet);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "facet";
            objectArray2[1] = "com/intellij/facet/impl/FacetModificationTrackingServiceImpl$FacetModificationTrackingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetConfigurationChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

