/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module, FacetType<F, ?> type) {
        return FacetUtil.addFacet(module, type, type.getPresentableName());
    }

    public static <F extends Facet> F addFacet(@NotNull Module module, @NotNull FacetType<F, ?> type, @NotNull String facetName) {
        if (module == null) {
            FacetUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            FacetUtil.$$$reportNull$$$0(1);
        }
        if (facetName == null) {
            FacetUtil.$$$reportNull$$$0(2);
        }
        ModifiableFacetModel model2 = FacetManager.getInstance((Module)module).createModifiableModel();
        Object facet = FacetUtil.createFacet(module, type, facetName);
        ApplicationManager.getApplication().runWriteAction(() -> {
            model2.addFacet(facet);
            model2.commit();
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module, FacetType<F, C> type, @NotNull String facetName) {
        if (facetName == null) {
            FacetUtil.$$$reportNull$$$0(3);
        }
        return (F)FacetManager.getInstance((Module)module).createFacet(type, facetName, type.createDefaultConfiguration(), null);
    }

    public static void deleteFacet(Facet facet) {
        WriteAction.runAndWait(() -> {
            if (!FacetUtil.isRegistered(facet)) {
                return;
            }
            ModifiableFacetModel model2 = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
            model2.removeFacet(facet);
            model2.commit();
        });
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration2, @Nullable Element config2) throws InvalidDataException {
        if (configuration2 == null) {
            FacetUtil.$$$reportNull$$$0(4);
        }
        if (config2 != null) {
            if (configuration2 instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)((PersistentStateComponent)configuration2), (Element)config2);
            } else {
                configuration2.readExternal(config2);
            }
        }
    }

    @NotNull
    public static Element saveFacetConfiguration(@NotNull FacetConfiguration configuration2) {
        if (configuration2 == null) {
            FacetUtil.$$$reportNull$$$0(5);
        }
        if (configuration2 instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration2).getState();
            if (state instanceof Element) {
                Element element2 = (Element)state;
                if (element2 == null) {
                    FacetUtil.$$$reportNull$$$0(6);
                }
                return element2;
            }
            Element result2 = XmlSerializer.serialize((Object)state);
            Element element3 = result2 == null ? new Element("configuration") : result2;
            if (element3 == null) {
                FacetUtil.$$$reportNull$$$0(7);
            }
            return element3;
        }
        if (configuration2 instanceof InvalidFacetConfiguration) {
            Element element4 = ((InvalidFacetConfiguration)configuration2).getFacetState().getConfiguration();
            if (element4 == null) {
                FacetUtil.$$$reportNull$$$0(8);
            }
            return element4;
        }
        Element config2 = new Element("configuration");
        configuration2.writeExternal(config2);
        Element element5 = config2;
        if (element5 == null) {
            FacetUtil.$$$reportNull$$$0(9);
        }
        return element5;
    }

    @ApiStatus.Internal
    @Nullable
    public static Element saveFacetConfiguration(Facet<?> facet) {
        Element config2;
        try {
            FacetConfiguration configuration2 = facet.getConfiguration();
            config2 = FacetUtil.saveFacetConfiguration(configuration2);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)facet).writeExternal(config2);
            }
        }
        catch (WriteExternalException e) {
            return null;
        }
        return config2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "saveFacetConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFacet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFacet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFacetConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveFacetConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

