/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.LogEventDetector;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance(ProductivityFeaturesRegistry.class);
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, Map<String, List<LogEventDetector>>> myLogEventDetectors = new HashMap<String, Map<String, List<LogEventDetector>>>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myAdditionalFeaturesLoaded = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
    }

    private void reloadFromXml() {
        try {
            this.readFromXml("/ProductivityFeaturesRegistry.xml");
        }
        catch (FileNotFoundException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        try {
            this.readFromXml("/IdeSpecificFeatures.xml");
        }
        catch (FileNotFoundException e) {
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private void readFromXml(@NotNull @NonNls String path2) throws JDOMException, IOException {
        if (path2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(0);
        }
        this.readFromXml(path2, ProductivityFeaturesRegistryImpl.class);
    }

    private void readFromXml(@NotNull String path2, @NotNull Class<?> clazz) throws JDOMException, IOException {
        if (path2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(2);
        }
        Element root = JDOMUtil.load(clazz, (String)path2);
        for (Element groupElement : root.getChildren(TAG_GROUP)) {
            this.readGroup(groupElement);
        }
        this.readFilters(root);
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.myAdditionalFeaturesLoaded = true;
        this.loadFeaturesFromProviders(ProductivityFeaturesProvider.EP_NAME.getExtensionList());
    }

    private void loadFeaturesFromProviders(@NotNull List<? extends ProductivityFeaturesProvider> providers) {
        if (providers == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(3);
        }
        for (ProductivityFeaturesProvider productivityFeaturesProvider : providers) {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptors;
            for (GroupDescriptor[] xmlUrl : productivityFeaturesProvider.getXmlFilesUrls()) {
                try {
                    this.readFromXml((String)xmlUrl, productivityFeaturesProvider.getClass());
                }
                catch (Exception e) {
                    LOG.error("Error while reading " + (String)xmlUrl + " from " + productivityFeaturesProvider + ": " + e.getMessage());
                }
            }
            GroupDescriptor[] groupDescriptors = productivityFeaturesProvider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptors = productivityFeaturesProvider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptors) {
                    FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                    if (featureLoadedStatistics != null) {
                        featureDescriptor.copyStatistics(featureLoadedStatistics);
                    }
                    this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
                    this.addLogEventDetectors(featureDescriptor);
                }
            }
            if ((applicabilityFilters = productivityFeaturesProvider.getApplicabilityFilters()) == null) continue;
            for (ApplicabilityFilter applicabilityFilter : applicabilityFilters) {
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)applicabilityFilter.getPrefix(), (Object)applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element2) {
        for (Element filterElement : element2.getChildren(TAG_FILTER)) {
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureStatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)filterElement.getAttributeValue(PREFIX_ATTR), (Object)filter));
            }
            catch (Exception e) {
                LOG.error("Cannot instantiate filter " + className, (Throwable)e);
            }
        }
    }

    private void addLogEventDetectors(FeatureDescriptor featureDescriptor) {
        List featureDetectors = featureDescriptor.getLogEventDetectors();
        for (LogEventDetector detector : featureDetectors) {
            Map event2detectors = this.myLogEventDetectors.computeIfAbsent(detector.groupId(), s -> new HashMap());
            List detectors = event2detectors.computeIfAbsent(detector.eventId(), s -> new ArrayList());
            detectors.add(detector);
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId2 = groupDescriptor.getId();
        this.myGroups.put(groupId2, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        for (Element featureElement : groupElement.getChildren(TAG_FEATURE)) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor, featureElement);
            if (!TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) {
                this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
            }
            this.addLogEventDetectors(featureDescriptor);
        }
    }

    @Nullable
    private FeatureDescriptor getFeatureDescriptorByLogEvent(@NotNull String groupId2, @NotNull String eventId, @NotNull Map<String, Object> eventData) {
        Optional<LogEventDetector> detector;
        List<LogEventDetector> detectors;
        if (groupId2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(4);
        }
        if (eventId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(5);
        }
        if (eventData == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(6);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        Map<String, List<LogEventDetector>> event2detectors = this.myLogEventDetectors.get(groupId2);
        if (event2detectors != null && (detectors = event2detectors.get(eventId)) != null && (detector = detectors.stream().filter(d -> d.succeed(eventData)).findFirst()).isPresent()) {
            return this.getFeatureDescriptorEx(detector.get().featureId());
        }
        return null;
    }

    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        Set<String> set2 = this.myFeatures.keySet();
        if (set2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(7);
        }
        return set2;
    }

    public FeatureDescriptor getFeatureDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(8);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.getFeatureDescriptorEx(id2);
    }

    public FeatureDescriptor getFeatureDescriptorEx(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(9);
        }
        if (WELCOME.equals(id2)) {
            return new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
        }
        return this.myFeatures.get(id2);
    }

    public GroupDescriptor getGroupDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(10);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id2);
    }

    public ApplicabilityFilter @NotNull [] getMatchingFilters(@NotNull String featureId) {
        if (featureId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(11);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        ArrayList<ApplicabilityFilter> filters = new ArrayList<ApplicabilityFilter>();
        for (Pair<String, ApplicabilityFilter> pair : this.myApplicabilityFilters) {
            if (!featureId.startsWith((String)pair.getFirst())) continue;
            filters.add((ApplicabilityFilter)pair.getSecond());
        }
        ApplicabilityFilter[] applicabilityFilterArray = filters.toArray(new ApplicabilityFilter[0]);
        if (applicabilityFilterArray == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(12);
        }
        return applicabilityFilterArray;
    }

    @NonNls
    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    @TestOnly
    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureIds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFeaturesFromProviders";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptorByLogEvent";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptorEx";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EventLogSubscribeActivity
    implements StartupActivity.DumbAware {
        private static final AtomicBoolean isSubscribed = new AtomicBoolean(false);

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                EventLogSubscribeActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
            if (registry instanceof ProductivityFeaturesRegistryImpl) {
                ProductivityFeaturesRegistryImpl registryImpl = (ProductivityFeaturesRegistryImpl)registry;
                FeatureUsageTracker usageTracker = FeatureUsageTracker.getInstance();
                if (usageTracker != null && !isSubscribed.getAndSet(true)) {
                    ((EventLogListenersManager)ApplicationManager.getApplication().getService(EventLogListenersManager.class)).subscribe((logEvent, rawEventId, rawData) -> {
                        FeatureDescriptor feature = registryImpl.getFeatureDescriptorByLogEvent(logEvent.getGroup().getId(), logEvent.getEvent().getId(), logEvent.getEvent().getData());
                        if (feature != null) {
                            usageTracker.triggerFeatureUsed(feature.getId());
                        }
                    }, "FUS");
                }
            } else {
                LOG.warn("No ProductivityFeaturesRegistry implementation. Features from Event Log won't be recorded");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl$EventLogSubscribeActivity", "runActivity"));
        }
    }
}

