/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AlignmentCyclesDetector {
    private final int myTotalAlignmentsCount;
    private int myBlockRollbacks;
    private LeafBlockWrapper myOffsetResponsibleBlock;
    private int myBeforeTotalSpaces;
    private final Map<List<LeafBlockWrapper>, Set<Pair<Integer, Integer>>> map = new HashMap<List<LeafBlockWrapper>, Set<Pair<Integer, Integer>>>();

    public AlignmentCyclesDetector(int totalAlignmentsCount) {
        this.myTotalAlignmentsCount = totalAlignmentsCount;
    }

    public void registerOffsetResponsibleBlock(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            AlignmentCyclesDetector.$$$reportNull$$$0(0);
        }
        this.myOffsetResponsibleBlock = block;
        WhiteSpace whitespace = block.getWhiteSpace();
        this.myBeforeTotalSpaces = whitespace.getTotalSpaces();
    }

    public boolean isCycleDetected() {
        return this.myBlockRollbacks > this.myTotalAlignmentsCount;
    }

    public void registerBlockRollback(LeafBlockWrapper currentBlock) {
        List<LeafBlockWrapper> pairId = Arrays.asList(currentBlock, this.myOffsetResponsibleBlock);
        Set<Pair<Integer, Integer>> pairs = this.map.get(pairId);
        if (pairs == null) {
            pairs = new HashSet<Pair<Integer, Integer>>();
            this.map.put(pairId, pairs);
        }
        WhiteSpace whitespace = this.myOffsetResponsibleBlock.getWhiteSpace();
        int newSpaces = whitespace.getTotalSpaces();
        boolean added2 = pairs.add((Pair<Integer, Integer>)Pair.create((Object)this.myBeforeTotalSpaces, (Object)newSpaces));
        if (added2) {
            ++this.myBlockRollbacks;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/AlignmentCyclesDetector", "registerOffsetResponsibleBlock"));
    }
}

