/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockAlignmentProcessor;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import org.jetbrains.annotations.NotNull;

public class RightEdgeAlignmentProcessor
extends AbstractBlockAlignmentProcessor {
    @Override
    protected IndentData calculateAlignmentAnchorIndent(@NotNull BlockAlignmentProcessor.Context context2) {
        LeafBlockWrapper offsetResponsibleBlock;
        if (context2 == null) {
            RightEdgeAlignmentProcessor.$$$reportNull$$$0(0);
        }
        if ((offsetResponsibleBlock = context2.alignment.getOffsetRespBlockBefore(context2.targetBlock)) == null) {
            return null;
        }
        WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return new IndentData(whiteSpace.getIndentSpaces() + offsetResponsibleBlock.getSymbolsAtTheLastLine(), whiteSpace.getSpaces());
        }
        int targetIndent = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock) + offsetResponsibleBlock.getSymbolsAtTheLastLine();
        AbstractBlockWrapper prevIndentedBlock = CoreFormatterUtil.getIndentedParentBlock(context2.targetBlock);
        if (prevIndentedBlock == null) {
            return new IndentData(0, targetIndent);
        }
        int parentIndent = prevIndentedBlock.getWhiteSpace().getIndentOffset();
        return new IndentData(parentIndent, targetIndent - parentIndent);
    }

    @Override
    protected boolean applyIndentToTheFirstBlockOnLine(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context2) {
        CompositeBlockWrapper parent;
        if (alignmentAnchorIndent == null) {
            RightEdgeAlignmentProcessor.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            RightEdgeAlignmentProcessor.$$$reportNull$$$0(2);
        }
        WhiteSpace whiteSpace = context2.targetBlock.getWhiteSpace();
        int indentSpaces = alignmentAnchorIndent.getIndentSpaces();
        int spaces = alignmentAnchorIndent.getSpaces() - context2.targetBlock.getSymbolsAtTheLastLine();
        if (spaces < 0) {
            indentSpaces += spaces;
            spaces = 0;
        }
        if (indentSpaces >= 0) {
            whiteSpace.setSpaces(spaces, indentSpaces);
            return true;
        }
        if (whiteSpace.getTotalSpaces() > 0 && (parent = context2.targetBlock.getParent()) != null) {
            IndentData childOffset = CoreFormatterUtil.getIndent(context2.indentOptions, context2.targetBlock, context2.targetBlock.getStartOffset());
            if (whiteSpace.getTotalSpaces() > childOffset.getTotalSpaces()) {
                int leftShift = whiteSpace.getTotalSpaces() - childOffset.getTotalSpaces();
                if (leftShift >= whiteSpace.getSpaces()) {
                    spaces = 0;
                    indentSpaces = whiteSpace.getIndentSpaces() - (leftShift - whiteSpace.getSpaces());
                } else {
                    spaces = whiteSpace.getSpaces() - leftShift;
                    indentSpaces = whiteSpace.getIndentSpaces();
                }
            }
            whiteSpace.setSpaces(spaces, indentSpaces);
        }
        return false;
    }

    @Override
    protected int getAlignmentIndentDiff(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context2) {
        if (alignmentAnchorIndent == null) {
            RightEdgeAlignmentProcessor.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            RightEdgeAlignmentProcessor.$$$reportNull$$$0(4);
        }
        IndentData indentBeforeBlock = context2.targetBlock.getNumberOfSymbolsBeforeBlock();
        int numberOfSymbolsBeforeBlock = indentBeforeBlock.getTotalSpaces() + context2.targetBlock.getSymbolsAtTheLastLine();
        return alignmentAnchorIndent.getTotalSpaces() - numberOfSymbolsBeforeBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentAnchorIndent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/RightEdgeAlignmentProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateAlignmentAnchorIndent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyIndentToTheFirstBlockOnLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignmentIndentDiff";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

