/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateLanguageFormattingModelBuilder
implements DelegatingFormattingModelBuilder,
TemplateLanguageBlockFactory {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            TemplateLanguageFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiFile file2 = formattingContext.getContainingFile();
        CodeStyleSettings settings2 = formattingContext.getCodeStyleSettings();
        Block rootBlock = this.getRootBlock((PsiElement)file2, file2.getViewProvider(), settings2);
        return new DocumentBasedFormattingModel(rootBlock, formattingContext.getProject(), settings2, file2.getFileType(), file2);
    }

    protected Block getRootBlock(PsiElement element2, FileViewProvider viewProvider, CodeStyleSettings settings2) {
        ASTNode node2 = element2.getNode();
        if (node2 == null) {
            return this.createDummyBlock(null);
        }
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            Language dataLanguage = ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
            FormattingModelBuilder builder2 = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(dataLanguage);
            if (builder2 instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)builder2).dontFormatMyModel(element2)) {
                return this.createDummyBlock(node2);
            }
            if (builder2 != null) {
                FormattingModel model2 = builder2.createModel(FormattingContext.create((PsiElement)viewProvider.getPsi(dataLanguage), (CodeStyleSettings)settings2));
                List<DataLanguageBlockWrapper> childWrappers = BlockUtil.buildChildWrappers(model2.getRootBlock());
                if (childWrappers.size() == 1) {
                    childWrappers = BlockUtil.buildChildWrappers(childWrappers.get(0).getOriginal());
                }
                return this.createTemplateLanguageBlock(node2, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, BlockUtil.filterBlocksByRange(childWrappers, node2.getTextRange()), settings2);
            }
        }
        return this.createTemplateLanguageBlock(node2, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), null, Collections.emptyList(), settings2);
    }

    protected AbstractBlock createDummyBlock(ASTNode node2) {
        return new AbstractBlock(node2, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), Alignment.createAlignment()){

            @Override
            protected List<Block> buildChildren() {
                return Collections.emptyList();
            }

            public Spacing getSpacing(Block child1, @NotNull Block child2) {
                if (child2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Spacing.getReadOnlySpacing();
            }

            public boolean isLeaf() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/formatting/templateLanguages/TemplateLanguageFormattingModelBuilder$1", "getSpacing"));
            }
        };
    }

    @Override
    public boolean dontFormatMyModel() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingContext", "com/intellij/formatting/templateLanguages/TemplateLanguageFormattingModelBuilder", "createModel"));
    }
}

