/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairFunction;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicrodataUtil {
    public static final Key<List<String>> ITEM_PROP_KEYS = Key.create((String)"microdata.prop");
    public static final String ITEM_REF = "itemref";
    public static final String ITEM_SCOPE = "itemscope";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_PROP = "itemprop";
    public static final String ITEM_ID = "itemid";

    public static boolean hasScopeTag(@Nullable XmlTag tag2) {
        return MicrodataUtil.findScopeTag(tag2) != null;
    }

    @Nullable
    public static XmlTag findScopeTag(@Nullable XmlTag context2) {
        Map<String, XmlTag> id2tag = MicrodataUtil.findScopesWithItemRef(context2 != null ? context2.getContainingFile() : null);
        for (XmlTag tag2 = context2; tag2 != null; tag2 = tag2.getParentTag()) {
            if (tag2 != context2 && tag2.getAttribute(ITEM_SCOPE) != null) {
                return tag2;
            }
            String id2 = MicrodataUtil.getStripedAttributeValue(tag2, "id");
            if (id2 == null || !id2tag.containsKey(id2)) continue;
            return id2tag.get(id2);
        }
        return null;
    }

    private static Map<String, XmlTag> findScopesWithItemRef(final @Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file2, (CachedValueProvider)new CachedValueProvider<Map<String, XmlTag>>(){

            @NotNull
            public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
                final HashMap result2 = new HashMap();
                file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag2) {
                        super.visitXmlTag(tag2);
                        XmlAttribute refAttr = tag2.getAttribute(MicrodataUtil.ITEM_REF);
                        if (refAttr != null && tag2.getAttribute(MicrodataUtil.ITEM_SCOPE) != null) {
                            MicrodataUtil.getReferencesForAttributeValue(refAttr.getValueElement(), (PairFunction<? super String, ? super Integer, ? extends PsiReference>)((PairFunction)(t, v) -> {
                                result2.put(t, tag2);
                                return null;
                            }));
                        }
                    }
                });
                CachedValueProvider.Result result3 = CachedValueProvider.Result.create(result2, (Object[])new Object[]{file2});
                if (result3 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/impl/util/MicrodataUtil$1", "compute"));
            }
        });
    }

    public static List<String> extractProperties(PsiFile file2, String type) {
        List<String> result2;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        List<String> list2 = result2 = virtualFile2 != null ? (List<String>)virtualFile2.getUserData(ITEM_PROP_KEYS) : null;
        if (virtualFile2 != null && result2 == null) {
            result2 = MicrodataUtil.collectNames(file2, type);
            virtualFile2.putUserData(ITEM_PROP_KEYS, result2);
        }
        return result2;
    }

    private static List<String> collectNames(PsiFile file2, String type) {
        if (file2 instanceof XmlFile) {
            CollectNamesVisitor collectNamesVisitor = MicrodataUtil.getVisitorByType(type);
            file2.accept((PsiElementVisitor)collectNamesVisitor);
            return collectNamesVisitor.getValues();
        }
        return Collections.emptyList();
    }

    private static CollectNamesVisitor getVisitorByType(String type) {
        if (type.contains("schema.org")) {
            return new CollectNamesFromSchemaOrgVisitor();
        }
        return new CollectNamesByMicrodataVisitor(type);
    }

    public static PsiReference[] getUrlReferencesForAttributeValue(XmlAttributeValue element2) {
        return MicrodataUtil.getReferencesForAttributeValue(element2, (PairFunction<? super String, ? super Integer, ? extends PsiReference>)((PairFunction)(token2, offset) -> {
            if (HtmlUtil.hasHtmlPrefix(token2)) {
                TextRange range2 = TextRange.from((int)offset, (int)token2.length());
                URLReference urlReference = new URLReference((PsiElement)element2, range2, true);
                return new DependentNSReference((PsiElement)element2, range2, urlReference, true);
            }
            return null;
        }));
    }

    public static PsiReference[] getReferencesForAttributeValue(@Nullable XmlAttributeValue element2, PairFunction<? super String, ? super Integer, ? extends PsiReference> refFun) {
        if (element2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text2 = element2.getText();
        String urls = StringUtil.unquoteString((String)text2);
        StringTokenizer tokenizer = new StringTokenizer(urls);
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        while (tokenizer.hasMoreTokens()) {
            int index2;
            String token2 = tokenizer.nextToken();
            PsiReference ref = (PsiReference)refFun.fun((Object)token2, (Object)(index2 = text2.indexOf(token2)));
            if (ref == null) continue;
            result2.add(ref);
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Nullable
    public static String getStripedAttributeValue(@Nullable XmlTag tag2, String attributeName) {
        String value2 = tag2 != null ? tag2.getAttributeValue(attributeName) : null;
        return value2 != null ? StringUtil.unquoteString((String)value2) : null;
    }

    public static class CollectNamesFromSchemaOrgVisitor
    extends CollectNamesVisitor {
        public void visitXmlTag(XmlTag tag2) {
            String code;
            super.visitXmlTag(tag2);
            if ("prop-nam".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag2, "class")) && (code = tag2.getSubTagText("code")) != null) {
                this.myValues.add(StringUtil.stripHtml((String)code, (boolean)false));
            }
        }
    }

    public static class CollectNamesByMicrodataVisitor
    extends CollectNamesVisitor {
        protected final String myType;
        private boolean myCollecting = false;

        public CollectNamesByMicrodataVisitor(String type) {
            this.myType = type;
        }

        public void visitXmlTag(XmlTag tag2) {
            String value2 = MicrodataUtil.getStripedAttributeValue(tag2, MicrodataUtil.ITEM_ID);
            boolean isTypeTag = this.myType.equalsIgnoreCase(value2);
            if (isTypeTag) {
                this.myCollecting = true;
            }
            if (this.myCollecting && "name".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag2, MicrodataUtil.ITEM_PROP))) {
                this.myValues.add(tag2.getValue().getTrimmedText());
            }
            super.visitXmlTag(tag2);
            if (isTypeTag) {
                this.myCollecting = false;
            }
        }
    }

    private static class CollectNamesVisitor
    extends XmlRecursiveElementVisitor {
        protected final Set<String> myValues = new HashSet<String>();

        private CollectNamesVisitor() {
        }

        public List<String> getValues() {
            return new ArrayList<String>(this.myValues);
        }
    }
}

