/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.SizedIcon;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActivateToolWindowAction
extends DumbAwareAction {
    private final String myToolWindowId;

    protected ActivateToolWindowAction(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(0);
        }
        this.myToolWindowId = toolWindowId;
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.myToolWindowId;
        if (string == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void ensureToolWindowActionRegistered(@NotNull ToolWindow toolWindow) {
        String actionId;
        ActionManager actionManager;
        AnAction action2;
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(2);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()))) == null) {
            ActivateToolWindowAction newAction = new ActivateToolWindowAction(toolWindow.getId());
            newAction.updatePresentation(newAction.getTemplatePresentation(), toolWindow);
            actionManager.registerAction(actionId, (AnAction)newAction);
        }
    }

    public static void unregister(@NotNull String id2) {
        if (id2 == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(3);
        }
        String actionId = ActivateToolWindowAction.getActionIdForToolWindow(id2);
        if (ActionManager.getInstance().getAction(actionId) != null) {
            ActionManager.getInstance().unregisterAction(actionId);
        }
    }

    public static void updateToolWindowActionPresentation(@NotNull ToolWindow toolWindow) {
        AnAction action2;
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(4);
        }
        if ((action2 = ActionManager.getInstance().getAction(ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()))) instanceof ActivateToolWindowAction) {
            ((ActivateToolWindowAction)action2).updatePresentation(action2.getTemplatePresentation(), toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(5);
        }
        Project project = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        Presentation presentation2 = e.getPresentation();
        if (project == null || project.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId);
        if (toolWindow == null) {
            presentation2.setEnabledAndVisible(this.hasEmptyState());
        } else {
            presentation2.setVisible(true);
            presentation2.setEnabled(toolWindow.isAvailable() || this.hasEmptyState());
            this.updatePresentation(presentation2, toolWindow);
        }
    }

    protected boolean hasEmptyState() {
        return false;
    }

    private void updatePresentation(@NotNull Presentation presentation2, @NotNull ToolWindow toolWindow) {
        if (presentation2 == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(6);
        }
        if (toolWindow == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(7);
        }
        String title2 = toolWindow.getStripeTitle();
        presentation2.setText(title2);
        presentation2.setDescription(IdeBundle.messagePointer((String)"action.activate.tool.window", (Object[])new Object[]{title2}));
        Icon icon2 = toolWindow.getIcon();
        if ("Event Log".equals(this.myToolWindowId)) {
            icon2 = AllIcons.Ide.Notification.InfoEvents;
        }
        presentation2.setIcon((Icon)(icon2 == null ? null : new SizedIcon(icon2, icon2.getIconHeight(), icon2.getIconHeight())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(8);
        }
        if ((project = ActivateToolWindowAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindowEventSource source = e.getInputEvent() instanceof KeyEvent ? ToolWindowEventSource.ActivateActionKeyboardShortcut : ("MainMenu".equals(e.getPlace()) ? ToolWindowEventSource.ActivateActionMenu : ("GoToAction".equals(e.getPlace()) ? ToolWindowEventSource.ActivateActionGotoAction : ToolWindowEventSource.ActivateActionOther));
        if (windowManager.isEditorComponentActive() || !this.myToolWindowId.equals(windowManager.getActiveToolWindowId())) {
            ToolWindow toolWindow = windowManager.getToolWindow(this.myToolWindowId);
            if (toolWindow != null) {
                if (this.hasEmptyState() && !toolWindow.isAvailable()) {
                    toolWindow.setAvailable(true);
                }
                if (windowManager instanceof ToolWindowManagerImpl) {
                    ((ToolWindowManagerImpl)windowManager).activateToolWindow(this.myToolWindowId, null, true, source);
                } else {
                    toolWindow.activate(null);
                }
            } else if (this.hasEmptyState()) {
                this.createEmptyState(project);
            }
        } else if (windowManager instanceof ToolWindowManagerImpl) {
            ((ToolWindowManagerImpl)windowManager).hideToolWindow(this.myToolWindowId, false, true, source);
        } else {
            ToolWindow toolWindow = windowManager.getToolWindow(this.myToolWindowId);
            if (toolWindow != null) {
                toolWindow.hide(null);
            }
        }
    }

    protected void createEmptyState(Project project) {
    }

    @NonNls
    @NotNull
    public static String getActionIdForToolWindow(@NotNull String id2) {
        if (id2 == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(9);
        }
        String string = "Activate" + id2.replaceAll(" ", "") + "ToolWindow";
        if (string == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static int getMnemonicForToolWindow(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ActivateToolWindowAction.$$$reportNull$$$0(11);
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Shortcut shortcut : activeKeymap.getShortcuts(ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId))) {
            int keyCode;
            KeyStroke keyStroke;
            int modifiers;
            if (!(shortcut instanceof KeyboardShortcut) || (modifiers = (keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke()).getModifiers()) != 520 && modifiers != 8 && modifiers != 512 && modifiers != 260 && modifiers != 4 && modifiers != 256 || 48 > (keyCode = keyStroke.getKeyCode()) || keyCode > 57) continue;
            return (char)(48 + keyCode - 48);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ActivateToolWindowAction";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ActivateToolWindowAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdForToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowActionRegistered";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowActionPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionIdForToolWindow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicForToolWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

