/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.actions.RecentLocationsRenderer;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecentLocationsAction
extends DumbAwareAction
implements LightEditCompatible {
    @NonNls
    public static final String RECENT_LOCATIONS_ACTION_ID = "RecentLocations";
    private static final String LOCATION_SETTINGS_KEY = "recent.locations.popup";
    private static final int DEFAULT_WIDTH = JBUIScale.scale((int)700);
    private static final int DEFAULT_HEIGHT = JBUIScale.scale((int)530);
    private static final int MINIMUM_WIDTH = JBUIScale.scale((int)600);
    private static final int MINIMUM_HEIGHT = JBUIScale.scale((int)450);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(0);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RECENT_LOCATIONS_ACTION_ID);
        Project project = RecentLocationsAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        RecentLocationsAction.showPopup(project, false);
    }

    public static void showPopup(@NotNull Project project, boolean showChanged) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(1);
        }
        RecentLocationsAction.showPopup(project, showChanged, IdeBundle.message((String)"recent.locations.popup.title", (Object[])new Object[0]), IdeBundle.message((String)"recent.locations.changed.locations", (Object[])new Object[0]), IdeBundle.message((String)"recent.locations.popup.empty.text", (Object[])new Object[0]), null, null);
    }

    public static void showPopup(final @NotNull Project project, boolean showChanged, @NotNull @NlsContexts.PopupTitle String title1, @NotNull @NlsContexts.PopupTitle String title2, @NotNull @NlsContexts.StatusText String emptyText, @Nullable Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> supplier2, @Nullable Consumer<List<IdeDocumentHistoryImpl.PlaceInfo>> remover) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(2);
        }
        if (title1 == null) {
            RecentLocationsAction.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(4);
        }
        if (emptyText == null) {
            RecentLocationsAction.$$$reportNull$$$0(5);
        }
        final RecentLocationsDataModel model2 = new RecentLocationsDataModel(project, supplier2, remover);
        final JBList list2 = new JBList((ListModel)JBList.createDefaultListModel(model2.getPlaces(showChanged)));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list2, (int)20, (int)31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        ShortcutSet showChangedOnlyShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)RECENT_LOCATIONS_ACTION_ID);
        final JBCheckBox checkBox2 = RecentLocationsAction.createCheckbox(showChangedOnlyShortcutSet, showChanged);
        RecentLocationsRenderer renderer2 = new RecentLocationsRenderer(project, model2, checkBox2);
        list2.setCellRenderer((ListCellRenderer)renderer2);
        list2.setEmptyText(emptyText);
        list2.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        if (list2.getModel().getSize() > 0) {
            list2.setSelectedIndex(0);
        }
        ScrollingUtil.installActions((JList)list2);
        SimpleColoredComponent title3 = new SimpleColoredComponent();
        title3.setOpaque(false);
        final Runnable titleUpdater = () -> {
            title3.clear();
            title3.append(checkBox2.isSelected() ? title2 : title1, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            title3.append("  (" + list2.getModel().getSize() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        };
        titleUpdater.run();
        JComponent listWithFilter = ListWithFilter.wrap((JList)list2, (JScrollPane)scrollPane, renderer2::getSpeedSearchText, (boolean)true);
        ((ListWithFilter)listWithFilter).setAutoPackHeight(false);
        listWithFilter.setBorder(BorderFactory.createEmptyBorder());
        JPanel topPanel = RecentLocationsAction.createHeaderPanel((JComponent)title3, (JComponent)checkBox2);
        JPanel mainPanel = RecentLocationsAction.createMainPanel(listWithFilter, topPanel);
        Color borderColor = SystemInfo.isMac && LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo ? topPanel.getBackground() : null;
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPanel, (JComponent)list2).setProject(project).setCancelOnClickOutside(true).setRequestFocus(true).setResizable(true).setMovable(true).setBorderColor(borderColor).setDimensionServiceKey(project, LOCATION_SETTINGS_KEY, true).setMinSize(new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT)).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)popup2, (Disposable)renderer2);
        LightEditActionFactory.create(event -> {
            checkBox2.setSelected(!checkBox2.isSelected());
            RecentLocationsAction.updateItems(model2, (JBList<RecentLocationItem>)list2, checkBox2, popup2);
            titleUpdater.run();
        }).registerCustomShortcutSet(showChangedOnlyShortcutSet, (JComponent)list2, (Disposable)popup2);
        checkBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentLocationsAction.updateItems(model2, (JBList<RecentLocationItem>)list2, checkBox2, popup2);
                titleUpdater.run();
            }
        });
        if (DimensionService.getInstance().getSize(LOCATION_SETTINGS_KEY, project) == null) {
            popup2.setSize(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT));
        }
        list2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    int i2 = list2.locationToIndex(event.getPoint());
                    if (i2 != -1) {
                        list2.setSelectedIndex(i2);
                        RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2);
                    }
                }
            }
        });
        list2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickCount = event.getClickCount();
                if (clickCount > 1 && clickCount % 2 == 0) {
                    event.consume();
                    RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2);
                }
            }
        });
        LightEditActionFactory.create(e -> RecentLocationsAction.navigateToSelected(project, (JBList<RecentLocationItem>)list2, popup2)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)list2, (Disposable)popup2);
        LightEditActionFactory.create(e -> {
            RecentLocationsAction.removeItems(project, (JBList<RecentLocationItem>)list2, model2, checkBox2.isSelected());
            titleUpdater.run();
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), (JComponent)list2, (Disposable)popup2);
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        list2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JCheckBox)) {
                    popup2.cancel();
                }
            }
        });
        RecentLocationsAction.showPopup(project, popup2);
    }

    private static void updateItems(@NotNull RecentLocationsDataModel data2, @NotNull JBList<RecentLocationItem> list2, @NotNull JBCheckBox checkBox2, @NotNull JBPopup popup2) {
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(7);
        }
        if (checkBox2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(8);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(9);
        }
        RecentLocationsAction.updateModel(list2, data2, checkBox2.isSelected());
        FocusManagerImpl.getInstance().requestFocus(list2, false);
        popup2.pack(false, false);
    }

    @NotNull
    private static JBCheckBox createCheckbox(@NotNull ShortcutSet checkboxShortcutSet, boolean showChanged) {
        if (checkboxShortcutSet == null) {
            RecentLocationsAction.$$$reportNull$$$0(10);
        }
        String text2 = "<html>" + IdeBundle.message((String)"recent.locations.title.text", (Object[])new Object[0]) + " <font color=\"" + Holder.SHORTCUT_HEX_COLOR + "\">" + KeymapUtil.getShortcutsText((Shortcut[])checkboxShortcutSet.getShortcuts()) + "</font></html>";
        JBCheckBox checkBox2 = new JBCheckBox(text2);
        checkBox2.setBorder((Border)JBUI.Borders.empty());
        checkBox2.setOpaque(false);
        checkBox2.setSelected(showChanged);
        JBCheckBox jBCheckBox = checkBox2;
        if (jBCheckBox == null) {
            RecentLocationsAction.$$$reportNull$$$0(11);
        }
        return jBCheckBox;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RecentLocationsAction.$$$reportNull$$$0(12);
        }
        e.getPresentation().setEnabled(RecentLocationsAction.getEventProject((AnActionEvent)e) != null);
    }

    private static void showPopup(@NotNull Project project, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(13);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(14);
        }
        Point savedLocation = DimensionService.getInstance().getLocation(LOCATION_SETTINGS_KEY, project);
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (savedLocation != null && recentFocusedWindow != null) {
            popup2.showInScreenCoordinates((Component)recentFocusedWindow, savedLocation);
        } else {
            popup2.showCenteredInCurrentWindow(project);
        }
    }

    private static void updateModel(@NotNull JBList<RecentLocationItem> list2, @NotNull RecentLocationsDataModel data2, boolean changed2) {
        SpeedSearchSupply speedSearch2;
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(15);
        }
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(16);
        }
        NameFilteringListModel model2 = (NameFilteringListModel)list2.getModel();
        DefaultListModel originalModel = (DefaultListModel)model2.getOriginalModel();
        originalModel.removeAllElements();
        originalModel.addAll(data2.getPlaces(changed2));
        if (list2.getModel().getSize() > 0) {
            list2.setSelectedIndex(0);
        }
        if ((speedSearch2 = SpeedSearchSupply.getSupply(list2)) instanceof SpeedSearch) {
            ((SpeedSearch)speedSearch2).reset();
        }
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull JComponent listPanel, @NotNull JPanel topPanel) {
        if (listPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(17);
        }
        if (topPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(18);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)listPanel, "Center");
        JPanel jPanel2 = mainPanel;
        if (jPanel2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(19);
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel createHeaderPanel(@NotNull JComponent title2, @NotNull JComponent checkbox) {
        if (title2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(20);
        }
        if (checkbox == null) {
            RecentLocationsAction.$$$reportNull$$$0(21);
        }
        CaptionPanel topPanel = new CaptionPanel();
        topPanel.add((Component)title2, "West");
        topPanel.add((Component)checkbox, "East");
        Dimension size2 = topPanel.getPreferredSize();
        size2.height = JBUIScale.scale((int)29);
        topPanel.setPreferredSize(size2);
        topPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        WindowMoveListener moveListener2 = new WindowMoveListener((Component)topPanel);
        topPanel.addMouseListener(moveListener2);
        topPanel.addMouseMotionListener(moveListener2);
        CaptionPanel captionPanel = topPanel;
        if (captionPanel == null) {
            RecentLocationsAction.$$$reportNull$$$0(22);
        }
        return captionPanel;
    }

    private static void removeItems(@NotNull Project project, @NotNull JBList<RecentLocationItem> list2, @NotNull RecentLocationsDataModel data2, boolean showChanged) {
        List selectedValue;
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(23);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(24);
        }
        if (data2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(25);
        }
        if ((selectedValue = list2.getSelectedValuesList()).isEmpty()) {
            return;
        }
        int index2 = list2.getSelectedIndex();
        data2.removeItems(project, showChanged, selectedValue);
        RecentLocationsAction.updateModel(list2, data2, showChanged);
        if (list2.getModel().getSize() > 0) {
            ScrollingUtil.selectItem(list2, (int)(index2 < list2.getModel().getSize() ? index2 : index2 - 1));
        }
    }

    private static void navigateToSelected(@NotNull Project project, @NotNull JBList<RecentLocationItem> list2, @NotNull JBPopup popup2) {
        if (project == null) {
            RecentLocationsAction.$$$reportNull$$$0(26);
        }
        if (list2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(27);
        }
        if (popup2 == null) {
            RecentLocationsAction.$$$reportNull$$$0(28);
        }
        ContainerUtil.reverse((List)list2.getSelectedValuesList()).forEach(item -> IdeDocumentHistory.getInstance(project).gotoPlaceInfo(item.info, true));
        popup2.closeOk(null);
    }

    static String getEmptyFileText() {
        return IdeBundle.message((String)"recent.locations.popup.empty.file.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 6: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: 
            case 15: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 9: 
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxShortcutSet";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPanel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topPanel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkbox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RecentLocationsAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckbox";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPanel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCheckbox";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderPanel";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeItems";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Holder {
        private static final Color SHORTCUT_FOREGROUND_COLOR = UIUtil.getContextHelpForeground();
        public static final String SHORTCUT_HEX_COLOR = String.format("#%02x%02x%02x", SHORTCUT_FOREGROUND_COLOR.getRed(), SHORTCUT_FOREGROUND_COLOR.getGreen(), SHORTCUT_FOREGROUND_COLOR.getBlue());

        Holder() {
        }
    }
}

