/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.AgreementUi;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AppUIUtil;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"applyDataSharing", "Lcom/intellij/ide/gdpr/AgreementUi;", "ui", "bundle", "Ljava/util/ResourceBundle;", "applyUserAgreement", "agreement", "Lcom/intellij/ide/gdpr/EndUserAgreement$Document;", "prepareConsentsHtmlText", "", "consent", "Lcom/intellij/ide/gdpr/Consent;", "showDataSharingAgreement", "", "showEndUserAndDataSharingAgreements", "intellij.platform.ide.impl"})
@JvmName(name="Agreements")
public final class Agreements {
    public static final void showEndUserAndDataSharingAgreements(@NotNull EndUserAgreement.Document agreement) {
        Intrinsics.checkNotNullParameter((Object)agreement, (String)"agreement");
        String string = agreement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"agreement.text");
        AgreementUi ui2 = AgreementUi.Companion.create$default(AgreementUi.Companion, string, false, false, 6, null);
        Agreements.applyUserAgreement(ui2, agreement).pack().show();
    }

    public static final void showDataSharingAgreement() {
        AgreementUi ui2 = AgreementUi.Companion.create$default(AgreementUi.Companion, null, false, false, 7, null);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("messages.AgreementsBundle");
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"ResourceBundle.getBundle\u2026ssages.AgreementsBundle\")");
        Agreements.applyDataSharing(ui2, resourceBundle).pack().show();
    }

    private static final AgreementUi applyUserAgreement(AgreementUi ui2, EndUserAgreement.Document agreement) {
        String string;
        boolean isPrivacyPolicy = agreement.isPrivacyPolicy();
        ResourceBundle bundle = ResourceBundle.getBundle("messages.AgreementsBundle");
        if (isPrivacyPolicy) {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            string = stringBuilder.append(applicationInfoEx.getShortCompanyName()).append(" ").append(bundle.getString("userAgreement.dialog.privacyPolicy.title")).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            string = stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" ").append(bundle.getString("userAgreement.dialog.userAgreement.title")).toString();
        }
        AgreementUi agreementUi = ui2.setTitle(string);
        String string2 = bundle.getString("userAgreement.dialog.exit");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.getString(\"userAgreement.dialog.exit\")");
        AgreementUi agreementUi2 = agreementUi.setDeclineButton(string2, (Function1<? super DialogWrapper, Unit>)((Function1)applyUserAgreement.commonUserAgreement.1.INSTANCE));
        String string3 = bundle.getString("userAgreement.dialog.checkBox");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bundle.getString(\"userAgreement.dialog.checkBox\")");
        AgreementUi commonUserAgreement2 = agreementUi2.addCheckBox(string3, (Function1<? super JCheckBox, Unit>)((Function1)new Function1<JCheckBox, Unit>(ui2){
            final /* synthetic */ AgreementUi $ui;

            public final void invoke(@NotNull JCheckBox checkBox2) {
                Intrinsics.checkNotNullParameter((Object)checkBox2, (String)"checkBox");
                this.$ui.enableAcceptButton(checkBox2.isSelected());
                if (checkBox2.isSelected()) {
                    this.$ui.focusToAcceptButton();
                }
            }
            {
                this.$ui = agreementUi;
                super(1);
            }
        }));
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        if (applicationInfoEx.isEAP()) {
            String string4 = bundle.getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"bundle.getString(\"userAgreement.dialog.continue\")");
            commonUserAgreement2.setAcceptButton(string4, false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(agreement){
                final /* synthetic */ EndUserAgreement.Document $agreement;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    Intrinsics.checkNotNullParameter((Object)dialogWrapper2, (String)"dialogWrapper");
                    EndUserAgreement.setAccepted(this.$agreement);
                    dialogWrapper2.close(0);
                }
                {
                    this.$agreement = document;
                    super(1);
                }
            })).addEapPanel(isPrivacyPolicy);
        } else {
            String string5 = bundle.getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"bundle.getString(\"userAgreement.dialog.continue\")");
            commonUserAgreement2.setAcceptButton(string5, false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(agreement, ui2, bundle){
                final /* synthetic */ EndUserAgreement.Document $agreement;
                final /* synthetic */ AgreementUi $ui;
                final /* synthetic */ ResourceBundle $bundle;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    Intrinsics.checkNotNullParameter((Object)dialogWrapper2, (String)"dialogWrapper");
                    EndUserAgreement.setAccepted(this.$agreement);
                    if (AppUIUtil.needToShowUsageStatsConsent()) {
                        ResourceBundle resourceBundle = this.$bundle;
                        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"bundle");
                        Agreements.access$applyDataSharing(this.$ui, resourceBundle);
                    } else {
                        dialogWrapper2.close(0);
                    }
                }
                {
                    this.$agreement = document;
                    this.$ui = agreementUi;
                    this.$bundle = resourceBundle;
                    super(1);
                }
            }));
        }
        return ui2;
    }

    private static final AgreementUi applyDataSharing(AgreementUi ui2, ResourceBundle bundle) {
        Consent dataSharingConsent;
        Consent consent = dataSharingConsent = (Consent)((List)ConsentOptions.getInstance().getConsents(ConsentOptions.condUsageStatsConsent()).first).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)consent, (String)"dataSharingConsent");
        AgreementUi agreementUi = ui2.setText(Agreements.prepareConsentsHtmlText(consent, bundle));
        String string = bundle.getString("dataSharing.dialog.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.getString(\"dataSharing.dialog.title\")");
        AgreementUi agreementUi2 = agreementUi.setTitle(string).clearBottomPanel().focusToText();
        String string2 = bundle.getString("dataSharing.dialog.accept");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.getString(\"dataSharing.dialog.accept\")");
        AgreementUi agreementUi3 = AgreementUi.setAcceptButton$default(agreementUi2, string2, false, (Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)this.$dataSharingConsent.derive(true)));
                it.close(0);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }, 2, null);
        String string3 = bundle.getString("dataSharing.dialog.decline");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bundle.getString(\"dataSharing.dialog.decline\")");
        agreementUi3.setDeclineButton(string3, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)this.$dataSharingConsent.derive(false)));
                it.close(1);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }));
        return ui2;
    }

    private static final String prepareConsentsHtmlText(Consent consent, ResourceBundle bundle) {
        String string;
        ConsentOptions consentOptions = ConsentOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)consentOptions, (String)"ConsentOptions.getInstance()");
        if (!consentOptions.isEAP()) {
            String string2 = "<p><hint>" + bundle.getString("dataSharing.applyToAll.hint") + "</hint></p>";
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            String string3 = applicationInfoEx.getShortCompanyName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ApplicationInfoImpl.getS\u2026stance().shortCompanyName");
            string = StringsKt.replace$default((String)string2, (String)"{0}", (String)string3, (boolean)false, (int)4, null);
        } else {
            string = "";
        }
        String allProductHint = string;
        StringBuilder stringBuilder = new StringBuilder().append("<p><hint>");
        String string4 = bundle.getString("dataSharing.revoke.hint");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"bundle.getString(\"dataSharing.revoke.hint\")");
        String string5 = ShowSettingsUtil.getSettingsMenuName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ShowSettingsUtil.getSettingsMenuName()");
        String preferencesHint = stringBuilder.append(StringsKt.replace$default((String)string4, (String)"{0}", (String)string5, (boolean)false, (int)4, null)).append("</hint></p>").toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("<html><body> <h1>").append(bundle.getString("dataSharing.consents.title")).append("</h1>").append("<p>");
        String string6 = consent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"consent.text");
        return stringBuilder2.append(StringsKt.replace$default((String)string6, (String)"\n", (String)"</p><p>", (boolean)false, (int)4, null)).append("</p>").append(allProductHint).append(preferencesHint).append("</body></html>").toString();
    }

    public static final /* synthetic */ AgreementUi access$applyDataSharing(AgreementUi ui2, ResourceBundle bundle) {
        return Agreements.applyDataSharing(ui2, bundle);
    }
}

