/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class NoContentRootProjectConfigurator
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        VirtualFile projectsRoot;
        if (project == null) {
            NoContentRootProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            NoContentRootProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            NoContentRootProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((projectsRoot = LocalFileSystem.getInstance().findFileByPath(ProjectUtil.getProjectsPath())) == null || !VfsUtilCore.isAncestor((VirtualFile)projectsRoot, (VirtualFile)baseDir, (boolean)true)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                for (ContentEntry entry2 : rootModel.getContentEntries()) {
                    VirtualFile entryFile = entry2.getFile();
                    if (entryFile == null || !VfsUtilCore.isAncestor((VirtualFile)projectsRoot, (VirtualFile)entryFile, (boolean)true)) continue;
                    rootModel.removeContentEntry(entry2);
                }
                rootModel.inheritSdk();
                rootModel.commit();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleRef";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/impl/NoContentRootProjectConfigurator";
        objectArray[2] = "configureProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

