/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.actions.LightEditOpenFileInProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBPoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditModeNotificationWidget
implements CustomStatusBarWidget {
    private final PopupState<JPopupMenu> myPopupState = PopupState.forPopupMenu();

    @NonNls
    @NotNull
    public String ID() {
        return "light.edit.mode.notification";
    }

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(0);
        }
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine().setDefaultFill(3).setDefaultWeightY(1.0);
        JBLabel label2 = new JBLabel(ApplicationBundle.message((String)"light.edit.status.bar.notification.label.text", (Object[])new Object[0]));
        panel2.add((Component)label2, gc.next().insets((Insets)JBUI.insets((int)0, (int)7, (int)0, (int)5)));
        ActionLink actionLink2 = this.createActionLink();
        panel2.add((Component)actionLink2, gc.next());
        panel2.setOpaque(false);
        this.configureTooltip(label2, actionLink2);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme2 -> this.configureTooltip(label2, actionLink2));
        return panel2;
    }

    private void configureTooltip(@NotNull JBLabel label2, @NotNull ActionLink actionLink2) {
        if (label2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(1);
        }
        if (actionLink2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(2);
        }
        IdeTooltip tooltip2 = this.createTooltip((JComponent)actionLink2);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)label2, tooltip2);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)actionLink2, tooltip2);
    }

    @NotNull
    private ActionLink createActionLink() {
        final ActionLink actionLink2 = new ActionLink();
        actionLink2.setText(ApplicationBundle.message((String)"light.edit.status.bar.notification.link.text", (Object[])new Object[0]));
        actionLink2.setDropDownLinkIcon();
        actionLink2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightEditModeNotificationWidget.this.showPopupMenu((JComponent)actionLink2);
            }
        });
        ActionLink actionLink3 = actionLink2;
        if (actionLink3 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(3);
        }
        return actionLink3;
    }

    @NotNull
    private IdeTooltip createTooltip(@NotNull JComponent component2) {
        if (component2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(4);
        }
        TooltipWithClickableLinks tooltip2 = new TooltipWithClickableLinks(component2, LightEditModeNotificationWidget.getTooltipHtml(), (HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                HelpManager.getInstance().invokeHelp("LightEdit_Mode");
            }
        }){

            @Override
            public boolean canBeDismissedOnTimeout() {
                return false;
            }

            @Override
            protected boolean beforeShow() {
                return !LightEditModeNotificationWidget.this.myPopupState.isShowing();
            }
        };
        tooltip2.setToCenter(false);
        tooltip2.setToCenterIfSmall(false);
        tooltip2.setPoint((Point)new JBPoint(-3, 11));
        TooltipWithClickableLinks tooltipWithClickableLinks = tooltip2;
        if (tooltipWithClickableLinks == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(5);
        }
        return tooltipWithClickableLinks;
    }

    @NotNull
    @Nls
    private static String getTooltipHtml() {
        HtmlChunk.Element link2 = HtmlChunk.link((String)"", (String)ApplicationBundle.message((String)"light.edit.status.bar.notification.tooltip.link.text", (Object[])new Object[0]));
        link2 = link2.child((HtmlChunk)HtmlChunk.tag((String)"icon").attr("src", "AllIcons.Ide.External_link_arrow"));
        @NlsSafe String pTag = "<p>";
        Object tooltipText = ApplicationBundle.message((String)"light.edit.status.bar.notification.tooltip", (Object[])new Object[0]) + pTag + link2.toString();
        Object object = tooltipText = ((String)tooltipText).replace(pTag, HtmlChunk.tag((String)"p").style("padding: " + JBUI.scale((int)3) + "px 0 0 0").toString());
        if (object == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(6);
        }
        return object;
    }

    private void showPopupMenu(@NotNull JComponent actionLink2) {
        if (actionLink2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(7);
        }
        if (!this.myPopupState.isRecentlyHidden()) {
            DataManager.registerDataProvider((JComponent)actionLink2, dataId -> {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    return LightEditService.getInstance().getSelectedFile();
                }
                return null;
            });
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("StatusBarPlace", LightEditModeNotificationWidget.createAccessFullIdeActionGroup());
            popupMenu.setTargetComponent(actionLink2);
            JPopupMenu menu = popupMenu.getComponent();
            this.myPopupState.prepareToShow((Object)menu);
            JBPopupMenu.showAbove((Component)actionLink2, (JPopupMenu)menu);
        }
    }

    @NotNull
    private static ActionGroup createAccessFullIdeActionGroup() {
        ActionManager actionManager = ActionManager.getInstance();
        return new DefaultActionGroup(new AnAction[]{new LightEditDelegatingAction((AnAction)new LightEditOpenFileInProjectAction(), ApplicationBundle.messagePointer((String)"light.edit.open_current_file_in_project.text", (Object[])new Object[0])), new Separator(), new LightEditDelegatingAction(actionManager.getAction("ManageRecentProjects"), ApplicationBundle.messagePointer((String)"light.edit.open_recent_project.text", (Object[])new Object[0])), new LightEditDelegatingAction(actionManager.getAction("NewProject"), ApplicationBundle.messagePointer((String)"light.edit.create_new_project.text", (Object[])new Object[0]))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionLink";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureTooltip";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LightEditDelegatingAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final AnAction myDelegate;

        private LightEditDelegatingAction(@Nullable AnAction delegate2, @NotNull Supplier<@Nls String> textSupplier) {
            if (textSupplier == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(0);
            }
            super(textSupplier);
            this.myDelegate = delegate2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(1);
            }
            if (this.myDelegate == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            this.myDelegate.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(2);
            }
            if (this.myDelegate != null) {
                this.myDelegate.actionPerformed(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textSupplier";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget$LightEditDelegatingAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

