/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.NioFiles;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DisabledPluginsState {
    @NonNls
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    @Nullable
    private static volatile Set<PluginId> ourDisabledPlugins;
    private static final List<Runnable> ourDisabledPluginListeners;
    private static volatile boolean ourIgnoreDisabledPlugins;

    private DisabledPluginsState() {
    }

    @ApiStatus.Internal
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(0);
        }
        ourDisabledPluginListeners.add(listener2);
    }

    @ApiStatus.Internal
    public static void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(1);
        }
        ourDisabledPluginListeners.remove(listener2);
    }

    @ApiStatus.Internal
    public static void setIgnoreDisabledPlugins(boolean ignoreDisabledPlugins) {
        ourIgnoreDisabledPlugins = ignoreDisabledPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static Set<PluginId> loadDisabledPlugins() {
        LinkedHashSet<PluginId> disabledPlugins = new LinkedHashSet<PluginId>();
        Path file2 = Paths.get(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        if (!Files.isRegularFile(file2, new LinkOption[0])) {
            LinkedHashSet<PluginId> linkedHashSet = disabledPlugins;
            if (linkedHashSet == null) {
                DisabledPluginsState.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }
        ApplicationInfoEx applicationInfo = ApplicationInfoImpl.getShadowInstance();
        List<String> requiredPlugins = DisabledPluginsState.splitByComma("idea.required.plugins.id");
        boolean updateDisablePluginsList = false;
        try (BufferedReader reader = Files.newBufferedReader(file2);){
            String id2;
            while ((id2 = reader.readLine()) != null) {
                if ((id2 = id2.trim()).isEmpty()) continue;
                if (!requiredPlugins.contains(id2) && !applicationInfo.isEssentialPlugin(id2)) {
                    DisabledPluginsState.addIdTo(id2, disabledPlugins);
                    continue;
                }
                updateDisablePluginsList = true;
            }
            for (String suppressedId : DisabledPluginsState.getNonEssentialSuppressedPlugins(applicationInfo)) {
                if (!DisabledPluginsState.addIdTo(suppressedId, disabledPlugins)) continue;
                updateDisablePluginsList = true;
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, (Throwable)e);
        }
        finally {
            if (updateDisablePluginsList) {
                DisabledPluginsState.trySaveDisabledPlugins(file2, disabledPlugins, false);
            }
        }
        LinkedHashSet<PluginId> linkedHashSet = disabledPlugins;
        if (linkedHashSet == null) {
            DisabledPluginsState.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set2 = Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
        if (set2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(4);
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set2 = result2;
            if (set2 == null) {
                DisabledPluginsState.$$$reportNull$$$0(5);
            }
            return set2;
        }
        if (ourIgnoreDisabledPlugins || System.getProperty("idea.ignore.disabled.plugins") != null) {
            return new HashSet<PluginId>();
        }
        Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
        synchronized (DisabledPluginsState.class) {
            result2 = ourDisabledPlugins;
            if (result2 == null) {
                ourDisabledPlugins = result2 = DisabledPluginsState.loadDisabledPlugins();
            }
            Set<PluginId> set3 = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (set3 == null) {
                DisabledPluginsState.$$$reportNull$$$0(6);
            }
            return set3;
        }
    }

    @ApiStatus.Internal
    static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            DisabledPluginsState.$$$reportNull$$$0(7);
        }
        return DisabledPluginsState.getDisabledIds().contains(pluginId);
    }

    @ApiStatus.Internal
    static boolean setEnabledState(@NotNull Set<PluginId> plugins2, boolean enabled) {
        if (plugins2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(8);
        }
        Set<PluginId> disabled = DisabledPluginsState.getDisabledIds();
        boolean changed2 = enabled ? disabled.removeAll(plugins2) : disabled.addAll(plugins2);
        DisabledPluginsState.getLogger().info(DisabledPluginsState.joinedPluginIds(plugins2, enabled));
        return changed2 && DisabledPluginsState.trySaveDisabledPlugins(disabled);
    }

    @ApiStatus.Internal
    public static boolean trySaveDisabledPlugins(@NotNull Collection<PluginId> pluginIds2) {
        if (pluginIds2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(9);
        }
        return DisabledPluginsState.trySaveDisabledPlugins(PathManager.getConfigDir().resolve(DISABLED_PLUGINS_FILENAME), pluginIds2, true);
    }

    private static boolean trySaveDisabledPlugins(@NotNull Path file2, @NotNull Collection<PluginId> pluginIds2, boolean invalidate) {
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(10);
        }
        if (pluginIds2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(11);
        }
        try {
            DisabledPluginsState.saveDisabledPlugins(file2, pluginIds2, invalidate);
            return true;
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().warn("Unable to save disabled plugins list", (Throwable)e);
            return false;
        }
    }

    @TestOnly
    public static void saveDisabledPlugins(@NotNull Path configDir, String ... ids) throws IOException {
        if (configDir == null) {
            DisabledPluginsState.$$$reportNull$$$0(12);
        }
        ArrayList<PluginId> pluginIds2 = new ArrayList<PluginId>();
        for (String id2 : ids) {
            DisabledPluginsState.addIdTo(id2, pluginIds2);
        }
        DisabledPluginsState.saveDisabledPlugins(configDir.resolve(DISABLED_PLUGINS_FILENAME), pluginIds2, true);
    }

    private static void saveDisabledPlugins(@NotNull Path file2, @NotNull Collection<PluginId> pluginIds2, boolean invalidate) throws IOException {
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(13);
        }
        if (pluginIds2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(14);
        }
        DisabledPluginsState.savePluginsList(pluginIds2, file2);
        if (invalidate) {
            DisabledPluginsState.invalidate();
        }
        for (Runnable listener2 : ourDisabledPluginListeners) {
            listener2.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2) throws IOException {
        if (ids == null) {
            DisabledPluginsState.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(16);
        }
        NioFiles.createDirectories((Path)file2.getParent());
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.DisabledPluginsState");
        if (logger == null) {
            DisabledPluginsState.$$$reportNull$$$0(17);
        }
        return logger;
    }

    static void invalidate() {
        ourDisabledPlugins = null;
    }

    private static boolean addIdTo(@NotNull String id2, @NotNull Collection<PluginId> pluginIds2) {
        if (id2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(18);
        }
        if (pluginIds2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(19);
        }
        return pluginIds2.add(PluginId.getId((String)id2));
    }

    @NotNull
    private static List<String> getNonEssentialSuppressedPlugins(@NotNull ApplicationInfoEx applicationInfo) {
        List<String> suppressedPlugins;
        if (applicationInfo == null) {
            DisabledPluginsState.$$$reportNull$$$0(20);
        }
        if ((suppressedPlugins = DisabledPluginsState.splitByComma("idea.suppressed.plugins.id")).isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                DisabledPluginsState.$$$reportNull$$$0(21);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(suppressedPlugins.size());
        for (String suppressedPlugin : suppressedPlugins) {
            if (applicationInfo.isEssentialPlugin(suppressedPlugin)) continue;
            result2.add(suppressedPlugin);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DisabledPluginsState.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> splitByComma(@NotNull String key) {
        String[] strings;
        if (key == null) {
            DisabledPluginsState.$$$reportNull$$$0(23);
        }
        List<String> list2 = (strings = System.getProperty(key, "").split(",")).length == 0 || strings.length == 1 && strings[0].isEmpty() ? Collections.emptyList() : Arrays.asList(strings);
        if (list2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @NotNull
    private static String joinedPluginIds(@NotNull Collection<PluginId> pluginIds2, boolean enabled) {
        if (pluginIds2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(25);
        }
        StringBuilder buffer = new StringBuilder("Plugins to ").append(enabled ? "enable" : "disable").append(": [");
        Iterator<PluginId> iterator2 = pluginIds2.iterator();
        while (iterator2.hasNext()) {
            buffer.append(iterator2.next().getIdString());
            if (!iterator2.hasNext()) continue;
            buffer.append(", ");
        }
        String string = buffer.append(']').toString();
        if (string == null) {
            DisabledPluginsState.$$$reportNull$$$0(26);
        }
        return string;
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList<Runnable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationInfo";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDisabledPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEssentialSuppressedPlugins";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByComma";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "joinedPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledState";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addIdTo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNonEssentialSuppressedPlugins";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "splitByComma";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "joinedPluginIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

