/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RepositoryContentHandler
extends DefaultHandler {
    @NonNls
    private static final String CATEGORY = "category";
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String IDEA_PLUGIN = "idea-plugin";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String VENDOR = "vendor";
    @NonNls
    private static final String EMAIL = "email";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String IDEA_VERSION = "idea-version";
    @NonNls
    private static final String SINCE_BUILD = "since-build";
    @NonNls
    private static final String UNTIL_BUILD = "until-build";
    @NonNls
    private static final String CHANGE_NOTES = "change-notes";
    @NonNls
    private static final String DEPENDS = "depends";
    @NonNls
    private static final String DOWNLOADS = "downloads";
    @NonNls
    private static final String DOWNLOAD_URL = "downloadUrl";
    @NonNls
    private static final String DOWNLOAD_URL_NEW_STYLE = "download-url";
    @NonNls
    private static final String SIZE = "size";
    @NonNls
    private static final String RATING = "rating";
    @NonNls
    private static final String DATE = "date";
    @NonNls
    private static final String PLUGIN_UPDATED_DATE = "updatedDate";
    @NonNls
    private static final String TAGS = "tags";
    @NonNls
    private static final String PRODUCT_CODE = "productCode";
    private final StringBuilder currentValue = new StringBuilder();
    private PluginNode currentPlugin;
    private List<PluginNode> plugins;
    private Stack<String> categories;
    private String categoryName;

    RepositoryContentHandler() {
    }

    @NotNull
    List<PluginNode> getPluginsList() {
        List<PluginNode> list2 = this.plugins != null ? this.plugins : Collections.emptyList();
        if (list2 == null) {
            RepositoryContentHandler.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public void startDocument() {
        this.plugins = new ArrayList<PluginNode>();
        this.categories = new Stack();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes2) throws SAXException {
        if (qName.equals(CATEGORY)) {
            String category = attributes2.getValue(NAME);
            if (!StringUtil.isEmptyOrSpaces((String)category)) {
                this.categories.push((Object)category);
                this.categoryName = null;
            }
        } else if (qName.equals(IDEA_PLUGIN)) {
            String dateString;
            this.currentPlugin = new PluginNode(PluginId.getId((String)"unknown"));
            this.currentPlugin.setCategory(this.buildCategoryName());
            this.currentPlugin.setDownloads(attributes2.getValue(DOWNLOADS));
            this.currentPlugin.setSize(attributes2.getValue(SIZE));
            this.currentPlugin.setUrl(attributes2.getValue(URL));
            String string = dateString = attributes2.getValue(PLUGIN_UPDATED_DATE) != null ? attributes2.getValue(PLUGIN_UPDATED_DATE) : attributes2.getValue(DATE);
            if (dateString != null) {
                this.currentPlugin.setDate(dateString);
            }
            this.currentPlugin.setIncomplete(false);
        } else if (qName.equals(IDEA_VERSION)) {
            this.currentPlugin.setSinceBuild(attributes2.getValue(SINCE_BUILD));
            this.currentPlugin.setUntilBuild(PluginManager.convertExplicitBigNumberInUntilBuildToStar(attributes2.getValue(UNTIL_BUILD)));
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendorEmail(attributes2.getValue(EMAIL));
            this.currentPlugin.setVendorUrl(attributes2.getValue(URL));
        } else if (qName.equals(PLUGIN)) {
            String id2 = attributes2.getValue(ID);
            this.currentPlugin = id2 == null ? new PluginNode(PluginId.getId((String)"unknown")) : new PluginNode(PluginId.getId((String)id2));
            this.currentPlugin.setDownloadUrl(attributes2.getValue(URL));
            this.currentPlugin.setVersion(attributes2.getValue(VERSION));
            this.currentPlugin.setIncomplete(true);
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        String currentValueString = this.currentValue.toString();
        this.currentValue.setLength(0);
        if (qName.equals(ID)) {
            this.currentPlugin.setId(currentValueString);
        } else if (qName.equals(NAME)) {
            this.currentPlugin.setName(currentValueString);
        } else if (qName.equals(DESCRIPTION)) {
            this.currentPlugin.setDescription(currentValueString);
        } else if (qName.equals(VERSION)) {
            this.currentPlugin.setVersion(currentValueString);
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendor(currentValueString);
        } else if (qName.equals(DEPENDS)) {
            this.currentPlugin.addDepends(currentValueString, false);
        } else if (qName.equals(CHANGE_NOTES)) {
            this.currentPlugin.setChangeNotes(currentValueString);
        } else if (qName.equals(CATEGORY)) {
            this.categories.pop();
            this.categoryName = null;
        } else if (qName.equals(RATING)) {
            this.currentPlugin.setRating(currentValueString);
        } else if (qName.equals(DOWNLOAD_URL) || qName.equals(DOWNLOAD_URL_NEW_STYLE)) {
            this.currentPlugin.setDownloadUrl(currentValueString);
        } else if (qName.equals(IDEA_PLUGIN) || qName.equals(PLUGIN)) {
            if (this.currentPlugin != null) {
                this.plugins.add(this.currentPlugin);
            }
            this.currentPlugin = null;
        } else if (qName.equals(TAGS)) {
            this.currentPlugin.addTags(currentValueString);
        } else if (qName.equals(PRODUCT_CODE)) {
            this.currentPlugin.setProductCode(currentValueString);
        }
    }

    @Override
    public void characters(char[] ch, int start2, int length) {
        this.currentValue.append(ch, start2, length);
    }

    @NotNull
    private String buildCategoryName() {
        if (this.categoryName == null) {
            this.categoryName = String.join((CharSequence)"/", this.categories);
        }
        String string = this.categoryName;
        if (string == null) {
            RepositoryContentHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/marketplace/RepositoryContentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCategoryName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

