/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaselinePanel
extends NonOpaquePanel {
    private Component myBaseComponent;
    private final List<Component> myButtonComponents = new ArrayList<Component>();
    private boolean[] myButtonEnableStates;
    private Component myProgressComponent;
    private int myYOffset;
    private final JBValue myOffset = new JBValue.Float(8.0f);
    private final JBValue myBeforeButtonOffset = new JBValue.Float(40.0f);
    private final JBValue myButtonOffset = new JBValue.Float(6.0f);
    private EventHandler myEventHandler;

    public BaselinePanel() {
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)6, (int)0));
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int width = baseSize.width;
                if (BaselinePanel.this.myProgressComponent == null) {
                    int size2 = BaselinePanel.this.myButtonComponents.size();
                    if (size2 > 0) {
                        int visibleCount = 0;
                        for (Component component2 : BaselinePanel.this.myButtonComponents) {
                            if (!component2.isVisible()) continue;
                            width += component2.getPreferredSize().width;
                            ++visibleCount;
                        }
                        if (visibleCount > 0) {
                            width += BaselinePanel.this.myBeforeButtonOffset.get();
                            width += (visibleCount - 1) * BaselinePanel.this.myButtonOffset.get();
                        }
                    }
                } else {
                    width += BaselinePanel.this.myOffset.get() + BaselinePanel.this.myProgressComponent.getPreferredSize().width;
                }
                Insets insets = parent.getInsets();
                return new Dimension(width, insets.top + baseSize.height + insets.bottom);
            }

            private int calculateBaseWidth(@NotNull Container parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                int parentWidth = parent.getWidth();
                if (BaselinePanel.this.myProgressComponent != null) {
                    return parentWidth - BaselinePanel.this.myProgressComponent.getPreferredSize().width - BaselinePanel.this.myOffset.get();
                }
                int visibleCount = 0;
                for (Component component2 : BaselinePanel.this.myButtonComponents) {
                    if (!component2.isVisible()) continue;
                    parentWidth -= component2.getPreferredSize().width;
                    ++visibleCount;
                }
                parentWidth -= BaselinePanel.this.myButtonOffset.get() * (visibleCount - 1);
                if (visibleCount > 0) {
                    parentWidth -= BaselinePanel.this.myOffset.get();
                }
                return parentWidth;
            }

            public void layoutContainer(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int top = parent.getInsets().top;
                int y = top + BaselinePanel.this.myBaseComponent.getBaseline(baseSize.width, baseSize.height);
                int x = 0;
                int calcBaseWidth = this.calculateBaseWidth(parent);
                if (BaselinePanel.this.myBaseComponent instanceof JLabel) {
                    JLabel label2 = (JLabel)BaselinePanel.this.myBaseComponent;
                    label2.setToolTipText(calcBaseWidth < baseSize.width ? label2.getText() : null);
                }
                baseSize.width = Math.min(baseSize.width, calcBaseWidth);
                BaselinePanel.this.myBaseComponent.setBounds(x, top, baseSize.width, baseSize.height);
                if (BaselinePanel.this.myProgressComponent != null) {
                    Dimension size2 = BaselinePanel.this.myProgressComponent.getPreferredSize();
                    this.setBaselineBounds(parent.getWidth() - size2.width, y, BaselinePanel.this.myProgressComponent, size2);
                    return;
                }
                int lastX = parent.getWidth();
                for (int i2 = BaselinePanel.this.myButtonComponents.size() - 1; i2 >= 0; --i2) {
                    Component component2 = BaselinePanel.this.myButtonComponents.get(i2);
                    if (!component2.isVisible()) continue;
                    Dimension size3 = component2.getPreferredSize();
                    this.setBaselineBounds(lastX -= size3.width, y - BaselinePanel.this.myYOffset, component2, size3);
                    lastX -= BaselinePanel.this.myButtonOffset.get();
                }
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension size2) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (size2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.setBaselineBounds(x, y, component2, size2, size2.width, size2.height);
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension prefSize, int width, int height) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (prefSize == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (component2 instanceof ActionToolbar) {
                    component2.setBounds(x, BaselinePanel.this.getInsets().top - JBUI.scale((int)1), width, height);
                } else {
                    component2.setBounds(x, y - component2.getBaseline(prefSize.width, prefSize.height), width, height);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "size";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefSize";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calculateBaseWidth";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setBaselineBounds";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            BaselinePanel.$$$reportNull$$$0(0);
        }
        this.myEventHandler = eventHandler;
    }

    public void setYOffset(int YOffset) {
        this.myYOffset = YOffset;
    }

    public Component add(Component component2) {
        assert (this.myBaseComponent == null);
        this.myBaseComponent = component2;
        return super.add(component2);
    }

    @NotNull
    public List<Component> getButtonComponents() {
        List<Component> list2 = this.myButtonComponents;
        if (list2 == null) {
            BaselinePanel.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void addButtonComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            BaselinePanel.$$$reportNull$$$0(2);
        }
        this.myButtonComponents.add(component2);
        this.add(component2, null);
    }

    public void removeButtons() {
        ArrayList<Component> buttons = new ArrayList<Component>(this.myButtonComponents);
        this.myButtonComponents.clear();
        this.myButtonEnableStates = null;
        for (Component button4 : buttons) {
            this.remove(button4);
        }
    }

    public void setProgressComponent(@Nullable ListPluginComponent pluginComponent, @NotNull JComponent progressComponent) {
        if (progressComponent == null) {
            BaselinePanel.$$$reportNull$$$0(3);
        }
        assert (this.myProgressComponent == null);
        this.myProgressComponent = progressComponent;
        this.add(progressComponent, null);
        if (this.myEventHandler != null && pluginComponent != null) {
            this.myEventHandler.addAll(progressComponent);
            this.myEventHandler.updateHover(pluginComponent);
        }
        this.setVisibleOther(false);
        this.doLayout();
    }

    public void removeProgressComponent() {
        if (this.myProgressComponent == null) {
            return;
        }
        this.remove(this.myProgressComponent);
        this.myProgressComponent = null;
        this.setVisibleOther(true);
        this.doLayout();
    }

    private void setVisibleOther(boolean value2) {
        if (this.myButtonComponents.isEmpty()) {
            return;
        }
        if (value2) {
            assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
            int size2 = this.myButtonComponents.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                this.myButtonComponents.get(i2).setVisible(this.myButtonEnableStates[i2]);
            }
            this.myButtonEnableStates = null;
        } else {
            assert (this.myButtonEnableStates == null);
            this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
            int size3 = this.myButtonComponents.size();
            for (int i3 = 0; i3 < size3; ++i3) {
                Component component2 = this.myButtonComponents.get(i3);
                this.myButtonEnableStates[i3] = component2.isVisible();
                component2.setVisible(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addButtonComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProgressComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

