/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalLayout
extends AbstractLayoutManager {
    protected final int myOffset;

    public HorizontalLayout(int offset) {
        this.myOffset = offset;
    }

    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        int visibleCount = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = parent.getComponent(i2);
            if (!component2.isVisible()) continue;
            Dimension size2 = component2.getPreferredSize();
            width += size2.width;
            height = Math.max(height, size2.height);
            ++visibleCount;
        }
        if (visibleCount > 1) {
            width += (visibleCount - 1) * this.myOffset;
        }
        Dimension size3 = new Dimension(width, height);
        JBInsets.addTo((Dimension)size3, (Insets)parent.getInsets());
        return size3;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int height = parent.getHeight() - insets.top - insets.bottom;
        int x = insets.left;
        int count = parent.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = parent.getComponent(i2);
            if (!component2.isVisible()) continue;
            Dimension size2 = component2.getPreferredSize();
            component2.setBounds(x, insets.top + (height - size2.height) / 2, size2.width, size2.height);
            x += size2.width + this.myOffset;
        }
    }
}

