/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final @NlsContexts.PopupTitle String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<@Nls String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<? super T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myValues;
    private JBIterable<T> myTopValues;
    private JBIterable<T> myMiddleValues;
    private JBIterable<T> myBottomValues;

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title2, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(1);
        }
        if (onChosen == null) {
            LRUPopupBuilder.$$$reportNull$$$0(2);
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project, title2, null).forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title2, final @Nullable Function<Language, Icon> iconProvider) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(5);
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project, title2){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                if (iconProvider != null) {
                    return (Icon)iconProvider.apply(language);
                }
                LanguageFileType fileType = language.getAssociatedFileType();
                Icon icon2 = fileType == null ? null : fileType.getIcon();
                return icon2 != null ? icon2 : AllIcons.FileTypes.Any_type;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(6);
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title2) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(7);
        }
        if (title2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(8);
        }
        this.myPresentations = new IdentityHashMap<T, Pair<String, Icon>>();
        this.myTopValues = JBIterable.empty();
        this.myMiddleValues = JBIterable.empty();
        this.myBottomValues = JBIterable.empty();
        this.myTitle = title2;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    @NotNull
    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myValues = items;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(9);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(10);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraTopValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(11);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(12);
        }
        this.myTopValues = this.myTopValues.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(13);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraMiddleValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(14);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(15);
        }
        this.myMiddleValues = this.myMiddleValues.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(16);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraBottomValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(17);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(18);
        }
        this.myBottomValues = this.myBottomValues.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(19);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<? super T> consumer) {
        this.myOnChosen = consumer;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(20);
        }
        return lRUPopupBuilder;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        final List topItems = this.myTopValues.toList();
        ArrayList<Object> lru = new ArrayList<Object>(4);
        List middleItems = this.myMiddleValues.toList();
        ArrayList<? super T> items = new ArrayList<T>(20);
        final List bottomItems = this.myBottomValues.toList();
        for (Object t : JBIterable.from(this.myValues)) {
            (ids.contains(this.getStorageId(t)) ? lru : items).add(t);
        }
        if (this.myComparator != null) {
            items.sort(this.myComparator);
        }
        if (!lru.isEmpty()) {
            lru.sort(Comparator.comparingInt(o -> ids.indexOf(this.getStorageId(o))));
        }
        List combinedItems = ContainerUtil.concat((List[])new List[]{topItems, lru, middleItems, items, bottomItems});
        final Object sep1 = combinedItems.get(topItems.size() + lru.size() + middleItems.size());
        final Object sep2 = bottomItems.isEmpty() ? null : combinedItems.get(topItems.size() + lru.size() + items.size());
        BaseListPopupStep step2 = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                String string = t == null ? "" : (String)LRUPopupBuilder.this.getPresentation(t).first;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)LRUPopupBuilder.this.getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep<?> onChosen(T t, boolean finalChoice) {
                if (!bottomItems.contains(t) && !topItems.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value2) {
                return value2 == sep1 || value2 == sep2 ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$2", "getTextFor"));
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step2.setDefaultOptionIndex(selection);
        return LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2));
    }

    private @NotNull Pair<@Nls String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        Pair pair = p;
        if (pair == null) {
            LRUPopupBuilder.$$$reportNull$$$0(21);
        }
        return pair;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(22);
        }
        int nameLen = 0;
        ListPopupStep step2 = popup2.getListStep();
        List values2 = step2.getValues();
        for (Object v : values2) {
            nameLen = Math.max(nameLen, step2.getTextFor(v).length());
        }
        if (values2.size() > 20) {
            Dimension size2 = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size2.width += 20;
            size2.height *= 20;
            popup2.setSize(size2);
        }
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(23);
        }
        return listPopup;
    }

    private String @NotNull [] restoreLRUItems() {
        String[] stringArray = (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            LRUPopupBuilder.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(25);
        }
        String[] values2 = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList<String> lastUsed = new ArrayList<String>(4);
        lastUsed.add(this.getStorageId(t));
        if (values2 != null) {
            for (String value2 : values2) {
                if (!lastUsed.contains(value2)) {
                    lastUsed.add(value2);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtilRt.toStringArray(lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        String string = this.getClass().getName() + "/" + this.myTitle;
        if (string == null) {
            LRUPopupBuilder.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forFileLanguages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "languagePopupBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withSelection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraTopValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraMiddleValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraBottomValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "onChosen";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakSizeToPreferred";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLRUItems";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFileLanguages";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "languagePopupBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withExtraTopValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withExtraMiddleValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withExtraBottomValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tweakSizeToPreferred";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "storeLRUItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

