/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

final class AboutTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    AboutTroubleInfoCollector() {
    }

    @Override
    @NotNull
    public String getTitle() {
        return "About";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
        Calendar cal = appInfo.getBuildDate();
        Object output2 = "Build version: ";
        output2 = (String)output2 + appInfo.getFullApplicationName();
        String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
        Object buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = (String)buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
        output2 = (String)output2 + " " + buildInfo + " " + (String)buildDate;
        output2 = (String)output2 + "\n";
        output2 = (String)output2 + "Theme: ";
        output2 = (String)output2 + LafManager.getInstance().getCurrentLookAndFeel().getName();
        output2 = (String)output2 + "\n";
        output2 = (String)output2 + "Java version: ";
        Properties properties = System.getProperties();
        output2 = (String)output2 + properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        output2 = (String)output2 + properties.getProperty("os.arch", "");
        output2 = (String)output2 + "\n";
        output2 = (String)output2 + "Operating System: ";
        output2 = (String)output2 + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")";
        output2 = (String)output2 + "\n";
        output2 = (String)output2 + "JVM version: ";
        output2 = (String)output2 + properties.getProperty("java.vm.name", "unknown");
        output2 = (String)output2 + " " + properties.getProperty("java.vendor", "unknown");
        output2 = (String)output2 + "\n";
        output2 = (String)output2 + "idea.config.path=" + AboutTroubleInfoCollector.logPath(PathManager.getConfigPath()) + "\n";
        output2 = (String)output2 + "idea.system.path=" + AboutTroubleInfoCollector.logPath(PathManager.getSystemPath()) + "\n";
        output2 = (String)output2 + "idea.plugins.path=" + AboutTroubleInfoCollector.logPath(PathManager.getPluginsPath()) + "\n";
        output2 = (String)output2 + "idea.log.path=" + AboutTroubleInfoCollector.logPath(PathManager.getLogPath()) + "\n";
        output2 = (String)output2 + AboutTroubleInfoCollector.logEnvVar("_JAVA_OPTIONS");
        output2 = (String)output2 + AboutTroubleInfoCollector.logEnvVar("JDK_JAVA_OPTIONS");
        Object object = output2 = (String)output2 + AboutTroubleInfoCollector.logEnvVar("JAVA_TOOL_OPTIONS");
        if (object == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static String logPath(String path2) {
        try {
            Path configured = Paths.get(path2, new String[0]);
            Path real = configured.toRealPath(new LinkOption[0]);
            if (!configured.equals(real)) {
                return path2 + " -> " + real;
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return path2;
    }

    private static String logEnvVar(String var) {
        String value2 = System.getenv(var);
        return value2 != null ? var + "=" + value2 + "\n" : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

