/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

public final class UINumericRange {
    public final int initial;
    public final int min;
    public final int max;

    public UINumericRange(int defaultValue, int minimumValue, int maximumValue) {
        if (defaultValue < minimumValue || defaultValue > maximumValue) {
            throw new IllegalArgumentException("Wrong range values: [" + minimumValue + ".." + defaultValue + ".." + maximumValue + "]");
        }
        this.initial = defaultValue;
        this.min = minimumValue;
        this.max = maximumValue;
    }

    public int fit(int value2) {
        return Math.max(this.min, Math.min(this.max, value2));
    }

    public String toString() {
        return "[" + this.min + ".." + this.initial + ".." + this.max + "]";
    }
}

