/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.jr.ob.JSON;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class UITheme {
    public static final String FILE_EXT_ENDING = ".theme.json";
    private static final Logger LOG = Logger.getInstance(UITheme.class);
    private String name;
    private boolean dark;
    private String author;
    private String id;
    private String editorScheme;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private IconPathPatcher patcher;
    private Map<String, Object> background;
    private Map<String, Object> emptyFrameBackground;
    private Map<String, Object> colors;
    private ClassLoader providerClassLoader = this.getClass().getClassLoader();
    private String editorSchemeName;
    private SVGLoader.SvgElementColorPatcherProvider colorPatcher;
    private static final String OS_MACOS_KEY = "os.mac";
    private static final String OS_WINDOWS_KEY = "os.windows";
    private static final String OS_LINUX_KEY = "os.linux";
    private static final String OS_DEFAULT_KEY = "os.default";
    private static final NotNullLazyValue<JSON> JSON_READER = NotNullLazyValue.atomicLazy(() -> JSON.builder().enable(new JSON.Feature[]{JSON.Feature.READ_ONLY}).build());
    @NonNls
    private static final Map<String, String> colorPalette = Map.ofEntries(Map.entry("Actions.Red", "#DB5860"), Map.entry("Actions.Red.Dark", "#C75450"), Map.entry("Actions.Yellow", "#EDA200"), Map.entry("Actions.Yellow.Dark", "#F0A732"), Map.entry("Actions.Green", "#59A869"), Map.entry("Actions.Green.Dark", "#499C54"), Map.entry("Actions.Blue", "#389FD6"), Map.entry("Actions.Blue.Dark", "#3592C4"), Map.entry("Actions.Grey", "#6E6E6E"), Map.entry("Actions.Grey.Dark", "#AFB1B3"), Map.entry("Actions.GreyInline", "#7F8B91"), Map.entry("Actions.GreyInline.Dark", "#7F8B91"), Map.entry("Objects.Grey", "#9AA7B0"), Map.entry("Objects.Blue", "#40B6E0"), Map.entry("Objects.Green", "#62B543"), Map.entry("Objects.Yellow", "#F4AF3D"), Map.entry("Objects.YellowDark", "#D9A343"), Map.entry("Objects.Purple", "#B99BF8"), Map.entry("Objects.Pink", "#F98B9E"), Map.entry("Objects.Red", "#F26522"), Map.entry("Objects.RedStatus", "#E05555"), Map.entry("Objects.GreenAndroid", "#3DDC84"), Map.entry("Objects.BlackText", "#231F20"), Map.entry("Checkbox.Background.Default", "#FFFFFF"), Map.entry("Checkbox.Background.Default.Dark", "#43494A"), Map.entry("Checkbox.Background.Disabled", "#F2F2F2"), Map.entry("Checkbox.Background.Disabled.Dark", "#3C3F41"), Map.entry("Checkbox.Border.Default", "#b0b0b0"), Map.entry("Checkbox.Border.Default.Dark", "#6B6B6B"), Map.entry("Checkbox.Border.Disabled", "#BDBDBD"), Map.entry("Checkbox.Border.Disabled.Dark", "#545556"), Map.entry("Checkbox.Focus.Thin.Default", "#7B9FC7"), Map.entry("Checkbox.Focus.Thin.Default.Dark", "#466D94"), Map.entry("Checkbox.Focus.Wide", "#97C3F3"), Map.entry("Checkbox.Focus.Wide.Dark", "#3D6185"), Map.entry("Checkbox.Foreground.Disabled", "#ABABAB"), Map.entry("Checkbox.Foreground.Disabled.Dark", "#606060"), Map.entry("Checkbox.Background.Selected", "#4F9EE3"), Map.entry("Checkbox.Background.Selected.Dark", "#43494A"), Map.entry("Checkbox.Border.Selected", "#4B97D9"), Map.entry("Checkbox.Border.Selected.Dark", "#6B6B6B"), Map.entry("Checkbox.Foreground.Selected", "#FFFFFF"), Map.entry("Checkbox.Foreground.Selected.Dark", "#A7A7A7"), Map.entry("Checkbox.Focus.Thin.Selected", "#ACCFF7"), Map.entry("Checkbox.Focus.Thin.Selected.Dark", "#466D94"), Map.entry("Tree.iconColor", "#808080"), Map.entry("Tree.iconColor.Dark", "#AFB1B3"));

    private UITheme() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isDark() {
        return this.dark;
    }

    public String getAuthor() {
        return this.author;
    }

    public URL getResource(String path2) {
        File file2;
        if (this.isTempTheme() && (file2 = new File(path2)).exists()) {
            try {
                return file2.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
            }
        }
        return this.providerClassLoader.getResource(path2);
    }

    @Nullable
    public InputStream getResourceAsStream(String path2) {
        Path file2;
        if (this.isTempTheme() && Files.exists(file2 = Path.of(path2, new String[0]), new LinkOption[0])) {
            try {
                return Files.newInputStream(file2, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.providerClassLoader.getResourceAsStream(path2);
    }

    private boolean isTempTheme() {
        return "Temp theme".equals(this.id);
    }

    @NotNull
    public static UITheme loadFromJson(@NotNull InputStream stream, @NotNull @NonNls String themeId, @Nullable ClassLoader provider2, final @NotNull Function<? super String, String> iconsMapper) throws IllegalStateException, IOException {
        if (stream == null) {
            UITheme.$$$reportNull$$$0(0);
        }
        if (themeId == null) {
            UITheme.$$$reportNull$$$0(1);
        }
        if (iconsMapper == null) {
            UITheme.$$$reportNull$$$0(2);
        }
        final UITheme theme = (UITheme)((JSON)JSON_READER.getValue()).beanFrom(UITheme.class, (Object)stream);
        theme.id = themeId;
        if (provider2 != null) {
            theme.providerClassLoader = provider2;
        }
        if (theme.icons == null || theme.icons.isEmpty()) {
            UITheme uITheme = theme;
            if (uITheme == null) {
                UITheme.$$$reportNull$$$0(3);
            }
            return uITheme;
        }
        UITheme.initializeNamedColors(theme);
        theme.patcher = new IconPathPatcher(){

            @Nullable
            public String patchPath(@NotNull String path2, @Nullable ClassLoader classLoader) {
                Object pluginIconPath;
                String pluginId;
                Object icons;
                if (path2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (classLoader instanceof PluginAwareClassLoader && (icons = theme.icons.get(pluginId = ((PluginAwareClassLoader)classLoader).getPluginId().getIdString())) instanceof Map && (pluginIconPath = ((Map)icons).get(path2)) instanceof String) {
                    return (String)iconsMapper.apply((String)pluginIconPath);
                }
                Object value2 = theme.icons.get(path2);
                if (value2 == null && path2.charAt(0) != '/') {
                    value2 = theme.icons.get("/" + path2);
                }
                return value2 instanceof String ? (String)iconsMapper.apply((String)value2) : null;
            }

            @Nullable
            public ClassLoader getContextClassLoader(@NotNull String path2, @Nullable ClassLoader originalClassLoader) {
                if (path2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return theme.providerClassLoader;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "path";
                objectArray2[1] = "com/intellij/ide/ui/UITheme$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "patchPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContextClassLoader";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Object palette = theme.icons.get("ColorPalette");
        if (!(palette instanceof Map)) {
            UITheme uITheme = theme;
            if (uITheme == null) {
                UITheme.$$$reportNull$$$0(4);
            }
            return uITheme;
        }
        Map colors = (Map)palette;
        final PaletteScopeManager paletteScopeManager = new PaletteScopeManager();
        for (Object o : colors.keySet()) {
            String colorKey = o.toString();
            PaletteScope scope2 = paletteScopeManager.getScope(colorKey);
            if (scope2 == null) continue;
            String key = UITheme.toColorString(colorKey, theme.isDark());
            Object v = colors.get(colorKey);
            if (!(v instanceof String)) continue;
            String value2 = (String)v;
            String alpha = null;
            if (value2.length() == 9) {
                alpha = value2.substring(7);
                value2 = value2.substring(0, 7);
            }
            if (ColorUtil.fromHex((String)key, null) == null || ColorUtil.fromHex((String)value2, null) == null) continue;
            scope2.newPalette.put(key, value2);
            int fillTransparency = -1;
            if (alpha != null) {
                try {
                    fillTransparency = Integer.parseInt(alpha, 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fillTransparency == -1) continue;
            scope2.alphas.put(value2, fillTransparency);
        }
        theme.colorPatcher = new SVGLoader.SvgElementColorPatcherProvider(){

            @Nullable
            public SVGLoader.SvgElementColorPatcher forPath(@Nullable String path2) {
                PaletteScope scope2 = paletteScopeManager.getScopeByPath(path2);
                if (scope2 == null) {
                    return null;
                }
                byte[] digest = scope2.digest();
                Map<String, String> newPalette = scope2.newPalette;
                Map<String, Integer> alphas = scope2.alphas;
                return SVGLoader.newPatcher((byte[])digest, newPalette, alphas);
            }
        };
        UITheme uITheme = theme;
        if (uITheme == null) {
            UITheme.$$$reportNull$$$0(5);
        }
        return uITheme;
    }

    private static void initializeNamedColors(UITheme theme) {
        Map<String, Object> map2 = theme.colors;
        if (map2 == null) {
            return;
        }
        Set<String> namedColors = map2.keySet();
        for (String key : namedColors) {
            Object value2 = map2.get(key);
            if (!(value2 instanceof String) || ((String)value2).startsWith("#")) continue;
            map2.put(key, ObjectUtils.notNull((Object)map2.get(map2.get(key)), (Object)Gray.TRANSPARENT));
        }
    }

    private static String toColorString(@NotNull String key, boolean darkTheme) {
        String color;
        if (key == null) {
            UITheme.$$$reportNull$$$0(6);
        }
        if (darkTheme && colorPalette.get((String)key + ".Dark") != null) {
            key = (String)key + ".Dark";
        }
        return (color = colorPalette.get(key)) == null ? ((String)key).toLowerCase(Locale.ENGLISH) : color.toLowerCase(Locale.ENGLISH);
    }

    @TestOnly
    public static Map<String, String> getColorPalette() {
        return Collections.unmodifiableMap(colorPalette);
    }

    @NonNls
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getEditorScheme() {
        return this.editorScheme;
    }

    public Map<String, Object> getBackground() {
        return this.background;
    }

    public Map<String, Object> getEmptyFrameBackground() {
        return this.emptyFrameBackground;
    }

    public void applyProperties(@NotNull UIDefaults defaults) {
        if (defaults == null) {
            UITheme.$$$reportNull$$$0(7);
        }
        if (this.ui == null) {
            return;
        }
        this.loadColorPalette(defaults);
        for (Map.Entry<String, Object> entry2 : this.ui.entrySet()) {
            UITheme.apply(this, entry2.getKey(), entry2.getValue(), defaults);
        }
    }

    private void loadColorPalette(@NotNull UIDefaults defaults) {
        if (defaults == null) {
            UITheme.$$$reportNull$$$0(8);
        }
        if (this.colors != null) {
            for (Map.Entry<String, Object> entry2 : this.colors.entrySet()) {
                Color color;
                Object value2 = entry2.getValue();
                if (!(value2 instanceof String) || (color = UITheme.parseColor((String)value2)) == null) continue;
                defaults.put("ColorPalette." + entry2.getKey(), color);
            }
        }
    }

    public IconPathPatcher getPatcher() {
        return this.patcher;
    }

    public SVGLoader.SvgElementColorPatcherProvider getColorPatcher() {
        return this.colorPatcher;
    }

    @NotNull
    public ClassLoader getProviderClassLoader() {
        ClassLoader classLoader = this.providerClassLoader;
        if (classLoader == null) {
            UITheme.$$$reportNull$$$0(9);
        }
        return classLoader;
    }

    private static void apply(@NotNull UITheme theme, String key, Object value2, UIDefaults defaults) {
        if (theme == null) {
            UITheme.$$$reportNull$$$0(10);
        }
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            if (UITheme.isOSCustomization(map2)) {
                UITheme.applyOSCustomizations(theme, map2, key, defaults);
            } else {
                for (Map.Entry o : map2.entrySet()) {
                    UITheme.apply(theme, UITheme.createUIKey(key, (String)o.getKey()), o.getValue(), defaults);
                }
            }
        } else {
            String valueStr = value2.toString();
            Object color = null;
            if (theme.colors != null && theme.colors.containsKey(valueStr) && (color = UITheme.parseColor(String.valueOf(theme.colors.get(valueStr)))) != null && !key.startsWith("*")) {
                defaults.put(key, color);
                return;
            }
            Object object = value2 = color == null ? UITheme.parseValue(key, valueStr) : color;
            if (key.startsWith("*.")) {
                String tail = key.substring(1);
                UITheme.addPattern(key, value2, defaults);
                for (Object k : new ArrayList(defaults.keySet())) {
                    if (!(k instanceof String) || !((String)k).endsWith(tail)) continue;
                    defaults.put(k, value2);
                }
            } else {
                defaults.put(key, value2);
            }
        }
    }

    @NotNull
    private static String createUIKey(String key, String propertyName) {
        if ("UI".equals(propertyName)) {
            String string = key + propertyName;
            if (string == null) {
                UITheme.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = key + "." + propertyName;
        if (string == null) {
            UITheme.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void applyOSCustomizations(@NotNull UITheme theme, Map<String, Object> map2, String key, UIDefaults defaults) {
        String osKey;
        if (theme == null) {
            UITheme.$$$reportNull$$$0(13);
        }
        String string = SystemInfoRt.isWindows ? OS_WINDOWS_KEY : (SystemInfoRt.isMac ? OS_MACOS_KEY : (osKey = SystemInfoRt.isLinux ? OS_LINUX_KEY : null));
        if (osKey != null && map2.containsKey(osKey)) {
            UITheme.apply(theme, key, map2.get(osKey), defaults);
        } else if (map2.containsKey(OS_DEFAULT_KEY)) {
            UITheme.apply(theme, key, map2.get(OS_DEFAULT_KEY), defaults);
        }
    }

    private static boolean isOSCustomization(Map<String, Object> map2) {
        return map2.containsKey(OS_MACOS_KEY) || map2.containsKey(OS_WINDOWS_KEY) || map2.containsKey(OS_LINUX_KEY) || map2.containsKey(OS_DEFAULT_KEY);
    }

    private static void addPattern(String key, Object value2, UIDefaults defaults) {
        HashMap o = defaults.get("*");
        if (!(o instanceof Map)) {
            o = new HashMap();
            defaults.put("*", o);
        }
        Map map2 = o;
        if (key != null && key.startsWith("*.")) {
            map2.put(key.substring(2), value2);
        }
    }

    public static Object parseValue(String key, @NotNull String value2, @NotNull ClassLoader classLoader) {
        Icon icon2;
        if (value2 == null) {
            UITheme.$$$reportNull$$$0(14);
        }
        if (classLoader == null) {
            UITheme.$$$reportNull$$$0(15);
        }
        switch (value2) {
            case "null": {
                return null;
            }
            case "true": {
                return Boolean.TRUE;
            }
            case "false": {
                return Boolean.FALSE;
            }
        }
        if ((value2.endsWith(".png") || value2.endsWith(".svg")) && (icon2 = IconLoader.findIcon((String)value2, (ClassLoader)classLoader)) != null) {
            return icon2;
        }
        if (key.endsWith("Insets") || key.endsWith("padding")) {
            return UITheme.parseInsets(value2);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                String[] ints = value2.split(",");
                if (ints.length == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(UITheme.parseInsets(value2));
                }
                if (ints.length == 5) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)ints[4]), (int)Integer.parseInt(ints[0]), (int)Integer.parseInt(ints[1]), (int)Integer.parseInt(ints[2]), (int)Integer.parseInt(ints[3])));
                }
                Color color = ColorHexUtil.fromHexOrNull((String)value2);
                if (color != null) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)color, (int)1));
                }
                Class<?> aClass = classLoader.loadClass(value2);
                Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            if (key.endsWith("Size")) {
                return UITheme.parseSize(value2);
            }
            if (key.endsWith("Width") || key.endsWith("Height")) {
                return UITheme.getInteger(value2, key);
            }
            if (key.endsWith("grayFilter")) {
                return UITheme.parseGrayFilter(value2);
            }
            Icon icon3 = icon2 = value2.startsWith("AllIcons.") ? IconLoader.getReflectiveIcon((String)value2, (ClassLoader)AllIcons.class.getClassLoader()) : null;
            if (icon2 != null) {
                return new IconUIResource(icon2);
            }
            Color color = UITheme.parseColor(value2);
            if (color != null) {
                return new ColorUIResource(color);
            }
            Integer intVal = UITheme.getInteger(value2, null);
            if (intVal != null) {
                return intVal;
            }
        }
        return value2;
    }

    public static Object parseValue(String key, @NotNull String value2) {
        if (value2 == null) {
            UITheme.$$$reportNull$$$0(16);
        }
        ClassLoader classLoader = UIManager.getLookAndFeel().getClass().getClassLoader();
        return UITheme.parseValue(key, value2, classLoader);
    }

    private static Insets parseInsets(@NotNull String value2) {
        if (value2 == null) {
            UITheme.$$$reportNull$$$0(17);
        }
        String[] numbers = value2.split(",");
        return new JBInsets(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2]), Integer.parseInt(numbers[3])).asUIResource();
    }

    private static UIUtil.GrayFilter parseGrayFilter(String value2) {
        String[] numbers = value2.split(",");
        return new UIUtil.GrayFilter(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2])).asUIResource();
    }

    @Nullable
    private static Color parseColor(String value2) {
        Color color;
        if (value2 != null) {
            if (value2.startsWith("#")) {
                value2 = value2.substring(1);
            }
            if (value2.length() == 8) {
                Color color2 = ColorUtil.fromHex((String)value2.substring(0, 6));
                try {
                    int alpha = Integer.parseInt(value2.substring(6, 8), 16);
                    return new ColorUIResource(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), alpha));
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return (color = ColorHexUtil.fromHex((String)value2, null)) == null ? null : new ColorUIResource(color);
    }

    private static Integer getInteger(String value2, @Nullable String key) {
        try {
            if (value2.endsWith(".0")) {
                value2 = value2.substring(0, value2.length() - ".0".length());
            }
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            if (key != null) {
                LOG.warn(key + " = " + value2);
            }
            return null;
        }
    }

    private static Dimension parseSize(@NotNull String value2) {
        if (value2 == null) {
            UITheme.$$$reportNull$$$0(18);
        }
        String[] numbers = value2.split(",");
        return new JBDimension(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1])).asUIResource();
    }

    public String getEditorSchemeName() {
        return this.editorSchemeName;
    }

    public void setEditorSchemeName(String editorSchemeName) {
        this.editorSchemeName = editorSchemeName;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDark(boolean dark) {
        this.dark = dark;
    }

    private void setAuthor(String author) {
        this.author = author;
    }

    private void setUi(Map<String, Object> ui2) {
        this.ui = ui2;
    }

    private void setIcons(Map<String, Object> icons) {
        this.icons = icons;
    }

    public void setEditorScheme(String editorScheme) {
        this.editorScheme = editorScheme;
    }

    public void setBackground(Map<String, Object> background) {
        this.background = background;
    }

    public void setEmptyFrameBackground(Map<String, Object> emptyFrameBackground) {
        this.emptyFrameBackground = emptyFrameBackground;
    }

    public Map<String, Object> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, Object> colors) {
        this.colors = colors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconsMapper";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/UITheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/UITheme";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromJson";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderClassLoader";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createUIKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJson";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toColorString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadColorPalette";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyOSCustomizations";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseInsets";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class PaletteScopeManager {
        final PaletteScope ui = new PaletteScope();
        final PaletteScope checkBoxes = new PaletteScope();
        final PaletteScope radioButtons = new PaletteScope();
        final PaletteScope trees = new PaletteScope();

        PaletteScopeManager() {
        }

        PaletteScope getScope(String colorKey) {
            if (colorKey.startsWith("Checkbox.")) {
                return this.checkBoxes;
            }
            if (colorKey.startsWith("Radio.")) {
                return this.radioButtons;
            }
            if (colorKey.startsWith("Tree.iconColor")) {
                return this.trees;
            }
            if (colorKey.startsWith("Objects.")) {
                return this.ui;
            }
            if (colorKey.startsWith("Actions.")) {
                return this.ui;
            }
            if (colorKey.startsWith("#")) {
                return this.ui;
            }
            LOG.warn("No color scope defined for key: " + colorKey);
            return null;
        }

        @Nullable
        PaletteScope getScopeByPath(@Nullable String path2) {
            if (path2 != null && path2.contains("/com/intellij/ide/ui/laf/icons/")) {
                String file2 = path2.substring(path2.lastIndexOf(47) + 1);
                if (file2.equals("treeCollapsed.svg") || file2.equals("treeExpanded.svg")) {
                    return this.trees;
                }
                if (file2.startsWith("check")) {
                    return this.checkBoxes;
                }
                if (file2.startsWith("radio")) {
                    return this.checkBoxes;
                }
                return null;
            }
            return this.ui;
        }
    }

    static final class PaletteScope {
        final Map<String, String> newPalette = new HashMap<String, String>();
        final Map<String, Integer> alphas = new HashMap<String, Integer>();
        private byte[] hash = null;

        PaletteScope() {
        }

        byte @NotNull [] digest() {
            if (this.hash != null) {
                if (this.hash == null) {
                    PaletteScope.$$$reportNull$$$0(0);
                }
                return this.hash;
            }
            Hasher hasher = Hashing.sha256().newHasher();
            for (Map.Entry<String, String> entry2 : new TreeMap<String, String>(this.newPalette).entrySet()) {
                hasher.putString((CharSequence)entry2.getKey(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)entry2.getValue(), StandardCharsets.UTF_8);
            }
            for (Map.Entry<String, Object> entry3 : new TreeMap<String, Integer>(this.alphas).entrySet()) {
                hasher.putString((CharSequence)entry3.getKey(), StandardCharsets.UTF_8);
                Integer value2 = (Integer)entry3.getValue();
                if (value2 == null) continue;
                hasher.putInt(value2.intValue());
            }
            this.hash = hasher.hash().asBytes();
            if (this.hash == null) {
                PaletteScope.$$$reportNull$$$0(1);
            }
            return this.hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/UITheme$PaletteScope", "digest"));
        }
    }
}

