/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config2 = new GraphicsConfig((Graphics)g);
        Color bg = c.getBackground();
        g.setPaint(bg);
        TableColumnModel model2 = this.header.getColumnModel();
        int h = this.header.getHeight();
        int w = model2.getTotalColumnWidth();
        g.fillRect(0, 0, w, h);
        JBColor bottomSeparatorColor = JBColor.namedColor((String)"TableHeader.bottomSeparatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.75));
        g.setPaint((Paint)bottomSeparatorColor);
        LinePainter2D.paint((Graphics2D)g, (double)0.0, (double)(h - 1), (double)w, (double)(h - 1));
        JBColor lineColor = JBColor.namedColor((String)"TableHeader.separatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.7));
        config2.restore();
        int first = 0;
        int last = model2.getColumnCount() - 1;
        if (last >= first) {
            int index2;
            Rectangle bounds2;
            Rectangle clip = g.getClipBounds();
            int columnAtLeft = this.header.columnAtPoint(new Point(clip.x, clip.y));
            int columnAtRight = this.header.columnAtPoint(new Point(clip.x + clip.width - 1, clip.y));
            boolean focused = TableUtil.isFocused((JTableHeader)this.header);
            boolean ltr = this.header.getComponentOrientation().isLeftToRight();
            TableColumn draggedColumn = this.header.getDraggedColumn();
            if (ltr) {
                if (columnAtLeft == -1) {
                    columnAtLeft = first;
                }
                if (columnAtRight == -1) {
                    columnAtRight = last;
                }
                bounds2 = this.header.getHeaderRect(columnAtLeft);
                --bounds2.height;
                for (index2 = columnAtLeft; columnAtRight >= index2; ++index2) {
                    if (index2 != first) {
                        DarculaTableHeaderUI.paintLine(g, bounds2, (Color)lineColor);
                    }
                    this.paintCell(g, bounds2, model2, index2, focused, draggedColumn);
                    bounds2.x += bounds2.width;
                }
            } else {
                if (columnAtRight == -1) {
                    columnAtRight = first;
                }
                if (columnAtLeft == -1) {
                    columnAtLeft = last;
                }
                bounds2 = this.header.getHeaderRect(columnAtLeft);
                --bounds2.height;
                for (index2 = columnAtLeft; columnAtRight <= index2; --index2) {
                    if (index2 != last) {
                        DarculaTableHeaderUI.paintLine(g, bounds2, (Color)lineColor);
                    }
                    this.paintCell(g, bounds2, model2, index2, focused, draggedColumn);
                    bounds2.x += bounds2.width;
                }
            }
            if (draggedColumn != null) {
                int index3 = TableUtil.getColumnIndex((JTableHeader)this.header, (TableColumn)draggedColumn);
                Rectangle bounds3 = this.header.getHeaderRect(index3);
                g.setColor(this.header.getParent().getBackground());
                g.fillRect(bounds3.x, bounds3.y, bounds3.width, bounds3.height);
                bounds3.x += this.header.getDraggedDistance();
                g.setColor(this.header.getBackground());
                g.fillRect(bounds3.x, bounds3.y, bounds3.width, bounds3.height);
                this.paintCell(g, bounds3, draggedColumn, index3, focused);
            }
            this.rendererPane.removeAll();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size2 = super.getPreferredSize(c);
        if (size2.height == 0) {
            return size2;
        }
        JBValue.UIInteger height = new JBValue.UIInteger("TableHeader.height", 25);
        return new Dimension(size2.width, Math.max(height.get(), size2.height));
    }

    private static void paintLine(Graphics g, Rectangle bounds2, Color color) {
        g.setColor(color);
        g.fillRect(bounds2.x, bounds2.y + 1, 1, bounds2.height - 2);
    }

    private void paintCell(Graphics g, Rectangle bounds2, TableColumnModel model2, int index2, boolean focused, TableColumn draggedColumn) {
        TableColumn column2 = model2.getColumn(index2);
        bounds2.width = column2.getWidth();
        if (column2 != draggedColumn) {
            this.paintCell(g, bounds2, column2, index2, focused);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCell(Graphics g, Rectangle bounds2, TableColumn column2, int index2, boolean focused) {
        Component component2 = TableUtil.getRendererComponent((JTableHeader)this.header, (TableColumn)column2, (int)index2, (boolean)focused);
        if (component2 != null && this.isExpandableHintShown(column2)) {
            Graphics cg = g.create(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            try {
                int width = Math.max(component2.getPreferredSize().width, bounds2.width);
                this.rendererPane.paintComponent(cg, component2, this.header, 0, 0, width, bounds2.height, true);
            }
            finally {
                cg.dispose();
            }
        } else {
            this.rendererPane.paintComponent(g, component2, this.header, bounds2.x, bounds2.y, bounds2.width, bounds2.height, true);
        }
    }

    private boolean isExpandableHintShown(TableColumn column2) {
        if (column2 != null && this.header instanceof ComponentWithExpandableItems) {
            ComponentWithExpandableItems c = (ComponentWithExpandableItems)this.header;
            return column2 == ContainerUtil.getFirstItem((Collection)c.getExpandableItemsHandler().getExpandedItems());
        }
        return false;
    }
}

