/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);
    private static final String SHORTCUT_ENTITY = "&shortcut:";

    private TipUIUtil() {
    }

    @NlsSafe
    @NotNull
    public static String getPoweredByText(@NotNull TipAndTrickBean tip) {
        PluginDescriptor descriptor2;
        if (tip == null) {
            TipUIUtil.$$$reportNull$$$0(0);
        }
        String string = (descriptor2 = tip.getPluginDescriptor()) == null || PluginManagerCore.CORE_ID.equals((Object)descriptor2.getPluginId()) ? "" : descriptor2.getName();
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static TipAndTrickBean getTip(@Nullable FeatureDescriptor feature) {
        if (feature == null) {
            return null;
        }
        String tipFileName = feature.getTipFileName();
        if (tipFileName == null) {
            LOG.warn("No Tip of the day for feature " + feature.getId());
            return null;
        }
        TipAndTrickBean tip = TipAndTrickBean.findByFileName("neue-" + tipFileName);
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = TipAndTrickBean.findByFileName(tipFileName);
        }
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = new TipAndTrickBean();
            tip.fileName = tipFileName;
        }
        return tip;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, JEditorPane browser2) {
        browser2.setText(TipUIUtil.getTipText(tip, browser2));
    }

    @NlsSafe
    private static String getTipText(@Nullable TipAndTrickBean tip, Component component2) {
        if (tip == null) {
            return IdeBundle.message((String)"no.tip.of.the.day", (Object[])new Object[0]);
        }
        try {
            String cssText;
            StringBuilder text2 = new StringBuilder();
            File tipFile = new File(tip.fileName);
            if (tipFile.isAbsolute() && tipFile.exists()) {
                text2.append(FileUtil.loadFile((File)tipFile, (Charset)StandardCharsets.UTF_8));
                TipUIUtil.updateImages(text2, null, tipFile.getParentFile().getAbsolutePath(), component2);
                cssText = FileUtil.loadFile((File)new File(tipFile.getParentFile(), StartupUiUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css"));
            } else {
                InputStream tipStream;
                PluginDescriptor pluginDescriptor = tip.getPluginDescriptor();
                ClassLoader tipLoader = pluginDescriptor == null ? TipUIUtil.class.getClassLoader() : (ClassLoader)ObjectUtils.notNull((Object)pluginDescriptor.getPluginClassLoader(), (Object)TipUIUtil.class.getClassLoader());
                DynamicBundle.LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
                if (langBundle != null) {
                    tipLoader = langBundle.pluginDescriptor.getPluginClassLoader();
                }
                if ((tipStream = ResourceUtil.getResourceAsStream((ClassLoader)tipLoader, (String)"/tips/", (String)tip.fileName)) == null) {
                    return TipUIUtil.getCantReadText(tip);
                }
                text2.append(ResourceUtil.loadText((InputStream)tipStream));
                TipUIUtil.updateImages(text2, tipLoader, "", component2);
                InputStream cssResourceStream = ResourceUtil.getResourceAsStream((ClassLoader)tipLoader, (String)"/tips/", (String)(StartupUiUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css"));
                cssText = cssResourceStream != null ? ResourceUtil.loadText((InputStream)cssResourceStream) : "";
            }
            TipUIUtil.updateShortcuts(text2);
            String replaced = text2.toString().replace("&productName;", ApplicationNamesInfo.getInstance().getFullProductName());
            String major = ApplicationInfo.getInstance().getMajorVersion();
            replaced = replaced.replace("&majorVersion;", major);
            String minor = ApplicationInfo.getInstance().getMinorVersion();
            replaced = replaced.replace("&minorVersion;", minor);
            replaced = replaced.replace("&majorMinorVersion;", major + (String)("0".equals(minor) ? "" : "." + minor));
            replaced = replaced.replace("&settingsPath;", CommonBundle.settingsActionPath());
            String inlinedCSS = cssText + "\nbody {background-color:#" + ColorUtil.toHex((Color)UIUtil.getTextFieldBackground()) + ";overflow:hidden;}";
            return replaced.replaceFirst("<link.*\\.css\">", "<style type=\"text/css\">\n" + inlinedCSS + "\n</style>");
        }
        catch (IOException e) {
            return TipUIUtil.getCantReadText(tip);
        }
    }

    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, Browser browser2) {
        browser2.setText(TipUIUtil.getTipText(tip, browser2.getComponent()));
    }

    @NotNull
    private static String getCantReadText(@NotNull TipAndTrickBean bean) {
        if (bean == null) {
            TipUIUtil.$$$reportNull$$$0(2);
        }
        String plugin2 = TipUIUtil.getPoweredByText(bean);
        Object product = ApplicationNamesInfo.getInstance().getFullProductName();
        if (!plugin2.isEmpty()) {
            product = (String)product + " and " + plugin2 + " plugin";
        }
        String string = IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{bean.fileName, product});
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void updateImages(StringBuilder text2, ClassLoader tipLoader, String tipPath, Component component2) {
        boolean dark = StartupUiUtil.isUnderDarcula();
        int index2 = text2.indexOf("<img", 0);
        while (index2 != -1) {
            String src;
            String srcWithoutExtension;
            int end = text2.indexOf(">", index2 + 1);
            if (end == -1) {
                return;
            }
            String img = text2.substring(index2, end + 1).replace('\r', ' ').replace('\n', ' ');
            int srcIndex = img.indexOf("src=\"");
            int endIndex = img.indexOf("\"", srcIndex + 6);
            if (srcIndex == -1 && endIndex == -1) {
                srcIndex = img.indexOf("src='");
                endIndex = img.indexOf("'", srcIndex + 6);
            }
            if (endIndex != -1 && (!(srcWithoutExtension = FileUtil.getNameWithoutExtension((String)(src = img.substring(srcIndex + 5, endIndex)))).endsWith("_dark") && !srcWithoutExtension.endsWith("@2x") || tipLoader == null)) {
                boolean hidpi = JBUI.isPixHiDPI((Component)component2);
                String suffix = (dark ? "_dark" : "") + "." + FileUtilRt.getExtension((String)src);
                String path2 = srcWithoutExtension + suffix;
                String path2x = srcWithoutExtension + "@2x" + suffix;
                String canonicalPath = TipUIUtil.getImageCanonicalPath(hidpi ? path2x : path2, tipLoader, tipPath);
                try {
                    BufferedImage image;
                    URL actualURL;
                    boolean fallbackUpscale = false;
                    boolean fallbackDownscale = false;
                    try {
                        actualURL = new URL(canonicalPath);
                        image = TipUIUtil.read(actualURL);
                    }
                    catch (IOException e) {
                        if (hidpi) {
                            fallbackUpscale = true;
                            actualURL = new URL(TipUIUtil.getImageCanonicalPath(path2, tipLoader, tipPath));
                        } else {
                            fallbackDownscale = true;
                            actualURL = new URL(TipUIUtil.getImageCanonicalPath(path2x, tipLoader, tipPath));
                        }
                        image = TipUIUtil.read(actualURL);
                    }
                    String newImgTag = "<img src=\"" + actualURL.toExternalForm() + "\" ";
                    int w = image.getWidth();
                    int h = image.getHeight();
                    if (hidpi) {
                        float k = 2.0f;
                        if (StartupUiUtil.isJreHiDPI((Component)component2)) {
                            k = JBUIScale.sysScale((Component)component2);
                        }
                        w = (int)((float)w / k);
                        h = (int)((float)h / k);
                    }
                    int userScale = PaintUtil.RoundingMode.ROUND_FLOOR_BIAS.round((double)JBUIScale.scale((float)1.0f));
                    w = userScale * w;
                    h = userScale * h;
                    if (fallbackUpscale) {
                        w *= 2;
                        h *= 2;
                    } else if (fallbackDownscale) {
                        w /= 2;
                        h /= 2;
                    }
                    newImgTag = newImgTag + "width=\"" + w + "\" height=\"" + h + "\"";
                    newImgTag = newImgTag + ">";
                    text2.replace(index2, end + 1, newImgTag);
                }
                catch (Exception ignore) {
                    LOG.warn("Cannot find icon with path [" + src + "]");
                }
            }
            index2 = text2.indexOf("<img", index2 + 1);
        }
    }

    @NotNull
    private static String getImageCanonicalPath(@NotNull String path2, @Nullable ClassLoader tipLoader, @NotNull String tipPath) {
        String string;
        if (path2 == null) {
            TipUIUtil.$$$reportNull$$$0(4);
        }
        if (tipPath == null) {
            TipUIUtil.$$$reportNull$$$0(5);
        }
        try {
            URL url = tipLoader == null ? new File(tipPath, path2).toURI().toURL() : ResourceUtil.getResource((ClassLoader)tipLoader, (String)"tips", (String)path2);
            string = url == null ? path2 : url.toExternalForm();
        }
        catch (MalformedURLException e) {
            String string2 = path2;
            if (string2 == null) {
                TipUIUtil.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static BufferedImage read(@NotNull URL url) throws IOException {
        if (url == null) {
            TipUIUtil.$$$reportNull$$$0(8);
        }
        try (InputStream stream = url.openStream();){
            BufferedImage image = ImageIO.read(stream);
            if (image == null) {
                throw new IOException("Cannot read image with ImageIO: " + url.toExternalForm());
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
    }

    private static void updateShortcuts(StringBuilder text2) {
        int lastIndex = 0;
        while ((lastIndex = text2.indexOf(SHORTCUT_ENTITY, lastIndex)) >= 0) {
            Keymap defKeymap;
            int actionIdStart = lastIndex + SHORTCUT_ENTITY.length();
            int actionIdEnd = text2.indexOf(";", actionIdStart);
            if (actionIdEnd < 0) {
                return;
            }
            String actionId = text2.substring(actionIdStart, actionIdEnd);
            Object shortcutText = TipUIUtil.getShortcutText(actionId, KeymapManager.getInstance().getActiveKeymap());
            if (shortcutText == null && (defKeymap = KeymapManager.getInstance().getKeymap(DefaultKeymap.Companion.getInstance().getDefaultKeymapName())) != null && (shortcutText = TipUIUtil.getShortcutText(actionId, defKeymap)) != null) {
                shortcutText = (String)shortcutText + " in default keymap";
            }
            if (shortcutText == null) {
                shortcutText = "<no shortcut for action " + actionId + ">";
            }
            text2.replace(lastIndex, actionIdEnd + 1, (String)shortcutText);
            lastIndex += ((String)shortcutText).length();
        }
        return;
    }

    @Nullable
    private static String getShortcutText(String actionId, Keymap keymap2) {
        for (Shortcut shortcut : keymap2.getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static JEditorPane createTipBrowser() {
        return new SwingBrowser();
    }

    public static Browser createBrowser() {
        return new SwingBrowser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoweredByText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCantReadText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageCanonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPoweredByText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCantReadText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImageCanonicalPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SwingBrowser
    extends JEditorPane
    implements Browser {
        SwingBrowser() {
            this.setEditable(false);
            this.setBackground(UIUtil.getTextFieldBackground());
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            JBHtmlEditorKit kit = new JBHtmlEditorKit(false){
                private final ViewFactory myFactory;
                {
                    super(arg0);
                    this.myFactory = this.createViewFactory();
                }

                private ViewFactory createViewFactory() {
                    return new HTMLEditorKit.HTMLFactory(){

                        @Override
                        public View create(Element elem) {
                            String src;
                            View view = super.create(elem);
                            if (view instanceof ImageView && (src = (String)view.getElement().getAttributes().getAttribute(HTML.Attribute.SRC)) != null) {
                                try {
                                    final URL url = new URL(src);
                                    Dictionary cache2 = (Dictionary)elem.getDocument().getProperty("imageCache");
                                    if (cache2 == null) {
                                        cache2 = new Dictionary(){
                                            private final HashMap myMap = new HashMap();

                                            @Override
                                            public int size() {
                                                return this.myMap.size();
                                            }

                                            @Override
                                            public boolean isEmpty() {
                                                return this.size() == 0;
                                            }

                                            public Enumeration keys() {
                                                return Collections.enumeration(this.myMap.keySet());
                                            }

                                            public Enumeration elements() {
                                                return Collections.enumeration(this.myMap.values());
                                            }

                                            public Object get(Object key) {
                                                return this.myMap.get(key);
                                            }

                                            public Object put(Object key, Object value2) {
                                                return this.myMap.put(key, value2);
                                            }

                                            public Object remove(Object key) {
                                                return this.myMap.remove(key);
                                            }
                                        };
                                        elem.getDocument().putProperty("imageCache", cache2);
                                    }
                                    final Image image = src.endsWith(".svg") ? SVGLoader.load((URL)url, (float)(JBUI.isPixHiDPI((Component)null) ? 2.0f : 1.0f)) : Toolkit.getDefaultToolkit().createImage(url);
                                    cache2.put(url, image);
                                    if (src.endsWith(".svg")) {
                                        return new ImageView(elem){

                                            @Override
                                            public Image getImage() {
                                                return image;
                                            }

                                            @Override
                                            public URL getImageURL() {
                                                return url;
                                            }

                                            @Override
                                            public void paint(Graphics g, Shape a) {
                                                Rectangle bounds2 = a.getBounds();
                                                int width = (int)this.getPreferredSpan(0);
                                                int height = (int)this.getPreferredSpan(1);
                                                BufferedImage buffer = new BufferedImage(width, height, 2);
                                                Graphics2D graphics = buffer.createGraphics();
                                                super.paint(graphics, new Rectangle(buffer.getWidth(), buffer.getHeight()));
                                                UIUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create((Component)null)), (int)bounds2.x, (int)bounds2.y, null);
                                            }

                                            @Override
                                            public float getMaximumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getMinimumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getPreferredSpan(int axis) {
                                                return (float)(axis == 0 ? image.getWidth(null) : image.getHeight(null)) / JBUIScale.sysScale();
                                            }
                                        };
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return view;
                        }
                    };
                }

                public ViewFactory getViewFactory() {
                    return this.myFactory;
                }
            };
            String fileName = StartupUiUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css";
            URL resource = TipUIUtil.class.getClassLoader().getResource("tips/css/" + fileName);
            kit.getStyleSheet().addStyleSheet(StartupUiUtil.loadStyleSheet((URL)resource));
            this.setEditorKit((EditorKit)kit);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (t != null && t.length() > 0) {
                this.setCaretPosition(0);
            }
        }

        @Override
        public void load(String url) throws IOException {
            @NlsSafe String text2 = IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream()));
            this.setText(text2);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    public static interface Browser
    extends TextAccessor {
        public void load(String var1) throws IOException;

        public JComponent getComponent();

        @Override
        public void setText(@Nls String var1);
    }
}

