/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.intellij.Patches;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.util.gotoByName.AnchoredSet;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.gotoByName.PreserveSelection;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.ide.util.gotoByName.SelectIndex;
import com.intellij.ide.util.gotoByName.SelectMostRelevant;
import com.intellij.ide.util.gotoByName.SelectionPolicy;
import com.intellij.ide.util.gotoByName.SelectionPolicyKt;
import com.intellij.ide.util.gotoByName.SelectionSnapshot;
import com.intellij.ide.util.gotoByName.SmartPointerListModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameBase
implements ChooseByNameViewModel {
    public static final String TEMPORARILY_FOCUSABLE_COMPONENT_KEY = "ChooseByNameBase.TemporarilyFocusableComponent";
    private static final Logger LOG = Logger.getInstance(ChooseByNameBase.class);
    @Nullable
    protected final Project myProject;
    protected final ChooseByNameModel myModel;
    @NotNull
    protected ChooseByNameItemProvider myProvider;
    @NlsSafe
    final String myInitialText;
    private boolean mySearchInAnyPlace;
    Component myPreviouslyFocusedComponent;
    private boolean myInitialized;
    final JPanelProvider myTextFieldPanel;
    protected final MyTextField myTextField;
    private final CardLayout myCard;
    private final JPanel myCardContainer;
    protected final JCheckBox myCheckBox;
    private JComponent myToolArea;
    JScrollPane myListScrollPane;
    private final SmartPointerListModel<Object> myListModel;
    protected final JList<Object> myList;
    private final List<Pair<@NlsSafe String, Integer>> myHistory;
    private final List<Pair<@NlsSafe String, Integer>> myFuture;
    protected ChooseByNamePopupComponent.Callback myActionListener;
    protected final Alarm myAlarm;
    private boolean myDisposedFlag;
    private final String[][] myNames;
    private volatile CalcElementsThread myCalcElementsThread;
    private int myListSizeIncreasing;
    private int myMaximumListSizeLimit;
    @NonNls
    private static final String NOT_FOUND_IN_PROJECT_CARD = "syslib";
    @NonNls
    private static final String NOT_FOUND_CARD = "nfound";
    @NonNls
    private static final String CHECK_BOX_CARD = "chkbox";
    @NonNls
    private static final String SEARCHING_CARD = "searching";
    private final int myRebuildDelay;
    private final Alarm myHideAlarm;
    private static final boolean myShowListAfterCompletionKeyStroke = false;
    JBPopup myTextPopup;
    protected JBPopup myDropdownPopup;
    private boolean myClosedByShiftEnter;
    final int myInitialIndex;
    @Nls
    private String myFindUsagesTitle;
    private ShortcutSet myCheckBoxShortcut;
    private final boolean myInitIsDone;
    private boolean myAlwaysHasMore;
    private Point myFocusPoint;
    @Nullable
    SelectionSnapshot currentChosenInfo;
    public static final String EXTRA_ELEM = "...";

    public boolean checkDisposed() {
        return this.myDisposedFlag;
    }

    public void setDisposed(boolean disposedFlag) {
        this.myDisposedFlag = disposedFlag;
        if (disposedFlag) {
            this.setNamesSync(true, null);
            this.setNamesSync(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamesSync(boolean checkboxState, String @Nullable [] value2) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            this.myNames[checkboxState ? 1 : 0] = value2;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model2, String initialText, PsiElement context2) {
        if (model2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(0);
        }
        this(project, model2, ChooseByNameModelEx.getItemProvider(model2, context2), initialText, 0);
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2, String initialText) {
        if (model2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(1);
        }
        if (provider2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(2);
        }
        this(project, model2, provider2, initialText, 0);
    }

    protected ChooseByNameBase(@Nullable Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2, String initialText, int initialIndex) {
        if (model2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(3);
        }
        if (provider2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(4);
        }
        this.myTextFieldPanel = new JPanelProvider();
        this.myTextField = new MyTextField();
        this.myCard = new CardLayout();
        this.myCardContainer = new JPanel(this.myCard);
        this.myCheckBox = new JCheckBox();
        this.myListModel = new SmartPointerListModel();
        this.myList = new JBList(this.myListModel);
        this.myHistory = new ArrayList<Pair<String, Integer>>();
        this.myFuture = new ArrayList<Pair<String, Integer>>();
        this.myAlarm = new Alarm();
        this.myNames = new String[2][];
        this.myListSizeIncreasing = 30;
        this.myMaximumListSizeLimit = 30;
        this.myHideAlarm = new Alarm();
        this.myProject = project;
        this.myModel = model2;
        this.myInitialText = initialText;
        this.myProvider = provider2;
        this.myInitialIndex = initialIndex;
        this.mySearchInAnyPlace = Registry.is((String)"ide.goto.middle.matching") && model2.useMiddleMatching();
        this.myRebuildDelay = Registry.intValue((String)"ide.goto.rebuild.delay");
        this.myTextField.setText(this.myInitialText);
        this.myInitIsDone = true;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isSearchInAnyPlace() {
        return this.mySearchInAnyPlace;
    }

    public void setSearchInAnyPlace(boolean searchInAnyPlace) {
        this.mySearchInAnyPlace = searchInAnyPlace;
    }

    public boolean isClosedByShiftEnter() {
        return this.myClosedByShiftEnter;
    }

    public boolean isOpenInCurrentWindowRequested() {
        return this.isClosedByShiftEnter();
    }

    public void setToolArea(@NotNull JComponent toolArea) {
        if (toolArea == null) {
            ChooseByNameBase.$$$reportNull$$$0(5);
        }
        if (this.myToolArea != null) {
            throw new IllegalStateException("Tool area is modifiable only before invoke()");
        }
        this.myToolArea = toolArea;
    }

    public void setFindUsagesTitle(@Nullable @Nls String findUsagesTitle) {
        this.myFindUsagesTitle = findUsagesTitle;
    }

    public void invoke(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
        this.initUI(callback2, modalityState, allowMultipleSelection);
    }

    @Override
    @NotNull
    public ChooseByNameModel getModel() {
        ChooseByNameModel chooseByNameModel = this.myModel;
        if (chooseByNameModel == null) {
            ChooseByNameBase.$$$reportNull$$$0(6);
        }
        return chooseByNameModel;
    }

    protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
        String text2;
        Color color;
        this.myPreviouslyFocusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myActionListener = callback2;
        this.myTextFieldPanel.setLayout(new BoxLayout(this.myTextFieldPanel, 1));
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        JPanel caption2Tools = new JPanel(new BorderLayout());
        if (this.myModel.getPromptText() != null) {
            JLabel label2 = new JLabel(this.myModel.getPromptText());
            label2.setFont(UIUtil.getLabelFont().deriveFont(1));
            caption2Tools.add((Component)label2, "West");
        }
        caption2Tools.add((Component)hBox, "East");
        String checkBoxName = this.myModel.getCheckBoxName();
        Color fg = UIUtil.getLabelDisabledForeground();
        Color color2 = color = StartupUiUtil.isUnderDarcula() ? ColorUtil.shift((Color)fg, (double)1.2) : ColorUtil.shift((Color)fg, (double)0.7);
        if (checkBoxName == null) {
            text2 = "";
        } else {
            HtmlBuilder builder2 = new HtmlBuilder().append(checkBoxName);
            if (this.myCheckBoxShortcut != null && this.myCheckBoxShortcut.getShortcuts().length > 0) {
                builder2.append(" ").append((HtmlChunk)HtmlChunk.tag((String)"b").attr("color", ColorUtil.toHex((Color)color)).addText(KeymapUtil.getShortcutsText((Shortcut[])this.myCheckBoxShortcut.getShortcuts())));
            }
            text2 = builder2.wrapWith("html").toString();
        }
        this.myCheckBox.setText(text2);
        this.myCheckBox.setAlignmentX(4.0f);
        this.myCheckBox.setBorder(null);
        this.myCheckBox.setSelected(this.myModel.loadInitialCheckBoxState());
        if (checkBoxName == null) {
            this.myCheckBox.setVisible(false);
        }
        this.addCard(this.myCheckBox, CHECK_BOX_CARD);
        this.addCard(new HintLabel(this.myModel.getNotInMessage()), NOT_FOUND_IN_PROJECT_CARD);
        this.addCard(new HintLabel(IdeBundle.message((String)"label.choosebyname.no.matches.found", (Object[])new Object[0])), NOT_FOUND_CARD);
        JPanel searching = new JPanel(new BorderLayout(5, 0));
        searching.add((Component)new AsyncProcessIcon(SEARCHING_CARD), "West");
        searching.add((Component)new HintLabel(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0])), "Center");
        this.addCard(searching, SEARCHING_CARD);
        this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
        if (this.isCheckboxVisible()) {
            hBox.add(this.myCardContainer);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new ShowFindUsagesAction(){

            @Override
            public PsiElement @NotNull [] getElements() {
                List<Object> objects = ChooseByNameBase.this.myListModel.getItems();
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>(objects.size());
                for (Object object : objects) {
                    if (object instanceof PsiElement) {
                        elements.add((PsiElement)object);
                        continue;
                    }
                    if (!(object instanceof DataProvider)) continue;
                    ContainerUtil.addIfNotNull(elements, (Object)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData((DataProvider)object)));
                }
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameBase$1", "getElements"));
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ChooseByNameBase", (ActionGroup)group2, true);
        actionToolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setBorder(null);
        if (this.myToolArea == null) {
            this.myToolArea = new JLabel((Icon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)1, (int)24)));
        } else {
            this.myToolArea.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        }
        hBox.add(this.myToolArea);
        hBox.add(toolbarComponent);
        this.myTextFieldPanel.add(caption2Tools);
        new MyCopyReferenceAction().registerCustomShortcutSet(ActionManager.getInstance().getAction("$Copy").getShortcutSet(), this.myTextField);
        this.myTextFieldPanel.add(this.myTextField);
        Font editorFont = EditorUtil.getEditorFont();
        this.myTextField.setFont(editorFont);
        this.myTextField.putClientProperty("caretWidth", JBUIScale.scale((int)EditorUtil.getDefaultCaretWidth()));
        if (checkBoxName != null && this.myCheckBoxShortcut != null) {
            new DumbAwareAction(IdeBundle.messagePointer((String)"action.AnActionButton.text.change.goto.check.box", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ChooseByNameBase.this.myCheckBox.setSelected(!ChooseByNameBase.this.myCheckBox.isSelected());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet(this.myCheckBoxShortcut, (JComponent)this.myTextField);
        }
        if (this.isCloseByFocusLost()) {
            this.myTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(@NotNull FocusEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (Registry.is((String)"focus.follows.mouse.workarounds")) {
                        PointerInfo pointerInfo;
                        if (ChooseByNameBase.this.myFocusPoint != null && (pointerInfo = MouseInfo.getPointerInfo()) != null && ChooseByNameBase.this.myFocusPoint.equals(pointerInfo.getLocation())) {
                            IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                            ChooseByNameBase.this.myFocusPoint = null;
                            return;
                        }
                        ChooseByNameBase.this.myFocusPoint = null;
                    }
                    ChooseByNameBase.this.cancelListUpdater();
                    ChooseByNameBase.this.myHideAlarm.addRequest(() -> {
                        JBPopup popup2 = JBPopupFactory.getInstance().getChildFocusedPopup(e.getComponent());
                        if (popup2 != null) {
                            popup2.addListener(new JBPopupListener(){

                                public void onClosed(@NotNull LightweightWindowEvent event) {
                                    if (event == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    if (event.isOk()) {
                                        ChooseByNameBase.this.hideHint();
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3$1", "onClosed"));
                                }
                            });
                        } else {
                            Component oppositeComponent = e.getOppositeComponent();
                            if (oppositeComponent == ChooseByNameBase.this.myCheckBox) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (oppositeComponent != null && !(oppositeComponent instanceof JFrame) && ChooseByNameBase.this.myList.isShowing() && (oppositeComponent == ChooseByNameBase.this.myList || SwingUtilities.isDescendingFrom(ChooseByNameBase.this.myList, oppositeComponent))) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (ChooseByNameBase.this.isDescendingFromTemporarilyFocusableToolWindow(oppositeComponent)) {
                                return;
                            }
                            if (UIUtil.haveCommonOwner((Component)oppositeComponent, (Component)e.getComponent())) {
                                return;
                            }
                            ChooseByNameBase.this.hideHint();
                        }
                    }, 5);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$3", "focusLost"));
                }
            });
        }
        this.myCheckBox.addItemListener(__ -> this.rebuildList(false));
        this.myCheckBox.setFocusable(false);
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                SelectMostRelevant toSelect2 = ChooseByNameBase.this.currentChosenInfo != null && ChooseByNameBase.this.currentChosenInfo.hasSamePattern(ChooseByNameBase.this) ? PreserveSelection.INSTANCE : SelectMostRelevant.INSTANCE;
                ChooseByNameBase.this.rebuildList(toSelect2, ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$4", "textChanged"));
            }
        });
        final Set<KeyStroke> upShortcuts = ChooseByNameBase.getShortcuts("EditorUp");
        final Set<KeyStroke> downShortcuts = ChooseByNameBase.getShortcuts("EditorDown");
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (e.getKeyCode() == 10 && (e.getModifiers() & 1) != 0) {
                    ChooseByNameBase.this.myClosedByShiftEnter = true;
                    ChooseByNameBase.this.close(true);
                }
                if (!ChooseByNameBase.this.myListScrollPane.isVisible()) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = upShortcuts.contains(stroke) ? 38 : (downShortcuts.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ScrollingUtil.moveDown(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ScrollingUtil.moveUp(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ScrollingUtil.movePageUp(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 34: {
                        ScrollingUtil.movePageDown(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 9: {
                        ChooseByNameBase.this.close(true);
                        break;
                    }
                    case 10: {
                        if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.EXTRA_ELEM) break;
                        ChooseByNameBase.this.myMaximumListSizeLimit += ChooseByNameBase.this.myListSizeIncreasing;
                        ChooseByNameBase.this.rebuildList(new SelectIndex(ChooseByNameBase.this.myList.getSelectedIndex()), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        e.consume();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$5", "keyPressed"));
            }
        });
        this.myTextField.addActionListener(__ -> {
            if (!this.getChosenElements().isEmpty()) {
                this.doClose(true);
            }
        });
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(allowMultipleSelection ? 2 : 0);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!ChooseByNameBase.this.myTextField.hasFocus()) {
                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                }
                if (clickCount == 2) {
                    int selectedIndex = ChooseByNameBase.this.myList.getSelectedIndex();
                    Rectangle selectedCellBounds = ChooseByNameBase.this.myList.getCellBounds(selectedIndex, selectedIndex);
                    if (selectedCellBounds != null && selectedCellBounds.contains(e.getPoint())) {
                        if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.EXTRA_ELEM) {
                            ChooseByNameBase.this.myMaximumListSizeLimit += ChooseByNameBase.this.myListSizeIncreasing;
                            ChooseByNameBase.this.rebuildList(new SelectIndex(selectedIndex), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        } else {
                            ChooseByNameBase.this.doClose(true);
                        }
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/gotoByName/ChooseByNameBase$6", "onClick"));
            }
        }.installOn(this.myList);
        ListCellRenderer modelRenderer = this.myModel.getListCellRenderer();
        this.myList.setCellRenderer((list2, value2, index2, isSelected, cellHasFocus) -> (Component)AstLoadingFilter.disallowTreeLoading(() -> modelRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus)));
        this.myList.setVisibleRowCount(16);
        this.myList.setFont(editorFont);
        this.myList.addListSelectionListener(__ -> {
            if (this.checkDisposed()) {
                return;
            }
            this.chosenElementMightChange();
            this.updateDocumentation();
            List<Object> chosenElements = this.getChosenElements();
            if (!chosenElements.isEmpty()) {
                this.currentChosenInfo = new SelectionSnapshot(this.getTrimmedText(), new HashSet<Object>(chosenElements));
            }
        });
        this.myListScrollPane = ScrollPaneFactory.createScrollPane(this.myList, (boolean)true);
        this.myTextFieldPanel.setBorder(JBUI.Borders.empty((int)5));
        this.showTextFieldPanel();
        this.myInitialized = true;
        if (modalityState != null) {
            this.rebuildList(SelectionPolicyKt.fromIndex(this.myInitialIndex), 0, modalityState, null);
        }
    }

    private boolean isDescendingFromTemporarilyFocusableToolWindow(@Nullable Component component2) {
        if (component2 == null || this.myProject == null || this.myProject.isDisposed()) {
            return false;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
        ToolWindow toolWindow = activeToolWindowId == null ? null : toolWindowManager.getToolWindow(activeToolWindowId);
        JComponent toolWindowComponent = toolWindow != null ? toolWindow.getComponent() : null;
        return toolWindowComponent != null && toolWindowComponent.getClientProperty(TEMPORARILY_FOCUSABLE_COMPONENT_KEY) != null && SwingUtilities.isDescendingFrom(component2, toolWindowComponent);
    }

    private void addCard(@NotNull JComponent comp, @NotNull @NonNls String cardId) {
        if (comp == null) {
            ChooseByNameBase.$$$reportNull$$$0(7);
        }
        if (cardId == null) {
            ChooseByNameBase.$$$reportNull$$$0(8);
        }
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)comp, "East");
        this.myCardContainer.add((Component)wrapper2, cardId);
    }

    public void setCheckBoxShortcut(@NotNull ShortcutSet shortcutSet) {
        if (shortcutSet == null) {
            ChooseByNameBase.$$$reportNull$$$0(9);
        }
        this.myCheckBoxShortcut = shortcutSet;
    }

    @NotNull
    private static Set<KeyStroke> getShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            ChooseByNameBase.$$$reportNull$$$0(10);
        }
        HashSet<KeyStroke> result2 = new HashSet<KeyStroke>();
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            result2.add(keyboardShortcut.getFirstKeyStroke());
        }
        HashSet<KeyStroke> hashSet = result2;
        if (hashSet == null) {
            ChooseByNameBase.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private void hideHint() {
        if (!this.myTextFieldPanel.focusRequested()) {
            this.doClose(false);
            this.myTextFieldPanel.hideHint();
        }
    }

    public void rebuildList(boolean initial) {
        this.rebuildList(initial ? SelectionPolicyKt.fromIndex(this.myInitialIndex) : SelectMostRelevant.INSTANCE, this.myRebuildDelay, ModalityState.current(), null);
    }

    private void updateDocumentation() {
        JBPopup hint = this.myTextFieldPanel.getHint();
        Object element2 = this.getChosenElement();
        if (hint != null) {
            Object o;
            if (element2 instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)element2);
            } else if (element2 instanceof DataProvider && (o = ((DataProvider)element2).getData(CommonDataKeys.PSI_ELEMENT.getName())) instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)o);
            }
        }
    }

    @Override
    @NotNull
    public String transformPattern(@NotNull String pattern) {
        if (pattern == null) {
            ChooseByNameBase.$$$reportNull$$$0(12);
        }
        String string = pattern;
        if (string == null) {
            ChooseByNameBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected void doClose(boolean ok) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.closeForbidden(ok)) {
            return;
        }
        this.cancelListUpdater();
        this.close(ok);
        this.myListModel.removeAll();
    }

    protected boolean closeForbidden(boolean ok) {
        return false;
    }

    void cancelListUpdater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.checkDisposed()) {
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
            this.myCalcElementsThread = null;
        }
    }

    @NotNull
    @NlsSafe
    public String getTrimmedText() {
        String string = StringUtil.trimLeading((String)StringUtil.notNullize((String)this.myTextField.getText()));
        if (string == null) {
            ChooseByNameBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    private synchronized String @NotNull [] ensureNamesLoaded(boolean checkboxState) {
        String[] cached = this.getNamesSync(checkboxState);
        if (cached != null) {
            if (cached == null) {
                ChooseByNameBase.$$$reportNull$$$0(15);
            }
            return cached;
        }
        if (checkboxState && this.myModel instanceof ContributorsBasedGotoByModel && ((ContributorsBasedGotoByModel)this.myModel).sameNamesForProjectAndLibraries() && this.getNamesSync(false) != null) {
            String[] allNames = this.getNamesSync(false);
            this.setNamesSync(true, allNames);
            if (allNames == null) {
                ChooseByNameBase.$$$reportNull$$$0(16);
            }
            return allNames;
        }
        String[] result2 = this.myModel.getNames(checkboxState);
        assert (result2 != null) : "Model " + this.myModel + "(" + this.myModel.getClass() + ") returned null names";
        this.setNamesSync(checkboxState, result2);
        if (result2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(17);
        }
        return result2;
    }

    public String @NotNull [] getNames(boolean checkboxState) {
        this.setNamesSync(checkboxState, null);
        return this.ensureNamesLoaded(checkboxState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNamesSync(boolean checkboxState) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.myNames[checkboxState ? 1 : 0];
        }
    }

    @NotNull
    protected Set<Object> filter(@NotNull Set<Object> elements) {
        if (elements == null) {
            ChooseByNameBase.$$$reportNull$$$0(18);
        }
        Set<Object> set2 = elements;
        if (set2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(19);
        }
        return set2;
    }

    protected abstract boolean isCheckboxVisible();

    protected abstract boolean isShowListForEmptyPattern();

    protected abstract boolean isCloseByFocusLost();

    protected void showTextFieldPanel() {
        JLayeredPane layeredPane2 = this.getLayeredPane();
        Dimension preferredTextFieldPanelSize = this.myTextFieldPanel.getPreferredSize();
        int x = (layeredPane2.getWidth() - preferredTextFieldPanelSize.width) / 2;
        int paneHeight = layeredPane2.getHeight();
        int y = paneHeight / 3 - preferredTextFieldPanelSize.height / 2;
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myTextFieldPanel, (JComponent)this.myTextField);
        builder2.setLocateWithinScreenBounds(false);
        builder2.setKeyEventHandler(event -> {
            if (this.myTextPopup == null || !AbstractPopup.isCloseRequest(event) || !this.myTextPopup.isCancelKeyEnabled()) {
                return false;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
            if (this.isDescendingFromTemporarilyFocusableToolWindow(focusManager.getFocusOwner())) {
                focusManager.requestFocus((Component)this.myTextField, true);
                return false;
            }
            this.myTextPopup.cancel((InputEvent)event);
            return true;
        }).setCancelCallback(() -> {
            this.myTextPopup = null;
            this.close(false);
            return Boolean.TRUE;
        }).setFocusable(true).setRequestFocus(true).setModalContext(false).setCancelOnClickOutside(false);
        Point point = new Point(x, y);
        SwingUtilities.convertPointToScreen(point, layeredPane2);
        Rectangle bounds2 = new Rectangle(point, new Dimension(preferredTextFieldPanelSize.width + 20, preferredTextFieldPanelSize.height));
        this.myTextPopup = builder2.createPopup();
        this.myTextPopup.setSize(bounds2.getSize());
        this.myTextPopup.setLocation(bounds2.getLocation());
        if (this.myProject != null && !this.myProject.isDefault()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this.myTextPopup);
        }
        Disposer.register((Disposable)this.myTextPopup, () -> this.cancelListUpdater());
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        this.myTextPopup.show((Component)layeredPane2);
    }

    private JLayeredPane getLayeredPane() {
        JLayeredPane layeredPane2;
        Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
        if (window instanceof JFrame) {
            layeredPane2 = ((JFrame)window).getLayeredPane();
        } else if (window instanceof JDialog) {
            layeredPane2 = ((JDialog)window).getLayeredPane();
        } else if (window instanceof JWindow) {
            layeredPane2 = ((JWindow)window).getLayeredPane();
        } else {
            throw new IllegalStateException("cannot find parent window: project=" + this.myProject + (String)(this.myProject != null ? "; open=" + this.myProject.isOpen() : "") + "; window=" + window);
        }
        return layeredPane2;
    }

    void rebuildList(@NotNull SelectionPolicy pos, int delay, @NotNull ModalityState modalityState, @Nullable Runnable postRunnable) {
        if (pos == null) {
            ChooseByNameBase.$$$reportNull$$$0(20);
        }
        if (modalityState == null) {
            ChooseByNameBase.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (delay > 0) {
            this.myAlarm.addRequest(() -> this.rebuildList(pos, 0, modalityState, postRunnable), delay, ModalityState.stateForComponent((Component)this.myTextField));
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
        }
        String text2 = this.getTrimmedText();
        if (!this.canShowListForEmptyPattern() && text2.isEmpty()) {
            this.myListModel.removeAll();
            this.hideList();
            this.myTextFieldPanel.hideHint();
            this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
            return;
        }
        ListCellRenderer cellRenderer = this.myList.getCellRenderer();
        if (cellRenderer instanceof ExpandedItemListCellRendererWrapper) {
            cellRenderer = ((ExpandedItemListCellRendererWrapper)cellRenderer).getWrappee();
        }
        String pattern = ChooseByNameBase.patternToLowerCase(this.transformPattern(text2));
        Matcher matcher = ChooseByNameBase.buildPatternMatcher((String)(this.isSearchInAnyPlace() ? "*" + pattern : pattern));
        MatcherHolder.associateMatcher(this.myList, matcher);
        this.scheduleCalcElements(text2, this.myCheckBox.isSelected(), modalityState, pos, elements -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (postRunnable != null) {
                postRunnable.run();
            }
        });
    }

    private void backgroundCalculationFinished(@NotNull Collection<?> result2, @NotNull SelectionPolicy toSelect2) {
        if (result2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(22);
        }
        if (toSelect2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(23);
        }
        this.myCalcElementsThread = null;
        this.setElementsToList(toSelect2, result2);
        this.myList.repaint();
        this.chosenElementMightChange();
        if (result2.isEmpty()) {
            this.myTextFieldPanel.hideHint();
        }
    }

    public void scheduleCalcElements(@NotNull String text2, boolean checkboxState, @NotNull ModalityState modalityState, @NotNull SelectionPolicy policy, @NotNull Consumer<? super Set<?>> callback2) {
        if (text2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(24);
        }
        if (modalityState == null) {
            ChooseByNameBase.$$$reportNull$$$0(25);
        }
        if (policy == null) {
            ChooseByNameBase.$$$reportNull$$$0(26);
        }
        if (callback2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(27);
        }
        new CalcElementsThread(text2, checkboxState, modalityState, policy, callback2).scheduleThread();
    }

    private static boolean isShowListAfterCompletionKeyStroke() {
        return false;
    }

    private void setElementsToList(@NotNull SelectionPolicy pos, @NotNull Collection<?> elements) {
        PointerInfo pointerInfo;
        if (pos == null) {
            ChooseByNameBase.$$$reportNull$$$0(28);
        }
        if (elements == null) {
            ChooseByNameBase.$$$reportNull$$$0(29);
        }
        if (this.checkDisposed()) {
            return;
        }
        if (this.isCloseByFocusLost() && Registry.is((String)"focus.follows.mouse.workarounds") && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            this.myFocusPoint = pointerInfo.getLocation();
        }
        if (elements.isEmpty()) {
            this.myListModel.removeAll();
            this.myTextField.setForeground((Color)JBColor.red);
            this.hideList();
            return;
        }
        Object[] oldElements = this.myListModel.getItems().toArray();
        Object[] newElements = elements.toArray();
        if (ArrayUtil.contains(null, (Object[])newElements)) {
            LOG.error("Null after filtering elements by " + this);
        }
        List<ModelDiff.Cmd> commands = ModelDiff.createDiffCmds(this.myListModel, oldElements, newElements);
        this.myTextField.setForeground(UIUtil.getTextFieldForeground());
        if (commands == null || commands.isEmpty()) {
            this.applySelection(pos);
            this.showList();
            this.myTextFieldPanel.repositionHint();
        } else {
            this.appendToModel(commands, pos);
        }
    }

    @VisibleForTesting
    public int calcSelectedIndex(Object @NotNull [] modelElements, @NotNull String trimmedText) {
        int bestPosition;
        if (trimmedText == null) {
            ChooseByNameBase.$$$reportNull$$$0(30);
        }
        if (modelElements == null) {
            ChooseByNameBase.$$$reportNull$$$0(31);
        }
        if (this.myModel instanceof Comparator) {
            return 0;
        }
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.transformPattern(trimmedText));
        String statContext = this.statisticsContext();
        Comparator<Object> itemComparator = Comparator.comparing(e -> trimmedText.equalsIgnoreCase(this.myModel.getElementName(e))).thenComparing(e -> this.matchingDegree(matcher, e)).thenComparing(e -> this.getUseCount(statContext, e)).reversed();
        for (bestPosition = 0; bestPosition < modelElements.length - 1 && ChooseByNameBase.isSpecialElement(modelElements[bestPosition]); ++bestPosition) {
        }
        for (int i2 = 1; i2 < modelElements.length; ++i2) {
            Object modelElement = modelElements[i2];
            if (ChooseByNameBase.isSpecialElement(modelElement) || itemComparator.compare(modelElement, modelElements[bestPosition]) >= 0) continue;
            bestPosition = i2;
        }
        return bestPosition;
    }

    private static boolean isSpecialElement(@NotNull Object modelElement) {
        if (modelElement == null) {
            ChooseByNameBase.$$$reportNull$$$0(32);
        }
        return EXTRA_ELEM.equals(modelElement);
    }

    private int getUseCount(@NotNull String statContext, @NotNull Object modelElement) {
        String text2;
        if (statContext == null) {
            ChooseByNameBase.$$$reportNull$$$0(33);
        }
        if (modelElement == null) {
            ChooseByNameBase.$$$reportNull$$$0(34);
        }
        return (text2 = this.myModel.getFullName(modelElement)) == null ? Integer.MIN_VALUE : StatisticsManager.getInstance().getUseCount(new StatisticsInfo(statContext, text2));
    }

    private int matchingDegree(@NotNull Matcher matcher, @NotNull Object modelElement) {
        String name;
        if (matcher == null) {
            ChooseByNameBase.$$$reportNull$$$0(35);
        }
        if (modelElement == null) {
            ChooseByNameBase.$$$reportNull$$$0(36);
        }
        return (name = this.myModel.getElementName(modelElement)) != null && matcher instanceof MinusculeMatcher ? ((MinusculeMatcher)matcher).matchingDegree(name) : Integer.MIN_VALUE;
    }

    @NotNull
    @NonNls
    String statisticsContext() {
        String string = "choose_by_name#" + this.myModel.getPromptText() + "#" + this.myCheckBox.isSelected() + "#" + this.getTrimmedText();
        if (string == null) {
            ChooseByNameBase.$$$reportNull$$$0(37);
        }
        return string;
    }

    private void appendToModel(@NotNull List<? extends ModelDiff.Cmd> commands, @NotNull SelectionPolicy selection) {
        if (commands == null) {
            ChooseByNameBase.$$$reportNull$$$0(38);
        }
        if (selection == null) {
            ChooseByNameBase.$$$reportNull$$$0(39);
        }
        for (ModelDiff.Cmd cmd : commands) {
            cmd.apply();
        }
        this.showList();
        this.myTextFieldPanel.repositionHint();
        if (!this.myListModel.isEmpty()) {
            this.applySelection(selection);
        }
    }

    private void applySelection(@NotNull SelectionPolicy selection) {
        if (selection == null) {
            ChooseByNameBase.$$$reportNull$$$0(40);
        }
        List<Integer> indices = selection.performSelection(this, this.myListModel);
        this.myList.setSelectedIndices(Ints.toArray(indices));
        if (!indices.isEmpty()) {
            ScrollingUtil.ensureIndexIsVisible(this.myList, (int)indices.get(0), (int)0);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean hasPostponedAction() {
        return false;
    }

    protected abstract void showList();

    protected abstract void hideList();

    protected abstract void close(boolean var1);

    @Nullable
    public Object getChosenElement() {
        List<Object> elements = this.getChosenElements();
        return elements.size() == 1 ? elements.get(0) : null;
    }

    @NotNull
    protected List<Object> getChosenElements() {
        List list2 = ContainerUtil.filter(this.myList.getSelectedValuesList(), o -> o != null && !ChooseByNameBase.isSpecialElement(o));
        if (list2 == null) {
            ChooseByNameBase.$$$reportNull$$$0(41);
        }
        return list2;
    }

    protected void chosenElementMightChange() {
    }

    @NotNull
    public ChooseByNameItemProvider getProvider() {
        ChooseByNameItemProvider chooseByNameItemProvider = this.myProvider;
        if (chooseByNameItemProvider == null) {
            ChooseByNameBase.$$$reportNull$$$0(42);
        }
        return chooseByNameItemProvider;
    }

    private void handlePaste(@NotNull String str) {
        if (str == null) {
            ChooseByNameBase.$$$reportNull$$$0(43);
        }
        if (!this.myInitIsDone) {
            return;
        }
        if (this.myModel instanceof GotoClassModel2 && ChooseByNameBase.isFileName(str)) {
            SwingUtilities.invokeLater(() -> {
                GotoFileAction gotoFile = new GotoFileAction();
                DataContext context2 = DataManager.getInstance().getDataContext((Component)this.myTextField);
                gotoFile.actionPerformed(AnActionEvent.createFromAnAction((AnAction)gotoFile, null, (String)"unknown", (DataContext)context2));
            });
        }
    }

    private static boolean isFileName(@NotNull String name) {
        int index2;
        if (name == null) {
            ChooseByNameBase.$$$reportNull$$$0(44);
        }
        if ((index2 = name.lastIndexOf(46)) > 0) {
            String ext = name.substring(index2 + 1);
            if (ext.contains(":")) {
                ext = ext.substring(0, ext.indexOf(58));
            }
            if (FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(ext) != UnknownFileType.INSTANCE) {
                return true;
            }
        }
        return false;
    }

    private boolean isProjectDisposed() {
        return this.myProject != null && this.myProject.isDisposed();
    }

    @NotNull
    @NlsSafe
    private static String patternToLowerCase(@NotNull @NlsSafe String pattern) {
        if (pattern == null) {
            ChooseByNameBase.$$$reportNull$$$0(45);
        }
        String string = StringUtil.toLowerCase((String)pattern);
        if (string == null) {
            ChooseByNameBase.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Override
    public boolean canShowListForEmptyPattern() {
        return this.isShowListForEmptyPattern() || ChooseByNameBase.isShowListAfterCompletionKeyStroke() && this.lastKeyStrokeIsCompletion();
    }

    private boolean lastKeyStrokeIsCompletion() {
        return this.myTextField.isCompletionKeyStroke();
    }

    @NotNull
    private static Matcher buildPatternMatcher(@NotNull String pattern) {
        if (pattern == null) {
            ChooseByNameBase.$$$reportNull$$$0(47);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            ChooseByNameBase.$$$reportNull$$$0(48);
        }
        return minusculeMatcher;
    }

    @Override
    public int getMaximumListSizeLimit() {
        return this.myMaximumListSizeLimit;
    }

    public void setMaximumListSizeLimit(int maximumListSizeLimit) {
        this.myMaximumListSizeLimit = maximumListSizeLimit;
    }

    public void setListSizeIncreasing(int listSizeIncreasing) {
        this.myListSizeIncreasing = listSizeIncreasing;
    }

    public void setAlwaysHasMore(boolean enabled) {
        this.myAlwaysHasMore = enabled;
    }

    @NotNull
    public JTextField getTextField() {
        MyTextField myTextField = this.myTextField;
        if (myTextField == null) {
            ChooseByNameBase.$$$reportNull$$$0(49);
        }
        return myTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolArea";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ChooseByNameBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 12: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimmedText";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelElements";
                break;
            }
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statContext";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "transformPattern";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedText";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureNamesLoaded";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "statisticsContext";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenElements";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "patternToLowerCase";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternMatcher";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setToolArea";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 49: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCard";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCheckBoxShortcut";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getShortcuts";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "transformPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "rebuildList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "backgroundCalculationFinished";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCalcElements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setElementsToList";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calcSelectedIndex";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialElement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUseCount";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "appendToModel";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applySelection";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "handlePaste";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isFileName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "patternToLowerCase";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCopyReferenceAction
    extends DumbAwareAction {
        private MyCopyReferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyReferenceAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ChooseByNameBase.this.myTextField.getSelectedText() == null && ChooseByNameBase.this.getChosenElement() instanceof PsiElement);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyReferenceAction.$$$reportNull$$$0(1);
            }
            CopyReferenceAction.doCopy((PsiElement)ChooseByNameBase.this.getChosenElement(), ChooseByNameBase.this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyCopyReferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyUsageInfo2UsageAdapter
    extends UsageInfo2UsageAdapter {
        private final PsiElement myElement;
        private final boolean mySeparateGroup;

        MyUsageInfo2UsageAdapter(@NotNull PsiElement element2, final boolean separateGroup) {
            if (element2 == null) {
                MyUsageInfo2UsageAdapter.$$$reportNull$$$0(0);
            }
            super(new UsageInfo(element2){

                public boolean isDynamicUsage() {
                    return separateGroup || super.isDynamicUsage();
                }
            });
            this.myElement = element2;
            this.mySeparateGroup = separateGroup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyUsageInfo2UsageAdapter)) {
                return false;
            }
            MyUsageInfo2UsageAdapter adapter2 = (MyUsageInfo2UsageAdapter)((Object)o);
            if (this.mySeparateGroup != adapter2.mySeparateGroup) {
                return false;
            }
            return this.myElement.equals(adapter2.myElement);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + (this.mySeparateGroup ? 1 : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyUsageInfo2UsageAdapter", "<init>"));
        }
    }

    private abstract class ShowFindUsagesAction
    extends DumbAwareAction {
        ShowFindUsagesAction() {
            super(LangBundle.messagePointer((String)"action.show.all.in.view.text", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(0);
            }
            ChooseByNameBase.this.cancelListUpdater();
            final UsageViewPresentation presentation2 = new UsageViewPresentation();
            final String text2 = ChooseByNameBase.this.getTrimmedText();
            String prefixPattern = ChooseByNameBase.this.myFindUsagesTitle + " '" + text2 + "'";
            presentation2.setCodeUsagesString(prefixPattern);
            presentation2.setTabName(prefixPattern);
            presentation2.setTabText(prefixPattern);
            presentation2.setTargetsNodeText(LangBundle.message((String)"list.item.unsorted", (Object[])new Object[]{StringUtil.toLowerCase((String)ChooseByNameBase.patternToLowerCase(prefixPattern))}));
            PsiElement[] elements = this.getElements();
            final ArrayList targets2 = new ArrayList();
            final LinkedHashSet usages = new LinkedHashSet();
            this.fillUsages(Arrays.asList(elements), usages, targets2);
            if (ChooseByNameBase.this.myListModel.contains(ChooseByNameBase.EXTRA_ELEM)) {
                final boolean everywhere = ChooseByNameBase.this.myCheckBox.isSelected();
                ChooseByNameBase.this.hideHint();
                final LinkedHashSet collected = new LinkedHashSet();
                ProgressManager.getInstance().run((Task)new Task.Modal(ChooseByNameBase.this.myProject, prefixPattern, true){
                    private CalcElementsThread myCalcUsagesThread;

                    public void run(final @NotNull ProgressIndicator indicator2) {
                        if (indicator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ChooseByNameBase.this.ensureNamesLoaded(everywhere);
                        indicator2.setIndeterminate(true);
                        final TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(indicator2);
                        this.myCalcUsagesThread = new CalcElementsThread(text2, everywhere, ModalityState.NON_MODAL, PreserveSelection.INSTANCE, __ -> {}){

                            @Override
                            protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
                                if (elementsArray == null) {
                                    ShowFindUsagesAction.1.$$$reportNull$$$0(0);
                                }
                                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                                if (elementsArray.size() > 1000 - ChooseByNameBase.this.myMaximumListSizeLimit && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                    UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)indicator2, null);
                                }
                                return false;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsArray", "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1$1", "isOverflow"));
                            }
                        };
                        ApplicationManager.getApplication().runReadAction(() -> {
                            this.myCalcUsagesThread.addElementsByPattern(text2, collected, indicator2, everywhere);
                            indicator2.setText(LangBundle.message((String)"progress.text.prepare", (Object[])new Object[0]));
                            ShowFindUsagesAction.this.fillUsages(collected, usages, targets2);
                        });
                    }

                    public void onSuccess() {
                        ShowFindUsagesAction.this.showUsageView(targets2, usages, presentation2);
                    }

                    public void onCancel() {
                        this.myCalcUsagesThread.cancel();
                    }

                    public void onThrowable(@NotNull Throwable error2) {
                        if (error2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.onThrowable(error2);
                        this.myCalcUsagesThread.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                ChooseByNameBase.this.hideHint();
                this.showUsageView(targets2, usages, presentation2);
            }
        }

        private void fillUsages(@NotNull Collection<Object> matchElementsArray, @NotNull Collection<? super Usage> usages, @NotNull List<? super PsiElement> targets2) {
            if (matchElementsArray == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(1);
            }
            if (usages == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(2);
            }
            if (targets2 == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(3);
            }
            for (Object o : matchElementsArray) {
                if (!(o instanceof PsiElement)) continue;
                PsiElement element2 = (PsiElement)o;
                if (element2.getTextRange() != null) {
                    usages.add((Usage)new MyUsageInfo2UsageAdapter(element2, false));
                    continue;
                }
                targets2.add((PsiElement)element2);
            }
        }

        private void showUsageView(@NotNull List<? extends PsiElement> targets2, @NotNull Collection<? extends Usage> usages, @NotNull UsageViewPresentation presentation2) {
            if (targets2 == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(4);
            }
            if (usages == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(5);
            }
            if (presentation2 == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(6);
            }
            UsageTarget[] usageTargets = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets2));
            UsageViewManager.getInstance((Project)ChooseByNameBase.this.myProject).showUsages(usageTargets, usages.toArray(Usage.EMPTY_ARRAY), presentation2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowFindUsagesAction.$$$reportNull$$$0(7);
            }
            if (ChooseByNameBase.this.myFindUsagesTitle == null || ChooseByNameBase.this.myProject == null) {
                e.getPresentation().setVisible(false);
                return;
            }
            PsiElement[] elements = this.getElements();
            e.getPresentation().setEnabled(elements.length > 0);
        }

        public abstract PsiElement @NotNull [] getElements();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchElementsArray";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$ShowFindUsagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillUsages";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showUsageView";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class HintLabel
    extends JLabel {
        private HintLabel(@NlsContexts.Label @NotNull String text2) {
            if (text2 == null) {
                HintLabel.$$$reportNull$$$0(0);
            }
            super(text2, 4);
            this.setForeground((Color)JBColor.DARK_GRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/gotoByName/ChooseByNameBase$HintLabel", "<init>"));
        }
    }

    private class CalcElementsThread
    extends ReadTask {
        @NotNull
        private final String myPattern;
        private final boolean myCheckboxState;
        @NotNull
        private final Consumer<? super Set<?>> myCallback;
        private final ModalityState myModalityState;
        @NotNull
        private SelectionPolicy mySelectionPolicy;
        private final ProgressIndicator myProgress;
        private final Alarm myShowCardAlarm;
        private final Alarm myUpdateListAlarm;

        CalcElementsThread(String pattern, @NotNull boolean checkboxState, @NotNull ModalityState modalityState, @NotNull SelectionPolicy policy, Consumer<? super Set<?>> callback2) {
            if (pattern == null) {
                CalcElementsThread.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                CalcElementsThread.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                CalcElementsThread.$$$reportNull$$$0(2);
            }
            if (callback2 == null) {
                CalcElementsThread.$$$reportNull$$$0(3);
            }
            this.myProgress = new ProgressIndicatorBase();
            this.myShowCardAlarm = new Alarm();
            this.myUpdateListAlarm = new Alarm();
            this.myPattern = pattern;
            this.myCheckboxState = checkboxState;
            this.myCallback = callback2;
            this.myModalityState = modalityState;
            this.mySelectionPolicy = policy;
        }

        void scheduleThread() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ChooseByNameBase.this.myCalcElementsThread = this;
            this.showCard(ChooseByNameBase.SEARCHING_CARD, 200);
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, this);
        }

        @Override
        public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                CalcElementsThread.$$$reportNull$$$0(4);
            }
            if (ChooseByNameBase.this.myProject == null || DumbService.isDumbAware((Object)ChooseByNameBase.this.myModel)) {
                return super.runBackgroundProcess(indicator2);
            }
            return (ReadTask.Continuation)DumbService.getInstance((Project)ChooseByNameBase.this.myProject).runReadActionInSmartMode(() -> this.performInReadAction(indicator2));
        }

        @Override
        @Nullable
        public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
            if (indicator2 == null) {
                CalcElementsThread.$$$reportNull$$$0(5);
            }
            if (ChooseByNameBase.this.isProjectDisposed()) {
                return null;
            }
            Set<Object> elements = Collections.synchronizedSet(new LinkedHashSet());
            this.scheduleIncrementalListUpdate(elements, 0);
            boolean scopeExpanded = (Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.populateElements(elements));
            String cardToShow = elements.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : (scopeExpanded ? ChooseByNameBase.NOT_FOUND_IN_PROJECT_CARD : ChooseByNameBase.CHECK_BOX_CARD);
            AnchoredSet resultSet = new AnchoredSet(ChooseByNameBase.this.filter(elements));
            return new ReadTask.Continuation(() -> {
                if (!ChooseByNameBase.this.checkDisposed() && !this.myProgress.isCanceled()) {
                    CalcElementsThread currentBgProcess = ChooseByNameBase.this.myCalcElementsThread;
                    LOG.assertTrue(currentBgProcess == this, (Object)currentBgProcess);
                    this.showCard(cardToShow, 0);
                    Set<Object> filtered2 = resultSet.getElements();
                    ChooseByNameBase.this.backgroundCalculationFinished(filtered2, this.mySelectionPolicy);
                    this.myCallback.consume(filtered2);
                }
            }, this.myModalityState);
        }

        private void scheduleIncrementalListUpdate(@NotNull Set<Object> elements, int lastCount) {
            if (elements == null) {
                CalcElementsThread.$$$reportNull$$$0(6);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myUpdateListAlarm.addRequest(() -> {
                if (ChooseByNameBase.this.myCalcElementsThread != this || !this.myProgress.isRunning()) {
                    return;
                }
                int count = elements.size();
                if (count > lastCount) {
                    ChooseByNameBase.this.setElementsToList(this.mySelectionPolicy, new ArrayList(elements));
                    if (ChooseByNameBase.this.currentChosenInfo != null) {
                        this.mySelectionPolicy = PreserveSelection.INSTANCE;
                    }
                }
                this.scheduleIncrementalListUpdate(elements, count);
            }, 200);
        }

        private boolean populateElements(@NotNull Set<Object> elements) {
            if (elements == null) {
                CalcElementsThread.$$$reportNull$$$0(7);
            }
            boolean scopeExpanded = false;
            try {
                scopeExpanded = this.fillWithScopeExpansion(elements, this.myPattern);
                String lowerCased = ChooseByNameBase.patternToLowerCase(this.myPattern);
                if (elements.isEmpty() && !lowerCased.equals(this.myPattern)) {
                    scopeExpanded = this.fillWithScopeExpansion(elements, lowerCased);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return scopeExpanded;
        }

        private boolean fillWithScopeExpansion(@NotNull Set<Object> elements, @NotNull String pattern) {
            if (elements == null) {
                CalcElementsThread.$$$reportNull$$$0(8);
            }
            if (pattern == null) {
                CalcElementsThread.$$$reportNull$$$0(9);
            }
            this.addElementsByPattern(pattern, elements, this.myProgress, this.myCheckboxState);
            if (elements.isEmpty() && !this.myCheckboxState) {
                this.addElementsByPattern(pattern, elements, this.myProgress, true);
                return true;
            }
            return false;
        }

        @Override
        public void onCanceled(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                CalcElementsThread.$$$reportNull$$$0(10);
            }
            LOG.assertTrue(ChooseByNameBase.this.myCalcElementsThread == this, (Object)ChooseByNameBase.this.myCalcElementsThread);
            if (!ChooseByNameBase.this.isProjectDisposed() && !ChooseByNameBase.this.checkDisposed()) {
                new CalcElementsThread(this.myPattern, this.myCheckboxState, this.myModalityState, this.mySelectionPolicy, this.myCallback).scheduleThread();
            }
        }

        private void addElementsByPattern(@NotNull String pattern, @NotNull Set<Object> elements, @NotNull ProgressIndicator indicator2, boolean everywhere) {
            if (pattern == null) {
                CalcElementsThread.$$$reportNull$$$0(11);
            }
            if (elements == null) {
                CalcElementsThread.$$$reportNull$$$0(12);
            }
            if (indicator2 == null) {
                CalcElementsThread.$$$reportNull$$$0(13);
            }
            long start2 = System.currentTimeMillis();
            ChooseByNameBase.this.myProvider.filterElements(ChooseByNameBase.this, pattern, everywhere, indicator2, (Processor<Object>)((Processor)o -> {
                if (indicator2.isCanceled()) {
                    return false;
                }
                if (o == null) {
                    LOG.error("Null returned from " + ChooseByNameBase.this.myProvider + " with " + ChooseByNameBase.this.myModel + " in " + ChooseByNameBase.this);
                    return true;
                }
                elements.add(o);
                if (this.isOverflow(elements)) {
                    elements.add(ChooseByNameBase.EXTRA_ELEM);
                    return false;
                }
                return true;
            }));
            if (ChooseByNameBase.this.myAlwaysHasMore) {
                elements.add(ChooseByNameBase.EXTRA_ELEM);
            }
            if (ContributorsBasedGotoByModel.LOG.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ContributorsBasedGotoByModel.LOG.debug("addElementsByPattern(" + pattern + "): " + (end - start2) + "ms; " + elements.size() + " elements");
            }
        }

        private void showCard(@NotNull String card, int delay) {
            if (card == null) {
                CalcElementsThread.$$$reportNull$$$0(14);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myShowCardAlarm.cancelAllRequests();
            this.myShowCardAlarm.addRequest(() -> {
                if (!this.myProgress.isCanceled()) {
                    ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, card);
                }
            }, delay, this.myModalityState);
        }

        protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
            if (elementsArray == null) {
                CalcElementsThread.$$$reportNull$$$0(15);
            }
            return elementsArray.size() >= ChooseByNameBase.this.myMaximumListSizeLimit;
        }

        private void cancel() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgress.cancel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modalityState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 4: 
                case 5: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "card";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsArray";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$CalcElementsThread";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runBackgroundProcess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInReadAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleIncrementalListUpdate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "populateElements";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillWithScopeExpansion";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCanceled";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addElementsByPattern";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showCard";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverflow";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected final class MyTextField
    extends JTextField
    implements PopupOwner,
    DataProvider {
        private final KeyStroke myCompletionKeyStroke;
        private final KeyStroke forwardStroke;
        private final KeyStroke backStroke;
        private boolean completionKeyStrokeHappened;

        private MyTextField() {
            super(40);
            if (!UIUtil.isUnderDefaultMacTheme() && !UIUtil.isUnderWin10LookAndFeel()) {
                if (!(this.getUI() instanceof DarculaTextFieldUI)) {
                    this.setUI(DarculaTextFieldUI.createUI(this));
                }
                this.setBorder(new DarculaTextBorder());
            }
            this.enableEvents(8L);
            this.myCompletionKeyStroke = this.getShortcut("CodeCompletion");
            this.forwardStroke = this.getShortcut("Forward");
            this.backStroke = this.getShortcut("Back");
            this.setFocusTraversalKeysEnabled(false);
            this.putClientProperty("JTextField.variant", "search");
            this.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    super.insertString(offs, str, a);
                    if (str != null && str.length() > 1) {
                        ChooseByNameBase.this.handlePaste(str);
                    }
                }
            });
        }

        @Nullable
        private KeyStroke getShortcut(@NotNull String actionCodeCompletion) {
            Shortcut[] shortcuts;
            if (actionCodeCompletion == null) {
                MyTextField.$$$reportNull$$$0(0);
            }
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionCodeCompletion).getShortcuts()) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            }
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyTextField.$$$reportNull$$$0(1);
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return ChooseByNameBase.this.myDropdownPopup != null && ChooseByNameBase.this.myDropdownPopup.isVisible() ? ChooseByNameBase.this.myDropdownPopup : null;
            }
            if (LangDataKeys.PARENT_POPUP.is(dataId)) {
                return ChooseByNameBase.this.myTextPopup != null && ChooseByNameBase.this.myTextPopup.isVisible() ? ChooseByNameBase.this.myTextPopup : null;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyEvent(@NotNull KeyEvent e) {
            KeyStroke keyStroke;
            if (e == null) {
                MyTextField.$$$reportNull$$$0(2);
            }
            if ((keyStroke = KeyStroke.getKeyStrokeForEvent(e)).equals(this.myCompletionKeyStroke)) {
                this.completionKeyStrokeHappened = true;
                e.consume();
                String pattern = ChooseByNameBase.this.getTrimmedText();
                int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                ChooseByNameBase.this.myHistory.add((Pair<String, Integer>)Pair.create((Object)pattern, (Object)oldPos));
                Runnable postRunnable = () -> this.fillInCommonPrefix(pattern);
                ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), postRunnable);
                return;
            }
            if (keyStroke.equals(this.backStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myHistory.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair<String, Integer> last = ChooseByNameBase.this.myHistory.remove(ChooseByNameBase.this.myHistory.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)last.first);
                    ChooseByNameBase.this.myFuture.add((Pair<String, Integer>)Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            if (keyStroke.equals(this.forwardStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myFuture.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair<String, Integer> next = ChooseByNameBase.this.myFuture.remove(ChooseByNameBase.this.myFuture.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)next.first);
                    ChooseByNameBase.this.myHistory.add((Pair<String, Integer>)Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            int position = ChooseByNameBase.this.myTextField.getCaretPosition();
            int code = keyStroke.getKeyCode();
            int modifiers = keyStroke.getModifiers();
            try {
                super.processKeyEvent(e);
            }
            catch (NullPointerException e1) {
                if (!Patches.SUN_BUG_ID_6322854) {
                    throw e1;
                }
            }
            finally {
                if ((code == 38 || code == 40) && modifiers == 0) {
                    ChooseByNameBase.this.myTextField.setCaretPosition(position);
                }
            }
        }

        private void fillInCommonPrefix(@NotNull String pattern) {
            List<String> list2;
            if (pattern == null) {
                MyTextField.$$$reportNull$$$0(3);
            }
            if ((list2 = ChooseByNameBase.this.myProvider.filterNames(ChooseByNameBase.this, ChooseByNameBase.this.getNames(ChooseByNameBase.this.myCheckBox.isSelected()), pattern)).isEmpty()) {
                return;
            }
            if (this.isComplexPattern(pattern)) {
                return;
            }
            String oldText = ChooseByNameBase.this.getTrimmedText();
            int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
            String commonPrefix = null;
            if (!list2.isEmpty()) {
                for (String name : list2) {
                    String string = StringUtil.toLowerCase((String)name);
                    if (commonPrefix == null) {
                        commonPrefix = string;
                        continue;
                    }
                    while (!commonPrefix.isEmpty() && !string.startsWith(commonPrefix)) {
                        commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
                    }
                    if (!commonPrefix.isEmpty()) continue;
                    break;
                }
                commonPrefix = list2.get(0).substring(0, commonPrefix.length());
                for (int i2 = 1; i2 < list2.size(); ++i2) {
                    String string = list2.get(i2).substring(0, commonPrefix.length());
                    if (string.equals(commonPrefix)) continue;
                    commonPrefix = StringUtil.toLowerCase((String)commonPrefix);
                    break;
                }
            }
            if (commonPrefix == null) {
                commonPrefix = "";
            }
            if (!StringUtil.startsWithIgnoreCase((String)commonPrefix, (String)pattern)) {
                commonPrefix = pattern;
            }
            String newPattern = commonPrefix;
            ChooseByNameBase.this.myHistory.add((Pair<String, Integer>)Pair.create((Object)oldText, (Object)oldPos));
            ChooseByNameBase.this.myTextField.setText(newPattern);
            ChooseByNameBase.this.myTextField.setCaretPosition(newPattern.length());
            ChooseByNameBase.this.rebuildList(false);
        }

        private boolean isComplexPattern(@NotNull String pattern) {
            if (pattern == null) {
                MyTextField.$$$reportNull$$$0(4);
            }
            if (pattern.indexOf(42) >= 0) {
                return true;
            }
            for (String s : ChooseByNameBase.this.myModel.getSeparators()) {
                if (!pattern.contains(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Point getBestPopupPosition() {
            return new Point(ChooseByNameBase.this.myTextFieldPanel.getWidth(), this.getHeight());
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                MyTextField.$$$reportNull$$$0(5);
            }
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paintComponent(g);
        }

        boolean isCompletionKeyStroke() {
            return this.completionKeyStrokeHappened;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionCodeCompletion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$MyTextField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShortcut";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processKeyEvent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInCommonPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isComplexPattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class JPanelProvider
    extends JPanel
    implements DataProvider,
    QuickSearchComponent {
        private JBPopup myHint;
        private boolean myFocusRequested;

        JPanelProvider() {
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                JPanelProvider.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                return ChooseByNameBase.this.myTextField.getText();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ChooseByNameBase.this.myModel.getHelpId();
            }
            if (ChooseByNameBase.this.myCalcElementsThread != null) {
                return null;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                Object element2 = ChooseByNameBase.this.getChosenElement();
                if (element2 instanceof PsiElement) {
                    return element2;
                }
                if (element2 instanceof DataProvider) {
                    return ((DataProvider)element2).getData(dataId);
                }
            } else {
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                    ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(chosenElements.size());
                    for (Object element3 : chosenElements) {
                        if (!(element3 instanceof PsiElement)) continue;
                        result2.add((PsiElement)element3);
                    }
                    return PsiUtilCore.toPsiElementArray(result2);
                }
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    return this.getBounds();
                }
            }
            return null;
        }

        public void registerHint(@NotNull JBPopup h) {
            if (h == null) {
                JPanelProvider.$$$reportNull$$$0(1);
            }
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        boolean focusRequested() {
            boolean focusRequested = this.myFocusRequested;
            this.myFocusRequested = false;
            return focusRequested;
        }

        @Override
        public void requestFocus() {
            this.myFocusRequested = true;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        public void hideHint() {
            if (this.myHint != null) {
                this.myHint.cancel();
            }
        }

        @Nullable
        public JBPopup getHint() {
            return this.myHint;
        }

        void updateHint(PsiElement element2) {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
            if (updateProcessor != null) {
                updateProcessor.updatePopup(element2);
            }
        }

        void repositionHint() {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupPositionManager.positionPopupInBestPosition(this.myHint, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameBase$JPanelProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

