/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditorRenderingBenchmarkAction
extends AnAction
implements DumbAware {
    private static final int PERIOD = 5;
    private final NotificationGroup myNotificationGroup = NotificationGroup.logOnlyGroup((String)"editor-rendering-benchmark", (PluginId)PluginId.getId((String)"com.intellij"));

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorRenderingBenchmarkAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            this.myNotificationGroup.createNotification("No active editor", MessageType.ERROR).notify(project);
            return;
        }
        this.myNotificationGroup.createNotification(String.format("Benchmarking the editor for %s seconds...", 5), MessageType.INFO).notify(project);
        ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component2 = editor.getComponent();
            Rectangle r = component2.getVisibleRect();
            long threshold = System.currentTimeMillis() + 5000L;
            int n = 0;
            component2.setOpaque(false);
            do {
                component2.paintImmediately(r);
                ++n;
            } while (System.currentTimeMillis() < threshold);
            double fps = (double)n / 5.0;
            this.myNotificationGroup.createNotification(String.format("Benchmark results: %.1f FPS (%d x %d)", fps, r.width, r.height), MessageType.INFO).notify(project);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/performance/EditorRenderingBenchmarkAction", "actionPerformed"));
    }
}

