/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInAllowedlist;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    public static final String DEFAULT_ID = "third.party";
    private static final ActionsBuiltInAllowedlist ourAllowedList = ActionsBuiltInAllowedlist.getInstance();
    private static final Map<AnActionEvent, Stats> ourStats = ContainerUtil.createWeakMap();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context2) {
        if (context2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        ActionsCollectorImpl.recordCustomActionInvoked(null, actionId, event, context2);
    }

    public static void recordCustomActionInvoked(@Nullable Project project, @Nullable String actionId, @Nullable InputEvent event, @NotNull Class<?> context2) {
        if (context2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourAllowedList.isCustomAllowedAction(actionId) ? actionId : DEFAULT_ID;
        ActionsEventLogGroup.CUSTOM_ACTION_INVOKED.log(project, (Object)recorded, (Object)new FusInputEvent(event, null));
    }

    public void record(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        ActionsCollectorImpl.recordActionInvoked(project, action2, event, Collections.singletonList(EventFields.CurrentFile.with((Object)lang)));
    }

    public static void recordActionInvoked(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull List<EventPair<?>> customData) {
        if (customData == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        ActionsCollectorImpl.record(ActionsEventLogGroup.ACTION_FINISHED, project, action2, event, customData);
    }

    public static void record(VarargEventId eventId, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable List<EventPair<?>> customData) {
        if (action2 == null) {
            return;
        }
        PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        ArrayList data2 = new ArrayList();
        data2.add(EventFields.PluginInfoFromInstance.with((Object)action2));
        if (event != null) {
            if (action2 instanceof ToggleAction) {
                data2.add(ActionsEventLogGroup.TOGGLE_ACTION.with((Object)((ToggleAction)action2).isSelected(event)));
            }
            data2.addAll(ActionsCollectorImpl.actionEventData(event));
        }
        if (project != null && !project.isDisposed()) {
            data2.add(ActionsEventLogGroup.DUMB.with((Object)DumbService.isDumb((Project)project)));
        }
        if (customData != null) {
            data2.addAll(customData);
        }
        ActionsCollectorImpl.addActionClass(data2, action2, info2);
        eventId.log(project, data2);
    }

    @NotNull
    public static @NotNull List<@NotNull EventPair<?>> actionEventData(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        ArrayList data2 = new ArrayList();
        data2.add(EventFields.InputEvent.with((Object)FusInputEvent.from((AnActionEvent)event)));
        String place = event.getPlace();
        data2.add(EventFields.ActionPlace.with((Object)place));
        data2.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)ActionPlaces.isPopupPlace((String)place)));
        ArrayList arrayList = data2;
        if (arrayList == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static String addActionClass(@NotNull List<EventPair<?>> data2, @NotNull AnAction action2, @NotNull PluginInfo info2) {
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
        if (info2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(7);
        }
        String actionClassName = info2.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ActionsCollectorImpl.getActionId(info2, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate2 = ((ActionWithDelegate)action2).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate2.getClass());
            if (delegate2 instanceof AnAction) {
                AnAction delegateAction = (AnAction)delegate2;
                actionId = ActionsCollectorImpl.getActionId(delegateInfo, delegateAction);
            } else {
                actionId = delegateInfo.isSafeToReport() ? delegate2.getClass().getName() : DEFAULT_ID;
            }
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionId));
            data2.add(ActionsEventLogGroup.ACTION_PARENT.with((Object)actionClassName));
        } else {
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionClassName));
        }
        data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        String string = actionId;
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void addActionClass(@NotNull FeatureUsageData data2, @NotNull AnAction action2, @NotNull PluginInfo info2) {
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(9);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(10);
        }
        if (info2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
        ArrayList list2 = new ArrayList();
        ActionsCollectorImpl.addActionClass(list2, action2, info2);
        for (EventPair eventPair : list2) {
            data2.addData(eventPair.component1().getName(), eventPair.component2().toString());
        }
    }

    @NotNull
    private static String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (pluginInfo == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(12);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(13);
        }
        if (!pluginInfo.isSafeToReport()) {
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId == null && action2 instanceof ActionIdProvider) {
            actionId = ((ActionIdProvider)action2).getId();
        }
        if (actionId != null && !ActionsCollectorImpl.canReportActionId(actionId)) {
            String string = action2.getClass().getName();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (actionId == null) {
            actionId = ourAllowedList.getDynamicActionId(action2);
        }
        String string = actionId != null ? actionId : action2.getClass().getName();
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static boolean canReportActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(16);
        }
        return ourAllowedList.isAllowedActionId(actionId);
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(17);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(18);
        }
        ourAllowedList.registerDynamicActionId(action2, actionId);
    }

    public static void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable IdeaPluginDescriptor plugin2) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(19);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(20);
        }
        ourAllowedList.addActionLoadedFromXml(actionId, plugin2);
    }

    public static void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        if (keymap2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(21);
        }
        if (actionIds == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(22);
        }
        ourAllowedList.addActionsLoadedFromKeymapXml(keymap2, actionIds);
    }

    public static void onBeforeActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(23);
        }
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(24);
        }
        Project project = event.getProject();
        DataContext context2 = ActionsCollectorImpl.getCachedDataContext(event);
        Stats stats = new Stats(project, ActionsCollectorImpl.getFileLanguage(context2), ActionsCollectorImpl.getInjectedOrFileLanguage(project, context2));
        ourStats.put(event, stats);
    }

    public static void onAfterActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        Stats stats;
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(25);
        }
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(27);
        }
        long durationMillis = (stats = ourStats.remove(event)) != null ? TimeoutUtil.getDurationMillis((long)stats.start) : -1L;
        ArrayList data2 = new ArrayList();
        if (stats != null) {
            data2.add(ActionsEventLogGroup.START_TIME.with((Object)stats.startMs));
            if (stats.isDumb != null) {
                data2.add(ActionsEventLogGroup.DUMB_START.with((Object)stats.isDumb));
            }
        }
        ObjectEventData reportedResult = ActionsCollectorImpl.toReportedResult(result2);
        data2.add(ActionsEventLogGroup.RESULT.with((Object)reportedResult));
        Project project = stats != null ? (Project)stats.projectRef.get() : null;
        Language contextBefore = stats != null ? stats.fileLanguage : null;
        Language injectedContextBefore = stats != null ? stats.injectedFileLanguage : null;
        ActionsCollectorImpl.addLanguageContextFields(project, event, contextBefore, injectedContextBefore, data2);
        if (action2 instanceof FusAwareAction) {
            List<EventPair<?>> additionalUsageData = ((FusAwareAction)action2).getAdditionalUsageData(event);
            data2.add(ActionsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(additionalUsageData)));
        }
        data2.add(EventFields.DurationMs.with((Object)StatisticsUtil.INSTANCE.roundDuration(durationMillis)));
        ActionsCollectorImpl.recordActionInvoked(project, action2, event, data2);
    }

    @NotNull
    private static ObjectEventData toReportedResult(@NotNull AnActionResult result2) {
        if (result2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(28);
        }
        if (result2.isPerformed()) {
            return new ObjectEventData(new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"performed")});
        }
        if (result2 == AnActionResult.IGNORED) {
            return new ObjectEventData(new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"ignored")});
        }
        Throwable error2 = result2.getFailureCause();
        if (error2 != null) {
            return new ObjectEventData(new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"failed"), ActionsEventLogGroup.ERROR.with(error2.getClass())});
        }
        return new ObjectEventData(new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"unknown")});
    }

    private static void addLanguageContextFields(@Nullable Project project, @NotNull AnActionEvent event, @Nullable Language contextBefore, @Nullable Language injectedContextBefore, @NotNull List<EventPair<?>> data2) {
        DataContext dataContext;
        Language language;
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(29);
        }
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(30);
        }
        data2.add(EventFields.CurrentFile.with((Object)((language = ActionsCollectorImpl.getFileLanguage(dataContext = ActionsCollectorImpl.getCachedDataContext(event))) != null ? language : contextBefore)));
        Language injectedLanguage = ActionsCollectorImpl.getInjectedOrFileLanguage(project, dataContext);
        data2.add(EventFields.Language.with((Object)(injectedLanguage != null ? injectedLanguage : injectedContextBefore)));
    }

    @NotNull
    private static DataContext getCachedDataContext(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(31);
        }
        DataContext dataContext = dataId -> Utils.getRawDataIfCached(event.getDataContext(), dataId);
        if (dataContext == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(32);
        }
        return dataContext;
    }

    @Nullable
    private static Language getInjectedOrFileLanguage(@Nullable Project project, @NotNull DataContext dataContext) {
        Language injected;
        if (dataContext == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(33);
        }
        return (injected = ActionsCollectorImpl.getInjectedLanguage(dataContext, project)) != null ? injected : ActionsCollectorImpl.getFileLanguage(dataContext);
    }

    @Nullable
    private static Language getInjectedLanguage(@NotNull DataContext dataContext, @Nullable Project project) {
        PsiFile injectedFile;
        Editor editor;
        PsiFile file2;
        if (dataContext == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(34);
        }
        if ((file2 = (PsiFile)InjectedDataKeys.PSI_FILE.getData(dataContext)) != null) {
            return file2.getLanguage();
        }
        if (project != null && (editor = (Editor)InjectedDataKeys.EDITOR.getData(dataContext)) != null && !project.isDisposed() && (injectedFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editor.getDocument())) != null) {
            return injectedFile.getLanguage();
        }
        return null;
    }

    @Nullable
    private static Language getFileLanguage(@NotNull DataContext dataContext) {
        PsiFile file2;
        if (dataContext == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(35);
        }
        return (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null ? file2.getLanguage() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customData";
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 5: 
            case 9: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "actionEventData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addActionClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordCustomActionInvoked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordActionInvoked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionEventData";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: 
            case 32: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addActionClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canReportActionId";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onActionConfiguredByActionId";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onActionLoadedFromXml";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onActionsLoadedFromKeymapXml";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeActionInvoked";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onAfterActionInvoked";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toReportedResult";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageContextFields";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDataContext";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedOrFileLanguage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFileLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Stats {
        final long startMs = System.currentTimeMillis();
        final long start = System.nanoTime();
        WeakReference<Project> projectRef;
        final Boolean isDumb;
        Language fileLanguage;
        Language injectedFileLanguage;

        private Stats(@Nullable Project project, @Nullable Language fileLanguage, @Nullable Language injectedFileLanguage) {
            this.projectRef = new WeakReference<Project>(project);
            this.isDumb = project != null && !project.isDisposed() ? Boolean.valueOf(DumbService.isDumb((Project)project)) : null;
            this.fileLanguage = fileLanguage;
            this.injectedFileLanguage = injectedFileLanguage;
        }
    }
}

