/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FontSizeInfoUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.platform.ide.impl"})
public final class FontSizeInfoUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP;
    @NotNull
    private static final StringEventField FONT_NAME;
    @NotNull
    private static final IntEventField FONT_SIZE;
    @NotNull
    private static final FloatEventField LINE_SPACING;
    @NotNull
    private static final StringEventField FONT_SIZE_STRING;
    @NotNull
    private static final EventId2<String, Integer> UI_FONT;
    @NotNull
    private static final EventId1<Integer> PRESENTATION_MODE_FONT;
    @NotNull
    private static final EventId3<String, Integer, Float> EDITOR_FONT;
    @NotNull
    private static final EventId3<String, Integer, Float> IDE_EDITOR_FONT;
    @NotNull
    private static final EventId3<String, Integer, Float> CONSOLE_FONT;
    @NotNull
    private static final EventId1<String> QUICK_DOC_FONT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        String quickDocFontSize;
        boolean bl;
        Object appPrefs;
        boolean bl2;
        Collection collection;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme2 = editorColorsScheme;
        UISettings ui2 = UISettings.Companion.getShadowInstance();
        Set usages = SetsKt.mutableSetOf((Object[])new MetricEvent[]{UI_FONT.metric((Object)ui2.getFontFace(), (Object)ui2.getFontSize()), PRESENTATION_MODE_FONT.metric((Object)ui2.getPresentationModeFontSize())});
        if (!scheme2.isUseAppFontPreferencesInEditor()) {
            Collection collection2 = usages;
            collection = EDITOR_FONT.metric((Object)scheme2.getEditorFontName(), (Object)scheme2.getEditorFontSize(), (Object)Float.valueOf(scheme2.getLineSpacing()));
            bl2 = false;
            collection2.add(collection);
        } else {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences fontPreferences = appEditorFontOptions.getFontPreferences();
            Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"AppEditorFontOptions.getInstance().fontPreferences");
            appPrefs = fontPreferences;
            collection = usages;
            MetricEvent metricEvent = IDE_EDITOR_FONT.metric((Object)appPrefs.getFontFamily(), (Object)appPrefs.getSize(appPrefs.getFontFamily()), (Object)Float.valueOf(appPrefs.getLineSpacing()));
            bl = false;
            collection.add(metricEvent);
        }
        if (!scheme2.isUseEditorFontPreferencesInConsole()) {
            appPrefs = usages;
            collection = CONSOLE_FONT.metric((Object)scheme2.getConsoleFontName(), (Object)scheme2.getConsoleFontSize(), (Object)Float.valueOf(scheme2.getConsoleLineSpacing()));
            bl2 = false;
            appPrefs.add(collection);
        }
        if ((quickDocFontSize = PropertiesComponent.getInstance().getValue("quick.doc.font.size.v3")) != null) {
            collection = usages;
            MetricEvent metricEvent = QUICK_DOC_FONT.metric((Object)quickDocFontSize);
            bl = false;
            collection.add(metricEvent);
        }
        return usages;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("ui.fonts", 4);
        FONT_NAME = EventFields.String((String)"font_name", (List)CollectionsKt.arrayListOf((Object[])new String[]{"Monospaced", "Menlo", "DejaVu_Sans_Mono", ".SFNSText-Regular", "Fira_Code", "Lucida_Grande", "Source_Code_Pro", "Segoe_UI", "Ubuntu", ".SF_NS_Text", "Consolas", "Noto_Sans_Regular", "Microsoft_YaHei", "Fira_Code_Retina", "Cantarell_Regular", "Microsoft_YaHei_UI", "Monaco", "Noto_Sans", "Dialog.plain", "Fira_Code_Medium", "Courier_New", "Tahoma", "Hack", "DejaVu_Sans", "Ubuntu_Mono", "Droid_Sans_Mono", "Dialog", "Inconsolata", "Malgun_Gothic", "Cantarell", "DialogInput", "Yu_Gothic_UI_Regular", "Roboto", "Liberation_Mono", "Lucida_Console", "D2Coding", "Lucida_Sans_Typewriter", "Fira_Code_Light", "Droid_Sans", "Verdana", "Arial", "Roboto_Mono", "Segoe_UI_Semibold", "SF_Mono", "Droid_Sans_Mono_Slashed", "LucidaGrande", "Operator_Mono", "Ayuthaya", "Hasklig", "Iosevka", "Andale_Mono", "Anonymous_Pro", "Anonymous_Pro_for_Powerline", "D2Coding_ligature", "Dank_Mono", "DejaVu_Sans_Mono_for_Powerline", "Fantasque_Sans_Mono", "Fira_Mono_for_Powerline", "Hack_Nerd_Font", "IBM_Plex_Mono", "Meslo_LG_L_DZ_for_Powerline", "Meslo_LG_M_for_Powerline", "Meslo_LG_S_for_Powerline", "Microsoft_YaHei_Mono", "Noto_Mono_for_Powerline", "Noto_Sans_Mono", "PT_Mono", "PragmataPro", "SourceCodePro+Powerline+Awesome_Regular", "Source_Code_Pro_Semibold", "Source_Code_Pro_for_Powerline", "Ubuntu_Mono_derivative_Powerline", "YaHei_Consolas_Hybrid", "mononoki", "Bitstream_Vera_Sans_Mono", "Comic_Sans_MS", "Courier_10_Pitch", "Cousine", "2Coding_ligature", "Droid_Sans_Mono_Dotted", "Inconsolata-dz", "Input", "Input_Mono", "Meslo_LG_M_DZ_for_Powerline", "Migu_2M", "Monoid", "Operator_Mono_Book", "Operator_Mono_Lig", "Operator_Mono_Medium", "Abadi_MT_Condensed_Extra_Bold", "Al_Bayan", "Meiryo", "Microsoft_JhengHei", "Microsoft_Yahei_UI", "SansSerif", "Ubuntu_Light", "JetBrains_Mono", ".AppleSystemUIFont", ".SFNS-Regular"}));
        FONT_SIZE = EventFields.Int((String)"font_size");
        LINE_SPACING = EventFields.Float((String)"line_spacing");
        FONT_SIZE_STRING = EventFields.String((String)"font_size", (List)CollectionsKt.arrayListOf((Object[])new String[]{"X_SMALL", "X_LARGE", "XX_SMALL", "XX_LARGE", "SMALL", "MEDIUM", "LARGE"}));
        UI_FONT = GROUP.registerEvent("UI", (EventField)FONT_NAME, (EventField)FONT_SIZE);
        PRESENTATION_MODE_FONT = GROUP.registerEvent("Presentation.mode", (EventField)FONT_SIZE);
        EDITOR_FONT = GROUP.registerEvent("Editor", (EventField)FONT_NAME, (EventField)FONT_SIZE, (EventField)LINE_SPACING);
        IDE_EDITOR_FONT = GROUP.registerEvent("IDE.editor", (EventField)FONT_NAME, (EventField)FONT_SIZE, (EventField)LINE_SPACING);
        CONSOLE_FONT = GROUP.registerEvent("Console", (EventField)FONT_NAME, (EventField)FONT_SIZE, (EventField)LINE_SPACING);
        QUICK_DOC_FONT = GROUP.registerEvent("QuickDoc", (EventField)FONT_SIZE_STRING);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R%\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0019\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u001f\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FontSizeInfoUsageCollector$Companion;", "", "()V", "CONSOLE_FONT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "", "getCONSOLE_FONT", "()Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "EDITOR_FONT", "getEDITOR_FONT", "FONT_NAME", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFONT_NAME", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FONT_SIZE", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getFONT_SIZE", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "FONT_SIZE_STRING", "getFONT_SIZE_STRING", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "IDE_EDITOR_FONT", "getIDE_EDITOR_FONT", "LINE_SPACING", "Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "getLINE_SPACING", "()Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "PRESENTATION_MODE_FONT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "getPRESENTATION_MODE_FONT", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "QUICK_DOC_FONT", "getQUICK_DOC_FONT", "UI_FONT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "getUI_FONT", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final StringEventField getFONT_NAME() {
            return FONT_NAME;
        }

        @NotNull
        public final IntEventField getFONT_SIZE() {
            return FONT_SIZE;
        }

        @NotNull
        public final FloatEventField getLINE_SPACING() {
            return LINE_SPACING;
        }

        @NotNull
        public final StringEventField getFONT_SIZE_STRING() {
            return FONT_SIZE_STRING;
        }

        @NotNull
        public final EventId2<String, Integer> getUI_FONT() {
            return UI_FONT;
        }

        @NotNull
        public final EventId1<Integer> getPRESENTATION_MODE_FONT() {
            return PRESENTATION_MODE_FONT;
        }

        @NotNull
        public final EventId3<String, Integer, Float> getEDITOR_FONT() {
            return EDITOR_FONT;
        }

        @NotNull
        public final EventId3<String, Integer, Float> getIDE_EDITOR_FONT() {
            return IDE_EDITOR_FONT;
        }

        @NotNull
        public final EventId3<String, Integer, Float> getCONSOLE_FONT() {
            return CONSOLE_FONT;
        }

        @NotNull
        public final EventId1<String> getQUICK_DOC_FONT() {
            return QUICK_DOC_FONT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

